/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import org.killbill.billing.jaxrs.json.AuditLogJson;
import org.killbill.billing.jaxrs.json.PluginPropertyJson;
import org.killbill.billing.payment.api.PluginProperty;
import org.killbill.billing.util.audit.AuditLog;

public abstract class JsonBase {
    protected List<AuditLogJson> auditLogs;

    public JsonBase() {
        this(null);
    }

    public JsonBase(@Nullable List<AuditLogJson> auditLogs) {
        this.auditLogs = auditLogs == null ? ImmutableList.of() : auditLogs;
    }

    protected static ImmutableList<AuditLogJson> toAuditLogJson(@Nullable List<AuditLog> auditLogs) {
        if (auditLogs == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Collection)Collections2.transform(auditLogs, (Function)new Function<AuditLog, AuditLogJson>(){

            public AuditLogJson apply(@Nullable AuditLog input) {
                return new AuditLogJson(input);
            }
        }));
    }

    protected static String toString(@Nullable UUID id) {
        return id == null ? null : id.toString();
    }

    public List<AuditLogJson> getAuditLogs() {
        return this.auditLogs;
    }

    protected List<PluginProperty> propertiesToList(Map<String, String> propertiesMap) {
        LinkedList<PluginProperty> properties = new LinkedList<PluginProperty>();
        for (String key : propertiesMap.keySet()) {
            PluginProperty property = new PluginProperty(key, (Object)propertiesMap.get(key), Boolean.valueOf(false));
            properties.add(property);
        }
        return properties;
    }

    protected Map<String, Object> propertiesToMap(Iterable<PluginProperty> properties) {
        HashMap<String, Object> propertiesMap = new HashMap<String, Object>();
        for (PluginProperty pluginProperty : properties) {
            if (pluginProperty.getValue() == null) continue;
            propertiesMap.put(pluginProperty.getKey(), pluginProperty.getValue());
        }
        return propertiesMap;
    }

    protected static List<PluginPropertyJson> toPluginPropertyJson(Iterable<PluginProperty> properties) {
        ArrayList<PluginPropertyJson> pluginProperties = new ArrayList<PluginPropertyJson>();
        for (PluginProperty pluginProperty : properties) {
            pluginProperties.add(new PluginPropertyJson(pluginProperty));
        }
        return pluginProperties;
    }
}

