/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import java.math.BigDecimal;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.jaxrs.json.AuditLogJson;
import org.killbill.billing.jaxrs.json.PaymentAttemptJson;
import org.killbill.billing.jaxrs.json.PaymentJson;
import org.killbill.billing.jaxrs.json.PaymentTransactionJson;
import org.killbill.billing.payment.api.Payment;
import org.killbill.billing.util.audit.AccountAuditLogs;

@ApiModel(value="InvoicePayment")
public class InvoicePaymentJson
extends PaymentJson {
    private final UUID targetInvoiceId;

    @JsonCreator
    public InvoicePaymentJson(@JsonProperty(value="targetInvoiceId") UUID targetInvoiceId, @JsonProperty(value="accountId") UUID accountId, @JsonProperty(value="paymentId") UUID paymentId, @JsonProperty(value="paymentNumber") String paymentNumber, @JsonProperty(value="paymentExternalKey") String paymentExternalKey, @JsonProperty(value="authAmount") BigDecimal authAmount, @JsonProperty(value="capturedAmount") BigDecimal capturedAmount, @JsonProperty(value="purchasedAmount") BigDecimal purchasedAmount, @JsonProperty(value="refundedAmount") BigDecimal refundedAmount, @JsonProperty(value="creditedAmount") BigDecimal creditedAmount, @JsonProperty(value="currency") Currency currency, @JsonProperty(value="paymentMethodId") UUID paymentMethodId, @JsonProperty(value="transactions") List<? extends PaymentTransactionJson> transactions, @JsonProperty(value="paymentAttempts") List<PaymentAttemptJson> paymentAttempts, @JsonProperty(value="auditLogs") @Nullable List<AuditLogJson> auditLogs) {
        super(accountId, paymentId, paymentNumber, paymentExternalKey, authAmount, capturedAmount, purchasedAmount, refundedAmount, creditedAmount, currency, paymentMethodId, transactions, paymentAttempts, auditLogs);
        this.targetInvoiceId = targetInvoiceId;
    }

    public InvoicePaymentJson(Payment payment, @Nullable UUID invoiceId, @Nullable AccountAuditLogs accountAuditLogs) {
        super(payment, accountAuditLogs);
        this.targetInvoiceId = invoiceId;
    }

    public UUID getTargetInvoiceId() {
        return this.targetInvoiceId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InvoicePaymentJson)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InvoicePaymentJson that = (InvoicePaymentJson)o;
        return !(this.targetInvoiceId != null ? !this.targetInvoiceId.equals(that.targetInvoiceId) : that.targetInvoiceId != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.targetInvoiceId != null ? this.targetInvoiceId.hashCode() : 0);
        return result;
    }
}

