/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.swagger.annotations.ApiModel;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.shiro.util.CollectionUtils;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.invoice.api.Invoice;
import org.killbill.billing.invoice.api.InvoiceItem;
import org.killbill.billing.invoice.api.InvoiceItemType;
import org.killbill.billing.invoice.api.InvoiceStatus;
import org.killbill.billing.jaxrs.json.AuditLogJson;
import org.killbill.billing.jaxrs.json.InvoiceItemJson;
import org.killbill.billing.jaxrs.json.JsonBase;
import org.killbill.billing.util.audit.AccountAuditLogs;
import org.killbill.billing.util.audit.AuditLog;

@ApiModel(value="Invoice", parent=JsonBase.class)
public class InvoiceJson
extends JsonBase {
    private final BigDecimal amount;
    private final Currency currency;
    private final UUID invoiceId;
    private final LocalDate invoiceDate;
    private final LocalDate targetDate;
    private final String invoiceNumber;
    private final BigDecimal balance;
    private final BigDecimal creditAdj;
    private final BigDecimal refundAdj;
    private final UUID accountId;
    private final List<InvoiceItemJson> items;
    private final String bundleKeys;
    private final List<InvoiceItemJson> credits;
    private final InvoiceStatus status;
    private final Boolean isParentInvoice;
    private final UUID parentInvoiceId;
    private final UUID parentAccountId;
    private final List<String> trackingIds;

    @JsonCreator
    public InvoiceJson(@JsonProperty(value="amount") BigDecimal amount, @JsonProperty(value="currency") Currency currency, @JsonProperty(value="status") InvoiceStatus status, @JsonProperty(value="creditAdj") BigDecimal creditAdj, @JsonProperty(value="refundAdj") BigDecimal refundAdj, @JsonProperty(value="invoiceId") UUID invoiceId, @JsonProperty(value="invoiceDate") LocalDate invoiceDate, @JsonProperty(value="targetDate") LocalDate targetDate, @JsonProperty(value="invoiceNumber") String invoiceNumber, @JsonProperty(value="balance") BigDecimal balance, @JsonProperty(value="accountId") UUID accountId, @JsonProperty(value="bundleKeys") String bundleKeys, @JsonProperty(value="credits") List<InvoiceItemJson> credits, @JsonProperty(value="items") List<InvoiceItemJson> items, @JsonProperty(value="trackingIds") List<String> trackingIds, @JsonProperty(value="isParentInvoice") Boolean isParentInvoice, @JsonProperty(value="parentInvoiceId") UUID parentInvoiceId, @JsonProperty(value="parentAccountId") UUID parentAccountId, @JsonProperty(value="auditLogs") @Nullable List<AuditLogJson> auditLogs) {
        super(auditLogs);
        this.amount = amount;
        this.currency = currency;
        this.status = status;
        this.creditAdj = creditAdj;
        this.refundAdj = refundAdj;
        this.invoiceId = invoiceId;
        this.invoiceDate = invoiceDate;
        this.targetDate = targetDate;
        this.invoiceNumber = invoiceNumber;
        this.balance = balance;
        this.accountId = accountId;
        this.bundleKeys = bundleKeys;
        this.credits = credits;
        this.items = items;
        this.trackingIds = trackingIds;
        this.isParentInvoice = isParentInvoice;
        this.parentInvoiceId = parentInvoiceId;
        this.parentAccountId = parentAccountId;
    }

    public InvoiceJson(Invoice input) {
        this(input, null, null);
    }

    public InvoiceJson(Invoice input, String bundleKeys, List<InvoiceItemJson> credits, List<AuditLog> auditLogs) {
        this(input.getChargedAmount(), input.getCurrency(), input.getStatus(), input.getCreditedAmount(), input.getRefundedAmount(), input.getId(), input.getInvoiceDate(), input.getTargetDate(), String.valueOf(input.getInvoiceNumber()), input.getBalance(), input.getAccountId(), bundleKeys, credits, null, null, input.isParentInvoice(), input.getParentInvoiceId(), input.getParentAccountId(), (List<AuditLogJson>)InvoiceJson.toAuditLogJson(auditLogs));
    }

    public InvoiceJson(Invoice input, List<InvoiceItem> childItems, @Nullable AccountAuditLogs accountAuditLogs) {
        super((List<AuditLogJson>)InvoiceJson.toAuditLogJson(accountAuditLogs == null ? null : accountAuditLogs.getAuditLogsForInvoice(input.getId())));
        this.items = new ArrayList<InvoiceItemJson>(input.getInvoiceItems().size());
        for (final InvoiceItem item : input.getInvoiceItems()) {
            ImmutableList childItemsFiltered = null;
            if (item.getInvoiceItemType().equals((Object)InvoiceItemType.PARENT_SUMMARY) && !CollectionUtils.isEmpty(childItems)) {
                childItemsFiltered = ImmutableList.copyOf((Iterable)Iterables.filter(childItems, (Predicate)new Predicate<InvoiceItem>(){

                    public boolean apply(@Nullable InvoiceItem invoice) {
                        return invoice.getAccountId().equals(item.getChildAccountId());
                    }
                }));
            }
            this.items.add(new InvoiceItemJson(item, (List<InvoiceItem>)childItemsFiltered, accountAuditLogs == null ? null : accountAuditLogs.getAuditLogsForInvoiceItem(item.getId())));
        }
        this.trackingIds = input.getTrackingIds();
        this.amount = input.getChargedAmount();
        this.currency = input.getCurrency();
        this.status = input.getStatus();
        this.creditAdj = input.getCreditedAmount();
        this.refundAdj = input.getRefundedAmount();
        this.invoiceId = input.getId();
        this.invoiceDate = input.getInvoiceDate();
        this.targetDate = input.getTargetDate();
        this.invoiceNumber = input.getInvoiceNumber() == null ? null : String.valueOf(input.getInvoiceNumber());
        this.balance = input.getBalance();
        this.accountId = input.getAccountId();
        this.bundleKeys = null;
        this.credits = null;
        this.isParentInvoice = input.isParentInvoice();
        this.parentInvoiceId = input.getParentInvoiceId();
        this.parentAccountId = input.getParentAccountId();
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public UUID getInvoiceId() {
        return this.invoiceId;
    }

    public LocalDate getInvoiceDate() {
        return this.invoiceDate;
    }

    public LocalDate getTargetDate() {
        return this.targetDate;
    }

    public String getInvoiceNumber() {
        return this.invoiceNumber;
    }

    public BigDecimal getBalance() {
        return this.balance;
    }

    public BigDecimal getCreditAdj() {
        return this.creditAdj;
    }

    public BigDecimal getRefundAdj() {
        return this.refundAdj;
    }

    public UUID getAccountId() {
        return this.accountId;
    }

    public List<InvoiceItemJson> getItems() {
        return this.items;
    }

    public String getBundleKeys() {
        return this.bundleKeys;
    }

    public List<InvoiceItemJson> getCredits() {
        return this.credits;
    }

    public InvoiceStatus getStatus() {
        return this.status;
    }

    public Boolean getIsParentInvoice() {
        return this.isParentInvoice;
    }

    public UUID getParentInvoiceId() {
        return this.parentInvoiceId;
    }

    public UUID getParentAccountId() {
        return this.parentAccountId;
    }

    public List<String> getTrackingIds() {
        return this.trackingIds;
    }

    public String toString() {
        return "InvoiceJson{amount=" + this.amount + ", currency='" + this.currency + '\'' + ", status='" + this.status + '\'' + ", invoiceId='" + this.invoiceId + '\'' + ", invoiceDate=" + this.invoiceDate + ", targetDate=" + this.targetDate + ", invoiceNumber='" + this.invoiceNumber + '\'' + ", balance=" + this.balance + ", creditAdj=" + this.creditAdj + ", refundAdj=" + this.refundAdj + ", accountId='" + this.accountId + '\'' + ", items=" + this.items + ", bundleKeys='" + this.bundleKeys + '\'' + ", credits=" + this.credits + ", isParentInvoice=" + this.isParentInvoice + ", parentInvoiceId=" + this.parentInvoiceId + ", parentAccountId=" + this.parentAccountId + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvoiceJson that = (InvoiceJson)o;
        if (this.accountId != null ? !this.accountId.equals(that.accountId) : that.accountId != null) {
            return false;
        }
        if (this.amount != null ? this.amount.compareTo(that.amount) != 0 : that.amount != null) {
            return false;
        }
        if (this.balance != null ? this.balance.compareTo(that.balance) != 0 : that.balance != null) {
            return false;
        }
        if (this.bundleKeys != null ? !this.bundleKeys.equals(that.bundleKeys) : that.bundleKeys != null) {
            return false;
        }
        if (this.creditAdj != null ? this.creditAdj.compareTo(that.creditAdj) != 0 : that.creditAdj != null) {
            return false;
        }
        if (this.credits != null ? !this.credits.equals(that.credits) : that.credits != null) {
            return false;
        }
        if (this.currency != null ? !this.currency.equals((Object)that.currency) : that.currency != null) {
            return false;
        }
        if (this.invoiceDate != null ? this.invoiceDate.compareTo((ReadablePartial)that.invoiceDate) != 0 : that.invoiceDate != null) {
            return false;
        }
        if (this.invoiceId != null ? !this.invoiceId.equals(that.invoiceId) : that.invoiceId != null) {
            return false;
        }
        if (this.invoiceNumber != null ? !this.invoiceNumber.equals(that.invoiceNumber) : that.invoiceNumber != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.refundAdj != null ? this.refundAdj.compareTo(that.refundAdj) != 0 : that.refundAdj != null) {
            return false;
        }
        if (this.targetDate != null ? this.targetDate.compareTo((ReadablePartial)that.targetDate) != 0 : that.targetDate != null) {
            return false;
        }
        if (this.status != null ? !this.status.equals((Object)that.status) : that.status != null) {
            return false;
        }
        if (this.isParentInvoice != null ? !this.isParentInvoice.equals(that.isParentInvoice) : that.isParentInvoice != null) {
            return false;
        }
        if (this.parentInvoiceId != null ? !this.parentInvoiceId.equals(that.parentInvoiceId) : that.parentInvoiceId != null) {
            return false;
        }
        return !(this.parentAccountId != null ? !this.parentAccountId.equals(that.parentAccountId) : that.parentAccountId != null);
    }

    public int hashCode() {
        int result = this.amount != null ? this.amount.hashCode() : 0;
        result = 31 * result + (this.currency != null ? this.currency.hashCode() : 0);
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        result = 31 * result + (this.invoiceId != null ? this.invoiceId.hashCode() : 0);
        result = 31 * result + (this.invoiceDate != null ? this.invoiceDate.hashCode() : 0);
        result = 31 * result + (this.targetDate != null ? this.targetDate.hashCode() : 0);
        result = 31 * result + (this.invoiceNumber != null ? this.invoiceNumber.hashCode() : 0);
        result = 31 * result + (this.balance != null ? this.balance.hashCode() : 0);
        result = 31 * result + (this.creditAdj != null ? this.creditAdj.hashCode() : 0);
        result = 31 * result + (this.refundAdj != null ? this.refundAdj.hashCode() : 0);
        result = 31 * result + (this.accountId != null ? this.accountId.hashCode() : 0);
        result = 31 * result + (this.items != null ? this.items.hashCode() : 0);
        result = 31 * result + (this.bundleKeys != null ? this.bundleKeys.hashCode() : 0);
        result = 31 * result + (this.credits != null ? this.credits.hashCode() : 0);
        result = 31 * result + (this.isParentInvoice != null ? this.isParentInvoice.hashCode() : 0);
        result = 31 * result + (this.parentInvoiceId != null ? this.parentInvoiceId.hashCode() : 0);
        result = 31 * result + (this.parentAccountId != null ? this.parentAccountId.hashCode() : 0);
        return result;
    }
}

