/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.invoice.api.InvoiceItem;
import org.killbill.billing.invoice.api.InvoiceItemType;
import org.killbill.billing.jaxrs.json.AuditLogJson;
import org.killbill.billing.jaxrs.json.JsonBase;
import org.killbill.billing.util.audit.AuditLog;

@ApiModel(value="InvoiceItem", parent=JsonBase.class)
public class InvoiceItemJson
extends JsonBase {
    @ApiModelProperty(required=true)
    private final UUID invoiceItemId;
    private final UUID invoiceId;
    private final UUID linkedInvoiceItemId;
    @ApiModelProperty(required=true)
    private final UUID accountId;
    private final UUID childAccountId;
    private final UUID bundleId;
    private final UUID subscriptionId;
    private final String productName;
    private final String planName;
    private final String phaseName;
    private final String usageName;
    private final String prettyProductName;
    private final String prettyPlanName;
    private final String prettyPhaseName;
    private final String prettyUsageName;
    private final InvoiceItemType itemType;
    private final String description;
    private final LocalDate startDate;
    private final LocalDate endDate;
    private final BigDecimal amount;
    private final BigDecimal rate;
    private final Currency currency;
    private final Integer quantity;
    private final String itemDetails;
    private final DateTime catalogEffectiveDate;
    private List<InvoiceItemJson> childItems;

    @JsonCreator
    public InvoiceItemJson(@JsonProperty(value="invoiceItemId") UUID invoiceItemId, @JsonProperty(value="invoiceId") UUID invoiceId, @JsonProperty(value="linkedInvoiceItemId") UUID linkedInvoiceItemId, @JsonProperty(value="accountId") UUID accountId, @JsonProperty(value="childAccountId") UUID childAccountId, @JsonProperty(value="bundleId") UUID bundleId, @JsonProperty(value="subscriptionId") UUID subscriptionId, @JsonProperty(value="productName") String productName, @JsonProperty(value="planName") String planName, @JsonProperty(value="phaseName") String phaseName, @JsonProperty(value="usageName") String usageName, @JsonProperty(value="prettyProductName") String prettyProductName, @JsonProperty(value="prettyPlanName") String prettyPlanName, @JsonProperty(value="prettyPhaseName") String prettyPhaseName, @JsonProperty(value="prettyUsageName") String prettyUsageName, @JsonProperty(value="itemType") InvoiceItemType itemType, @JsonProperty(value="description") String description, @JsonProperty(value="startDate") LocalDate startDate, @JsonProperty(value="endDate") LocalDate endDate, @JsonProperty(value="amount") BigDecimal amount, @JsonProperty(value="rate") BigDecimal rate, @JsonProperty(value="currency") Currency currency, @JsonProperty(value="quantity") Integer quantity, @JsonProperty(value="itemDetails") String itemDetails, @JsonProperty(value="catalogEffectiveDate") DateTime catalogEffectiveDate, @JsonProperty(value="childItems") List<InvoiceItemJson> childItems, @JsonProperty(value="auditLogs") @Nullable List<AuditLogJson> auditLogs) {
        super(auditLogs);
        this.invoiceItemId = invoiceItemId;
        this.invoiceId = invoiceId;
        this.linkedInvoiceItemId = linkedInvoiceItemId;
        this.accountId = accountId;
        this.childAccountId = childAccountId;
        this.bundleId = bundleId;
        this.subscriptionId = subscriptionId;
        this.productName = productName;
        this.planName = planName;
        this.phaseName = phaseName;
        this.usageName = usageName;
        this.prettyProductName = prettyProductName;
        this.prettyPlanName = prettyPlanName;
        this.prettyPhaseName = prettyPhaseName;
        this.prettyUsageName = prettyUsageName;
        this.itemType = itemType;
        this.description = description;
        this.startDate = startDate;
        this.endDate = endDate;
        this.amount = amount;
        this.rate = rate;
        this.currency = currency;
        this.childItems = childItems;
        this.catalogEffectiveDate = catalogEffectiveDate;
        this.quantity = quantity;
        this.itemDetails = itemDetails;
    }

    public InvoiceItemJson(InvoiceItem item, List<InvoiceItem> childItems, @Nullable List<AuditLog> auditLogs) {
        this(item.getId(), item.getInvoiceId(), item.getLinkedItemId(), item.getAccountId(), item.getChildAccountId(), item.getBundleId(), item.getSubscriptionId(), item.getProductName(), item.getPlanName(), item.getPhaseName(), item.getUsageName(), item.getPrettyProductName(), item.getPrettyPlanName(), item.getPrettyPhaseName(), item.getPrettyUsageName(), item.getInvoiceItemType(), item.getDescription(), item.getStartDate(), item.getEndDate(), item.getAmount(), item.getRate(), item.getCurrency(), item.getQuantity(), item.getItemDetails(), item.getCatalogEffectiveDate(), InvoiceItemJson.toInvoiceItemJson(childItems), (List<AuditLogJson>)InvoiceItemJson.toAuditLogJson(auditLogs));
    }

    private static List<InvoiceItemJson> toInvoiceItemJson(List<InvoiceItem> childItems) {
        if (childItems == null) {
            return null;
        }
        return ImmutableList.copyOf((Collection)Collections2.transform(childItems, (Function)new Function<InvoiceItem, InvoiceItemJson>(){

            public InvoiceItemJson apply(InvoiceItem input) {
                return new InvoiceItemJson(input);
            }
        }));
    }

    public InvoiceItem toInvoiceItem() {
        return new InvoiceItem(){

            public InvoiceItemType getInvoiceItemType() {
                return InvoiceItemJson.this.itemType;
            }

            public UUID getInvoiceId() {
                return InvoiceItemJson.this.invoiceId;
            }

            public UUID getAccountId() {
                return InvoiceItemJson.this.accountId;
            }

            public UUID getChildAccountId() {
                return InvoiceItemJson.this.childAccountId;
            }

            public LocalDate getStartDate() {
                return InvoiceItemJson.this.startDate;
            }

            public LocalDate getEndDate() {
                return InvoiceItemJson.this.endDate;
            }

            public BigDecimal getAmount() {
                return InvoiceItemJson.this.amount;
            }

            public Currency getCurrency() {
                return InvoiceItemJson.this.currency;
            }

            public String getDescription() {
                return InvoiceItemJson.this.description;
            }

            public UUID getBundleId() {
                return InvoiceItemJson.this.bundleId;
            }

            public UUID getSubscriptionId() {
                return InvoiceItemJson.this.subscriptionId;
            }

            public String getProductName() {
                return InvoiceItemJson.this.productName;
            }

            public String getPrettyProductName() {
                return InvoiceItemJson.this.prettyProductName;
            }

            public String getPlanName() {
                return InvoiceItemJson.this.planName;
            }

            public String getPrettyPlanName() {
                return InvoiceItemJson.this.prettyPlanName;
            }

            public String getPhaseName() {
                return InvoiceItemJson.this.phaseName;
            }

            public String getPrettyPhaseName() {
                return InvoiceItemJson.this.prettyPhaseName;
            }

            public String getUsageName() {
                return InvoiceItemJson.this.usageName;
            }

            public String getPrettyUsageName() {
                return InvoiceItemJson.this.prettyUsageName;
            }

            public BigDecimal getRate() {
                return InvoiceItemJson.this.rate;
            }

            public UUID getLinkedItemId() {
                return InvoiceItemJson.this.linkedInvoiceItemId;
            }

            public Integer getQuantity() {
                return InvoiceItemJson.this.quantity;
            }

            public String getItemDetails() {
                return InvoiceItemJson.this.itemDetails;
            }

            public DateTime getCatalogEffectiveDate() {
                return InvoiceItemJson.this.catalogEffectiveDate;
            }

            public boolean matches(Object o) {
                return false;
            }

            public UUID getId() {
                return null;
            }

            public DateTime getCreatedDate() {
                return null;
            }

            public DateTime getUpdatedDate() {
                return null;
            }
        };
    }

    public InvoiceItemJson(InvoiceItem input) {
        this(input, null, null);
    }

    public UUID getInvoiceItemId() {
        return this.invoiceItemId;
    }

    public UUID getInvoiceId() {
        return this.invoiceId;
    }

    public UUID getLinkedInvoiceItemId() {
        return this.linkedInvoiceItemId;
    }

    public UUID getAccountId() {
        return this.accountId;
    }

    public UUID getChildAccountId() {
        return this.childAccountId;
    }

    public UUID getBundleId() {
        return this.bundleId;
    }

    public UUID getSubscriptionId() {
        return this.subscriptionId;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getPlanName() {
        return this.planName;
    }

    public String getPhaseName() {
        return this.phaseName;
    }

    public String getUsageName() {
        return this.usageName;
    }

    public String getPrettyProductName() {
        return this.prettyProductName;
    }

    public String getPrettyPlanName() {
        return this.prettyPlanName;
    }

    public String getPrettyPhaseName() {
        return this.prettyPhaseName;
    }

    public String getPrettyUsageName() {
        return this.prettyUsageName;
    }

    public InvoiceItemType getItemType() {
        return this.itemType;
    }

    public String getDescription() {
        return this.description;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public BigDecimal getRate() {
        return this.rate;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public List<InvoiceItemJson> getChildItems() {
        return this.childItems;
    }

    public DateTime getCatalogEffectiveDate() {
        return this.catalogEffectiveDate;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public String getItemDetails() {
        return this.itemDetails;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("InvoiceItemJson");
        sb.append("{invoiceItemId='").append(this.invoiceItemId).append('\'');
        sb.append(", invoiceId='").append(this.invoiceId).append('\'');
        sb.append(", linkedInvoiceItemId='").append(this.linkedInvoiceItemId).append('\'');
        sb.append(", accountId='").append(this.accountId).append('\'');
        sb.append(", childAccountId='").append(this.childAccountId).append('\'');
        sb.append(", bundleId='").append(this.bundleId).append('\'');
        sb.append(", subscriptionId='").append(this.subscriptionId).append('\'');
        sb.append(", productName='").append(this.productName).append('\'');
        sb.append(", planName='").append(this.planName).append('\'');
        sb.append(", phaseName='").append(this.phaseName).append('\'');
        sb.append(", usageName='").append(this.usageName).append('\'');
        sb.append(", description='").append(this.description).append('\'');
        sb.append(", startDate=").append(this.startDate);
        sb.append(", endDate=").append(this.endDate);
        sb.append(", amount=").append(this.amount);
        sb.append(", rate=").append(this.rate);
        sb.append(", currency=").append(this.currency);
        sb.append(", quantity=").append(this.quantity);
        sb.append(", itemDetails=").append(this.itemDetails);
        sb.append(", catalogEffectiveDate=").append(this.catalogEffectiveDate);
        sb.append(", childItems=").append(this.childItems);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvoiceItemJson that = (InvoiceItemJson)o;
        if (this.accountId != null ? !this.accountId.equals(that.accountId) : that.accountId != null) {
            return false;
        }
        if (this.childAccountId != null ? !this.childAccountId.equals(that.childAccountId) : that.childAccountId != null) {
            return false;
        }
        if (this.amount != null ? this.amount.compareTo(that.amount) != 0 : that.amount != null) {
            return false;
        }
        if (this.bundleId != null ? !this.bundleId.equals(that.bundleId) : that.bundleId != null) {
            return false;
        }
        if (this.currency != null ? !this.currency.equals((Object)that.currency) : that.currency != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (!(this.endDate == null && that.endDate == null || this.endDate != null && that.endDate != null && this.endDate.compareTo((ReadablePartial)that.endDate) == 0)) {
            return false;
        }
        if (this.invoiceItemId != null ? !this.invoiceItemId.equals(that.invoiceItemId) : that.invoiceItemId != null) {
            return false;
        }
        if (this.invoiceId != null ? !this.invoiceId.equals(that.invoiceId) : that.invoiceId != null) {
            return false;
        }
        if (this.linkedInvoiceItemId != null ? !this.linkedInvoiceItemId.equals(that.linkedInvoiceItemId) : that.linkedInvoiceItemId != null) {
            return false;
        }
        if (this.phaseName != null ? !this.phaseName.equals(that.phaseName) : that.phaseName != null) {
            return false;
        }
        if (this.usageName != null ? !this.usageName.equals(that.usageName) : that.usageName != null) {
            return false;
        }
        if (this.planName != null ? !this.planName.equals(that.planName) : that.planName != null) {
            return false;
        }
        if (this.productName != null ? !this.productName.equals(that.productName) : that.productName != null) {
            return false;
        }
        if (!(this.startDate == null && that.startDate == null || this.startDate != null && that.startDate != null && this.startDate.compareTo((ReadablePartial)that.startDate) == 0)) {
            return false;
        }
        if (this.subscriptionId != null ? !this.subscriptionId.equals(that.subscriptionId) : that.subscriptionId != null) {
            return false;
        }
        if (this.childItems != null ? !this.childItems.equals(that.childItems) : that.childItems != null) {
            return false;
        }
        if (this.quantity != null ? !this.quantity.equals(that.quantity) : that.quantity != null) {
            return false;
        }
        if (this.catalogEffectiveDate != null ? this.catalogEffectiveDate.compareTo((ReadableInstant)that.catalogEffectiveDate) != 0 : that.catalogEffectiveDate != null) {
            return false;
        }
        if (this.itemDetails != null ? !this.itemDetails.equals(that.itemDetails) : that.itemDetails != null) {
            return false;
        }
        return !(this.rate != null ? this.rate.compareTo(that.rate) != 0 : that.rate != null);
    }

    public int hashCode() {
        int result = this.invoiceId != null ? this.invoiceId.hashCode() : 0;
        result = 31 * result + (this.invoiceItemId != null ? this.invoiceItemId.hashCode() : 0);
        result = 31 * result + (this.linkedInvoiceItemId != null ? this.linkedInvoiceItemId.hashCode() : 0);
        result = 31 * result + (this.accountId != null ? this.accountId.hashCode() : 0);
        result = 31 * result + (this.childAccountId != null ? this.childAccountId.hashCode() : 0);
        result = 31 * result + (this.bundleId != null ? this.bundleId.hashCode() : 0);
        result = 31 * result + (this.subscriptionId != null ? this.subscriptionId.hashCode() : 0);
        result = 31 * result + (this.productName != null ? this.productName.hashCode() : 0);
        result = 31 * result + (this.planName != null ? this.planName.hashCode() : 0);
        result = 31 * result + (this.phaseName != null ? this.phaseName.hashCode() : 0);
        result = 31 * result + (this.usageName != null ? this.usageName.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.startDate != null ? this.startDate.hashCode() : 0);
        result = 31 * result + (this.endDate != null ? this.endDate.hashCode() : 0);
        result = 31 * result + (this.amount != null ? this.amount.hashCode() : 0);
        result = 31 * result + (this.rate != null ? this.rate.hashCode() : 0);
        result = 31 * result + (this.currency != null ? this.currency.hashCode() : 0);
        result = 31 * result + (this.quantity != null ? this.quantity.hashCode() : 0);
        result = 31 * result + (this.catalogEffectiveDate != null ? this.catalogEffectiveDate.hashCode() : 0);
        result = 31 * result + (this.itemDetails != null ? this.itemDetails.hashCode() : 0);
        result = 31 * result + (this.childItems != null ? this.childItems.hashCode() : 0);
        return result;
    }
}

