/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.core.Response;
import org.killbill.billing.jaxrs.json.JsonBase;
import org.killbill.billing.payment.plugin.api.GatewayNotification;

@ApiModel(value="GatewayNotification", parent=JsonBase.class)
public class GatewayNotificationJson
extends JsonBase {
    private final UUID kbPaymentId;
    private final Integer status;
    private final String entity;
    private final Map<String, List<String>> headers;
    private final Map<String, Object> properties;

    @JsonCreator
    public GatewayNotificationJson(@JsonProperty(value="kbPaymentId") UUID kbPaymentId, @JsonProperty(value="status") Integer status, @JsonProperty(value="entity") String entity, @JsonProperty(value="headers") Map<String, List<String>> headers, @JsonProperty(value="properties") Map<String, Object> properties) {
        this.kbPaymentId = kbPaymentId;
        this.status = status;
        this.entity = entity;
        this.headers = headers;
        this.properties = properties;
    }

    public GatewayNotificationJson(GatewayNotification notification) {
        this.kbPaymentId = notification.getKbPaymentId();
        this.status = notification.getStatus();
        this.entity = notification.getEntity();
        this.headers = notification.getHeaders();
        this.properties = this.propertiesToMap(notification.getProperties());
    }

    public Response toResponse() {
        Response.ResponseBuilder responseBuilder = Response.status((Response.Status)(this.status == null ? Response.Status.OK : Response.Status.fromStatusCode((int)this.status)));
        if (this.entity != null) {
            responseBuilder.entity((Object)this.entity);
        }
        if (this.headers != null) {
            for (String key : this.headers.keySet()) {
                if (this.headers.get(key) == null) continue;
                for (String value : this.headers.get(key)) {
                    responseBuilder.header(key, (Object)value);
                }
            }
        }
        return responseBuilder.build();
    }

    public UUID getKbPaymentId() {
        return this.kbPaymentId;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getEntity() {
        return this.entity;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("GatewayNotificationJson{");
        sb.append("kbPaymentId='").append(this.kbPaymentId).append('\'');
        sb.append(", status=").append(this.status);
        sb.append(", entity='").append(this.entity).append('\'');
        sb.append(", headers=").append(this.headers);
        sb.append(", properties=").append(this.properties);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GatewayNotificationJson that = (GatewayNotificationJson)o;
        if (this.entity != null ? !this.entity.equals(that.entity) : that.entity != null) {
            return false;
        }
        if (this.headers != null ? !this.headers.equals(that.headers) : that.headers != null) {
            return false;
        }
        if (this.kbPaymentId != null ? !this.kbPaymentId.equals(that.kbPaymentId) : that.kbPaymentId != null) {
            return false;
        }
        if (this.properties != null ? !this.properties.equals(that.properties) : that.properties != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public int hashCode() {
        int result = this.kbPaymentId != null ? this.kbPaymentId.hashCode() : 0;
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        result = 31 * result + (this.entity != null ? this.entity.hashCode() : 0);
        result = 31 * result + (this.headers != null ? this.headers.hashCode() : 0);
        result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
        return result;
    }
}

