/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.killbill.billing.ObjectType;
import org.killbill.billing.jaxrs.json.AuditLogJson;
import org.killbill.billing.jaxrs.json.JsonBase;
import org.killbill.billing.util.audit.AuditLog;
import org.killbill.billing.util.customfield.CustomField;

@ApiModel(value="CustomField", parent=JsonBase.class)
public class CustomFieldJson
extends JsonBase {
    private final UUID customFieldId;
    private final UUID objectId;
    private final ObjectType objectType;
    @ApiModelProperty(required=true)
    private final String name;
    @ApiModelProperty(required=true)
    private final String value;

    @JsonCreator
    public CustomFieldJson(@JsonProperty(value="customFieldId") UUID customFieldId, @JsonProperty(value="objectId") UUID objectId, @JsonProperty(value="objectType") ObjectType objectType, @JsonProperty(value="name") @Nullable String name, @JsonProperty(value="value") @Nullable String value, @JsonProperty(value="auditLogs") @Nullable List<AuditLogJson> auditLogs) {
        super(auditLogs);
        this.customFieldId = customFieldId;
        this.objectId = objectId;
        this.objectType = objectType;
        this.name = name;
        this.value = value;
    }

    public CustomFieldJson(CustomField input, @Nullable List<AuditLog> auditLogs) {
        this(input.getId(), input.getObjectId(), input.getObjectType(), input.getFieldName(), input.getFieldValue(), (List<AuditLogJson>)CustomFieldJson.toAuditLogJson(auditLogs));
    }

    public UUID getCustomFieldId() {
        return this.customFieldId;
    }

    public UUID getObjectId() {
        return this.objectId;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CustomFieldJson{");
        sb.append("customFieldId='").append(this.customFieldId).append('\'');
        sb.append(", objectId=").append(this.objectId);
        sb.append(", objectType=").append(this.objectType);
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", value='").append(this.value).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomFieldJson that = (CustomFieldJson)o;
        if (this.customFieldId != null ? !this.customFieldId.equals(that.customFieldId) : that.customFieldId != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.objectId != null ? !this.objectId.equals(that.objectId) : that.objectId != null) {
            return false;
        }
        if (this.objectType != that.objectType) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        int result = this.customFieldId != null ? this.customFieldId.hashCode() : 0;
        result = 31 * result + (this.objectId != null ? this.objectId.hashCode() : 0);
        result = 31 * result + (this.objectType != null ? this.objectType.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }
}

