/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import java.util.List;
import javax.annotation.Nullable;
import org.killbill.billing.jaxrs.json.AccountJson;
import org.killbill.billing.jaxrs.json.AuditLogJson;
import org.killbill.billing.jaxrs.json.ComboPaymentJson;
import org.killbill.billing.jaxrs.json.PaymentMethodJson;
import org.killbill.billing.jaxrs.json.PaymentTransactionJson;
import org.killbill.billing.jaxrs.json.PluginPropertyJson;
import org.killbill.billing.payment.api.TransactionType;

@ApiModel(value="ComboPaymentTransaction", parent=ComboPaymentJson.class)
public class ComboPaymentTransactionJson
extends ComboPaymentJson {
    private final PaymentTransactionJson transaction;
    private final List<PluginPropertyJson> transactionPluginProperties;

    @JsonCreator
    public ComboPaymentTransactionJson(@JsonProperty(value="account") AccountJson account, @JsonProperty(value="paymentMethod") PaymentMethodJson paymentMethod, @JsonProperty(value="transaction") PaymentTransactionJson transaction, @JsonProperty(value="paymentMethodPluginProperties") List<PluginPropertyJson> paymentMethodPluginProperties, @JsonProperty(value="transactionPluginProperties") List<PluginPropertyJson> transactionPluginProperties, @JsonProperty(value="auditLogs") @Nullable List<AuditLogJson> auditLogs) {
        super(account, paymentMethod, paymentMethodPluginProperties, auditLogs);
        this.transaction = transaction;
        this.transactionPluginProperties = transactionPluginProperties;
    }

    public PaymentTransactionJson getTransaction() {
        return this.transaction;
    }

    @JsonIgnore
    public TransactionType getTransactionType() {
        if (this.transaction != null) {
            return this.transaction.getTransactionType();
        }
        return null;
    }

    public List<PluginPropertyJson> getTransactionPluginProperties() {
        return this.transactionPluginProperties;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("ComboPaymentTransactionJson{");
        sb.append("transaction=").append(this.transaction);
        sb.append(", transactionPluginProperties=").append(this.transactionPluginProperties);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ComboPaymentTransactionJson that = (ComboPaymentTransactionJson)o;
        if (this.transaction != null ? !this.transaction.equals(that.transaction) : that.transaction != null) {
            return false;
        }
        return !(this.transactionPluginProperties == null ? that.transactionPluginProperties != null : !this.transactionPluginProperties.equals(that.transactionPluginProperties));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.transaction != null ? this.transaction.hashCode() : 0);
        result = 31 * result + (this.transactionPluginProperties != null ? this.transactionPluginProperties.hashCode() : 0);
        return result;
    }
}

