/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.CurrencyValueNull;
import org.killbill.billing.catalog.api.Duration;
import org.killbill.billing.catalog.api.InternationalPrice;
import org.killbill.billing.catalog.api.Limit;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.catalog.api.Price;
import org.killbill.billing.catalog.api.PriceList;
import org.killbill.billing.catalog.api.PriceListSet;
import org.killbill.billing.catalog.api.Product;
import org.killbill.billing.catalog.api.StaticCatalog;
import org.killbill.billing.catalog.api.Tier;
import org.killbill.billing.catalog.api.TieredBlock;
import org.killbill.billing.catalog.api.TimeUnit;
import org.killbill.billing.catalog.api.Unit;
import org.killbill.billing.catalog.api.Usage;

@ApiModel(value="Catalog")
public class CatalogJson {
    private final String name;
    private final Date effectiveDate;
    private final List<Currency> currencies;
    private final List<UnitJson> units;
    private final List<ProductJson> products;
    private final List<PriceListJson> priceLists;

    @JsonCreator
    public CatalogJson(@JsonProperty(value="name") String name, @JsonProperty(value="effectiveDate") Date effectiveDate, @JsonProperty(value="currencies") List<Currency> currencies, @JsonProperty(value="units") List<UnitJson> units, @JsonProperty(value="products") List<ProductJson> products, @JsonProperty(value="priceLists") List<PriceListJson> priceLists) {
        this.name = name;
        this.effectiveDate = effectiveDate;
        this.currencies = currencies;
        this.units = units;
        this.products = products;
        this.priceLists = priceLists;
    }

    public CatalogJson(StaticCatalog catalog) throws CatalogApiException {
        this.name = catalog.getCatalogName();
        this.effectiveDate = catalog.getEffectiveDate();
        this.currencies = Arrays.asList(catalog.getSupportedCurrencies());
        this.priceLists = new ArrayList<PriceListJson>();
        ArrayList<UnitJson> units = new ArrayList<UnitJson>();
        for (Unit unit : catalog.getUnits()) {
            UnitJson unitJson = new UnitJson(unit.getName(), unit.getPrettyName());
            units.add(unitJson);
        }
        this.units = units;
        Collection plans = catalog.getPlans();
        HashMap<String, ProductJson> productMap = new HashMap<String, ProductJson>();
        for (Plan plan : plans) {
            Product product = plan.getProduct();
            if (product == null) continue;
            ProductJson productJson = (ProductJson)productMap.get(product.getName());
            if (productJson == null) {
                productJson = new ProductJson(product);
                productMap.put(product.getName(), productJson);
            }
            PlanJson planJson = new PlanJson(plan);
            productJson.getPlans().add(planJson);
        }
        this.products = ImmutableList.copyOf(productMap.values());
        PriceListSet priceLists = catalog.getPriceLists();
        for (PriceList childPriceList : priceLists.getAllPriceLists()) {
            this.priceLists.add(new PriceListJson(childPriceList));
        }
    }

    private static List<PriceJson> buildPrices(InternationalPrice internationalPrice) throws CurrencyValueNull {
        Price[] prices;
        ArrayList<PriceJson> pricesJson = new ArrayList<PriceJson>();
        Price[] priceArray = prices = internationalPrice != null ? internationalPrice.getPrices() : null;
        if (prices != null && prices.length > 0) {
            for (int i = 0; i < prices.length; ++i) {
                pricesJson.add(new PriceJson(prices[i].getCurrency(), prices[i].getValue()));
            }
        }
        return pricesJson;
    }

    public List<ProductJson> getProducts() {
        return this.products;
    }

    public String getName() {
        return this.name;
    }

    public Date getEffectiveDate() {
        return this.effectiveDate;
    }

    public List<Currency> getCurrencies() {
        return this.currencies;
    }

    public List<UnitJson> getUnits() {
        return this.units;
    }

    public List<PriceListJson> getPriceLists() {
        return this.priceLists;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CatalogJson{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", effectiveDate='").append(this.effectiveDate).append('\'');
        sb.append(", currencies='").append(this.currencies).append('\'');
        sb.append(", units='").append(this.units).append('\'');
        sb.append(", products=").append(this.products);
        sb.append(", priceLists=").append(this.priceLists);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CatalogJson that = (CatalogJson)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.effectiveDate != null ? this.effectiveDate.compareTo(that.effectiveDate) != 0 : that.effectiveDate != null) {
            return false;
        }
        if (this.currencies != null ? !this.currencies.equals(that.currencies) : that.currencies != null) {
            return false;
        }
        if (this.units != null ? !this.units.equals(that.units) : that.units != null) {
            return false;
        }
        if (this.products != null ? !this.products.equals(that.products) : that.products != null) {
            return false;
        }
        return !(this.priceLists != null ? !this.priceLists.equals(that.priceLists) : that.priceLists != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
        result = 31 * result + (this.currencies != null ? this.currencies.hashCode() : 0);
        result = 31 * result + (this.units != null ? this.units.hashCode() : 0);
        result = 31 * result + (this.products != null ? this.products.hashCode() : 0);
        return result;
    }

    @ApiModel(value="Duration")
    public static class DurationJson {
        private final TimeUnit unit;
        private final int number;

        @JsonCreator
        public DurationJson(@JsonProperty(value="unit") TimeUnit unit, @JsonProperty(value="number") int number) {
            this.unit = unit;
            this.number = number;
        }

        public DurationJson(Duration duration) {
            this(duration.getUnit(), duration.getNumber());
        }

        public TimeUnit getUnit() {
            return this.unit;
        }

        public int getNumber() {
            return this.number;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("DurationJson{");
            sb.append("unit='").append(this.unit).append('\'');
            sb.append(", number=").append(this.number);
            sb.append('}');
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DurationJson that = (DurationJson)o;
            if (this.unit != null ? !this.unit.equals((Object)that.unit) : that.unit != null) {
                return false;
            }
            return this.number == that.number;
        }

        public int hashCode() {
            int result = this.unit != null ? this.unit.hashCode() : 0;
            result = 31 * result + this.number;
            return result;
        }
    }

    @ApiModel(value="PriceList")
    public static class PriceListJson {
        private String name;
        private List<String> plans;

        @JsonCreator
        public PriceListJson(@JsonProperty(value="name") String name, @JsonProperty(value="plans") List<String> plans) {
            this.name = name;
            this.plans = plans;
        }

        public PriceListJson(PriceList priceList) {
            this.name = priceList.getName();
            ArrayList<String> plans = new ArrayList<String>();
            for (Plan plan : priceList.getPlans()) {
                plans.add(plan.getName());
            }
            this.plans = plans;
        }

        public String getName() {
            return this.name;
        }

        public List<String> getPlans() {
            return this.plans;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("PriceListJson{");
            sb.append("name='").append(this.name).append('\'');
            sb.append(", plans=").append(this.plans);
            sb.append('}');
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PriceListJson that = (PriceListJson)o;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            return !(this.plans == null ? that.plans != null : !this.plans.equals(that.plans));
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.plans != null ? this.plans.hashCode() : 0);
            return result;
        }
    }

    @ApiModel(value="Price")
    public static class PriceJson {
        private final Currency currency;
        private final BigDecimal value;

        @JsonCreator
        public PriceJson(@JsonProperty(value="currency") Currency currency, @JsonProperty(value="value") BigDecimal value) {
            this.currency = currency;
            this.value = value;
        }

        public PriceJson(Price price) throws CurrencyValueNull {
            this(price.getCurrency(), price.getValue());
        }

        public Currency getCurrency() {
            return this.currency;
        }

        public BigDecimal getValue() {
            return this.value;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("PriceJson{");
            sb.append("currency='").append(this.currency).append('\'');
            sb.append(", value=").append(this.value);
            sb.append('}');
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PriceJson priceJson = (PriceJson)o;
            if (this.currency != null ? !this.currency.equals((Object)priceJson.currency) : priceJson.currency != null) {
                return false;
            }
            return !(this.value != null ? !this.value.equals(priceJson.value) : priceJson.value != null);
        }

        public int hashCode() {
            int result = this.currency != null ? this.currency.hashCode() : 0;
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }
    }

    @ApiModel(value="Phase")
    public static class PhaseJson {
        private final String type;
        private final List<PriceJson> prices;
        private final List<PriceJson> fixedPrices;
        private final DurationJson duration;
        private final List<UsageJson> usages;

        public PhaseJson(PlanPhase phase) throws CurrencyValueNull {
            LinkedList<PriceJson> prices = new LinkedList<PriceJson>();
            if (phase.getRecurring() != null && phase.getRecurring().getRecurringPrice() != null) {
                for (Price price : phase.getRecurring().getRecurringPrice().getPrices()) {
                    prices.add(new PriceJson(price));
                }
            }
            LinkedList<PriceJson> fixedPrices = new LinkedList<PriceJson>();
            if (phase.getFixed() != null && phase.getFixed().getPrice() != null) {
                for (Price price : phase.getFixed().getPrice().getPrices()) {
                    fixedPrices.add(new PriceJson(price));
                }
            }
            DurationJson durationJson = new DurationJson(phase.getDuration().getUnit(), phase.getDuration().getNumber());
            List<UsageJson> usagesJson = this.buildUsagesJson(phase.getUsages());
            this.type = phase.getPhaseType().toString();
            this.prices = prices;
            this.fixedPrices = fixedPrices;
            this.duration = durationJson;
            this.usages = usagesJson;
        }

        @JsonCreator
        public PhaseJson(@JsonProperty(value="type") String type, @JsonProperty(value="prices") List<PriceJson> prices, @JsonProperty(value="fixedPrices") List<PriceJson> fixedPrices, @JsonProperty(value="duration") DurationJson duration, @JsonProperty(value="usages") List<UsageJson> usages) {
            this.type = type;
            this.prices = prices;
            this.fixedPrices = fixedPrices;
            this.duration = duration;
            this.usages = usages;
        }

        public String getType() {
            return this.type;
        }

        public List<PriceJson> getPrices() {
            return this.prices;
        }

        public List<PriceJson> getFixedPrices() {
            return this.fixedPrices;
        }

        public DurationJson getDuration() {
            return this.duration;
        }

        public List<UsageJson> getUsages() {
            return this.usages;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("PhaseJson{");
            sb.append("type='").append(this.type).append('\'');
            sb.append(", prices=").append(this.prices);
            sb.append(", fixedPrices=").append(this.fixedPrices);
            sb.append(", duration=").append(this.duration);
            sb.append(", usages=").append(this.usages);
            sb.append('}');
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PhaseJson phaseJson = (PhaseJson)o;
            if (this.prices != null ? !this.prices.equals(phaseJson.prices) : phaseJson.prices != null) {
                return false;
            }
            if (this.fixedPrices != null ? !this.fixedPrices.equals(phaseJson.fixedPrices) : phaseJson.fixedPrices != null) {
                return false;
            }
            if (this.type != null ? !this.type.equals(phaseJson.type) : phaseJson.type != null) {
                return false;
            }
            if (this.duration != null ? !this.duration.equals(phaseJson.duration) : phaseJson.duration != null) {
                return false;
            }
            return !(this.usages != null ? !this.usages.equals(phaseJson.usages) : phaseJson.usages != null);
        }

        public int hashCode() {
            int result = this.type != null ? this.type.hashCode() : 0;
            result = 31 * result + (this.prices != null ? this.prices.hashCode() : 0);
            result = 31 * result + (this.fixedPrices != null ? this.fixedPrices.hashCode() : 0);
            result = 31 * result + (this.duration != null ? this.duration.hashCode() : 0);
            result = 31 * result + (this.usages != null ? this.usages.hashCode() : 0);
            return result;
        }

        private List<UsageJson> buildUsagesJson(Usage[] usages) throws CurrencyValueNull {
            ArrayList<UsageJson> usagesJson = new ArrayList<UsageJson>();
            for (int i = 0; i < usages.length; ++i) {
                usagesJson.add(new UsageJson(usages[i].getBillingPeriod().toString(), this.buildTiers(usages[i].getTiers())));
            }
            return usagesJson;
        }

        private List<TierJson> buildTiers(Tier[] tiers) throws CurrencyValueNull {
            ArrayList<TierJson> tiersJson = new ArrayList<TierJson>();
            if (tiers != null && tiers.length > 0) {
                for (int i = 0; i < tiers.length; ++i) {
                    tiersJson.add(new TierJson(this.buildTieredBlocks(tiers[i].getTieredBlocks()), this.buildLimits(tiers[i].getLimits()), CatalogJson.buildPrices(tiers[i].getFixedPrice()), CatalogJson.buildPrices(tiers[i].getRecurringPrice())));
                }
            }
            return tiersJson;
        }

        private List<LimitJson> buildLimits(Limit[] limits) {
            ArrayList<LimitJson> limitsJson = new ArrayList<LimitJson>();
            if (limits != null && limits.length > 0) {
                for (int i = 0; i < limits.length; ++i) {
                    limitsJson.add(new LimitJson(limits[i].getUnit().getName(), limits[i].getMax().toString(), limits[i].getMin().toString()));
                }
            }
            return limitsJson;
        }

        private List<TieredBlockJson> buildTieredBlocks(TieredBlock[] tieredBlocks) throws CurrencyValueNull {
            ArrayList<TieredBlockJson> tieredBlocksJson = new ArrayList<TieredBlockJson>();
            if (tieredBlocks != null && tieredBlocks.length > 0) {
                for (int i = 0; i < tieredBlocks.length; ++i) {
                    tieredBlocksJson.add(new TieredBlockJson(tieredBlocks[i].getUnit().getName(), tieredBlocks[i].getSize().toString(), tieredBlocks[i].getMax().toString(), CatalogJson.buildPrices(tieredBlocks[i].getPrice())));
                }
            }
            return tieredBlocksJson;
        }
    }

    @ApiModel(value="Usage")
    public static class UsageJson {
        private final String billingPeriod;
        private final List<TierJson> tiers;

        @JsonCreator
        public UsageJson(@JsonProperty(value="billingPeriod") String billingPeriod, @JsonProperty(value="tiers") List<TierJson> tiers) {
            this.billingPeriod = billingPeriod;
            this.tiers = tiers;
        }

        public String getBillingPeriod() {
            return this.billingPeriod;
        }

        public List<TierJson> getTiers() {
            return this.tiers;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("UsageJson{");
            sb.append("billingPeriod='").append(this.billingPeriod).append('\'');
            sb.append(", tiers=").append(this.tiers);
            sb.append('}');
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UsageJson usageJson = (UsageJson)o;
            if (this.billingPeriod != null ? !this.billingPeriod.equals(usageJson.billingPeriod) : usageJson.billingPeriod != null) {
                return false;
            }
            return !(this.tiers != null ? !this.tiers.equals(usageJson.tiers) : usageJson.tiers != null);
        }

        public int hashCode() {
            int result = this.billingPeriod != null ? this.billingPeriod.hashCode() : 0;
            result = 31 * result + (this.tiers != null ? this.tiers.hashCode() : 0);
            return result;
        }
    }

    @ApiModel(value="Tier")
    public static class TierJson {
        private final List<TieredBlockJson> blocks;
        private final List<LimitJson> limits;
        private final List<PriceJson> fixedPrice;
        private final List<PriceJson> recurringPrice;

        @JsonCreator
        public TierJson(@JsonProperty(value="tiers") List<TieredBlockJson> blocks, @JsonProperty(value="limits") List<LimitJson> limits, @JsonProperty(value="fixedPrice") List<PriceJson> fixedPrice, @JsonProperty(value="recurringPrice") List<PriceJson> recurringPrice) {
            this.blocks = blocks;
            this.limits = limits;
            this.fixedPrice = fixedPrice;
            this.recurringPrice = recurringPrice;
        }

        public List<TieredBlockJson> getBlocks() {
            return this.blocks;
        }

        public List<LimitJson> getLimits() {
            return this.limits;
        }

        public List<PriceJson> getFixedPrice() {
            return this.fixedPrice;
        }

        public List<PriceJson> getRecurringPrice() {
            return this.recurringPrice;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("TierJson{");
            sb.append("blocks='").append(this.blocks);
            sb.append(", limits=").append(this.limits);
            sb.append(", fixedPrice=").append(this.fixedPrice);
            sb.append(", recurringPrice=").append(this.recurringPrice);
            sb.append('}');
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TierJson tierJson = (TierJson)o;
            if (this.blocks != null ? !this.blocks.equals(tierJson.blocks) : tierJson.blocks != null) {
                return false;
            }
            if (this.limits != null ? !this.limits.equals(tierJson.limits) : tierJson.limits != null) {
                return false;
            }
            if (this.fixedPrice != null ? !this.fixedPrice.equals(tierJson.fixedPrice) : tierJson.fixedPrice != null) {
                return false;
            }
            return !(this.recurringPrice != null ? !this.recurringPrice.equals(tierJson.recurringPrice) : tierJson.recurringPrice != null);
        }

        public int hashCode() {
            int result = this.blocks != null ? this.blocks.hashCode() : 0;
            result = 31 * result + (this.limits != null ? this.limits.hashCode() : 0);
            result = 31 * result + (this.fixedPrice != null ? this.fixedPrice.hashCode() : 0);
            result = 31 * result + (this.recurringPrice != null ? this.recurringPrice.hashCode() : 0);
            return result;
        }
    }

    @ApiModel(value="Limit")
    public static class LimitJson {
        private final String unit;
        private final String max;
        private final String min;

        @JsonCreator
        public LimitJson(@JsonProperty(value="unit") String unit, @JsonProperty(value="max") String max, @JsonProperty(value="min") String min) {
            this.unit = unit;
            this.max = max;
            this.min = min;
        }

        public String getUnit() {
            return this.unit;
        }

        public String getMax() {
            return this.max;
        }

        public String getMin() {
            return this.min;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("LimitJson{");
            sb.append("unit='").append(this.unit).append('\'');
            sb.append(", max=").append(this.max);
            sb.append(", min=").append(this.min);
            sb.append('}');
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LimitJson limitJson = (LimitJson)o;
            if (this.unit != null ? !this.unit.equals(limitJson.unit) : limitJson.unit != null) {
                return false;
            }
            if (this.min != null ? !this.min.equals(limitJson.min) : limitJson.min != null) {
                return false;
            }
            return !(this.max != null ? !this.max.equals(limitJson.max) : limitJson.max != null);
        }

        public int hashCode() {
            int result = this.unit != null ? this.unit.hashCode() : 0;
            result = 31 * result + (this.max != null ? this.max.hashCode() : 0);
            result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
            return result;
        }
    }

    @ApiModel(value="TieredBlock")
    public static class TieredBlockJson {
        private final String unit;
        private final String size;
        private final String max;
        private final List<PriceJson> prices;

        @JsonCreator
        public TieredBlockJson(@JsonProperty(value="unit") String unit, @JsonProperty(value="size") String size, @JsonProperty(value="max") String max, @JsonProperty(value="prices") List<PriceJson> prices) {
            this.unit = unit;
            this.size = size;
            this.max = max;
            this.prices = prices;
        }

        public String getUnit() {
            return this.unit;
        }

        public String getSize() {
            return this.size;
        }

        public String getMax() {
            return this.max;
        }

        public List<PriceJson> getPrices() {
            return this.prices;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("TieredBlockJson{");
            sb.append("unit='").append(this.unit).append('\'');
            sb.append(", size=").append(this.size);
            sb.append(", max=").append(this.max);
            sb.append(", prices=").append(this.prices);
            sb.append('}');
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TieredBlockJson blockJson = (TieredBlockJson)o;
            if (this.unit != null ? !this.unit.equals(blockJson.unit) : blockJson.unit != null) {
                return false;
            }
            if (this.size != null ? !this.size.equals(blockJson.size) : blockJson.size != null) {
                return false;
            }
            if (this.max != null ? !this.max.equals(blockJson.max) : blockJson.max != null) {
                return false;
            }
            return !(this.prices != null ? !this.prices.equals(blockJson.prices) : blockJson.prices != null);
        }

        public int hashCode() {
            int result = this.unit != null ? this.unit.hashCode() : 0;
            result = 31 * result + (this.size != null ? this.size.hashCode() : 0);
            result = 31 * result + (this.max != null ? this.max.hashCode() : 0);
            result = 31 * result + (this.prices != null ? this.prices.hashCode() : 0);
            return result;
        }
    }

    @ApiModel(value="Plan")
    public static class PlanJson {
        private final String name;
        private final String prettyName;
        private final BillingPeriod billingPeriod;
        private final List<PhaseJson> phases;

        public PlanJson(Plan plan) throws CurrencyValueNull {
            LinkedList<PhaseJson> phases = new LinkedList<PhaseJson>();
            for (PlanPhase phase : plan.getAllPhases()) {
                PhaseJson phaseJson = new PhaseJson(phase);
                phases.add(phaseJson);
            }
            this.name = plan.getName();
            this.prettyName = plan.getPrettyName();
            this.billingPeriod = plan.getRecurringBillingPeriod();
            this.phases = phases;
        }

        @JsonCreator
        public PlanJson(@JsonProperty(value="name") String name, @JsonProperty(value="prettyName") String prettyName, @JsonProperty(value="billingPeriod") BillingPeriod billingPeriod, @JsonProperty(value="phases") List<PhaseJson> phases) {
            this.name = name;
            this.prettyName = prettyName;
            this.billingPeriod = billingPeriod;
            this.phases = phases;
        }

        public String getName() {
            return this.name;
        }

        public String getPrettyName() {
            return this.prettyName;
        }

        public BillingPeriod getBillingPeriod() {
            return this.billingPeriod;
        }

        public List<PhaseJson> getPhases() {
            return this.phases;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("PlanJson{");
            sb.append("name='").append(this.name).append('\'');
            sb.append("prettyName='").append(this.prettyName).append('\'');
            sb.append("billingPeriod='").append(this.billingPeriod).append('\'');
            sb.append(", phases=").append(this.phases);
            sb.append('}');
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlanJson planJson = (PlanJson)o;
            if (this.name != null ? !this.name.equals(planJson.name) : planJson.name != null) {
                return false;
            }
            if (this.billingPeriod != null ? !this.billingPeriod.equals((Object)planJson.billingPeriod) : planJson.billingPeriod != null) {
                return false;
            }
            return !(this.phases != null ? !this.phases.equals(planJson.phases) : planJson.phases != null);
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.billingPeriod != null ? this.billingPeriod.hashCode() : 0);
            result = 31 * result + (this.phases != null ? this.phases.hashCode() : 0);
            return result;
        }
    }

    @ApiModel(value="Product")
    public static class ProductJson {
        private final String type;
        private final String name;
        private final String prettyName;
        private final List<PlanJson> plans;
        private final List<String> included;
        private final List<String> available;

        @JsonCreator
        public ProductJson(@JsonProperty(value="type") String type, @JsonProperty(value="name") String name, @JsonProperty(value="prettyName") String prettyName, @JsonProperty(value="plans") List<PlanJson> plans, @JsonProperty(value="included") List<String> included, @JsonProperty(value="available") List<String> available) {
            this.type = type;
            this.name = name;
            this.prettyName = prettyName;
            this.plans = plans;
            this.included = included;
            this.available = available;
        }

        public ProductJson(Product product) {
            this.type = product.getCategory().toString();
            this.name = product.getName();
            this.prettyName = product.getPrettyName();
            this.plans = new LinkedList<PlanJson>();
            this.included = this.toProductNames(product.getIncluded());
            this.available = this.toProductNames(product.getAvailable());
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public String getPrettyName() {
            return this.prettyName;
        }

        public List<PlanJson> getPlans() {
            return this.plans;
        }

        public List<String> getIncluded() {
            return this.included;
        }

        public List<String> getAvailable() {
            return this.available;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("ProductJson{");
            sb.append("type='").append(this.type).append('\'');
            sb.append(", name='").append(this.name).append('\'');
            sb.append(", prettyName='").append(this.prettyName).append('\'');
            sb.append(", plans=").append(this.plans);
            sb.append(", included=").append(this.included);
            sb.append(", available=").append(this.available);
            sb.append('}');
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProductJson that = (ProductJson)o;
            if (this.available != null ? !this.available.equals(that.available) : that.available != null) {
                return false;
            }
            if (this.included != null ? !this.included.equals(that.included) : that.included != null) {
                return false;
            }
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            if (this.plans != null ? !this.plans.equals(that.plans) : that.plans != null) {
                return false;
            }
            return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
        }

        public int hashCode() {
            int result = this.type != null ? this.type.hashCode() : 0;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.plans != null ? this.plans.hashCode() : 0);
            result = 31 * result + (this.included != null ? this.included.hashCode() : 0);
            result = 31 * result + (this.available != null ? this.available.hashCode() : 0);
            return result;
        }

        private List<String> toProductNames(Collection<Product> in) {
            return Lists.transform((List)ImmutableList.copyOf(in), (Function)new Function<Product, String>(){

                public String apply(Product input) {
                    return input.getName();
                }
            });
        }
    }

    @ApiModel(value="Unit")
    public static class UnitJson {
        private final String name;
        private final String prettyName;

        @JsonCreator
        public UnitJson(@JsonProperty(value="name") String name, @JsonProperty(value="prettyName") String prettyName) {
            this.name = name;
            this.prettyName = prettyName;
        }

        public String getName() {
            return this.name;
        }

        public String getPrettyName() {
            return this.prettyName;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("UnitJson{");
            sb.append("name='").append(this.name).append('\'');
            sb.append(", prettyName='").append(this.prettyName).append('\'');
            sb.append('}');
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UnitJson unitJson = (UnitJson)o;
            if (this.name != null ? !this.name.equals(unitJson.name) : unitJson.name != null) {
                return false;
            }
            return this.prettyName != null ? this.prettyName.equals(unitJson.prettyName) : unitJson.prettyName == null;
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.prettyName != null ? this.prettyName.hashCode() : 0);
            return result;
        }
    }
}

