/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.killbill.billing.entitlement.api.SubscriptionBundleTimeline;
import org.killbill.billing.entitlement.api.SubscriptionEvent;
import org.killbill.billing.jaxrs.json.AuditLogJson;
import org.killbill.billing.jaxrs.json.JsonBase;
import org.killbill.billing.jaxrs.json.SubscriptionJson;
import org.killbill.billing.util.audit.AccountAuditLogs;

@ApiModel(value="BundleTimeline", parent=JsonBase.class)
public class BundleTimelineJson
extends JsonBase {
    private final UUID accountId;
    private final UUID bundleId;
    private final String externalKey;
    private final List<SubscriptionJson.EventSubscriptionJson> events;

    @JsonCreator
    public BundleTimelineJson(@JsonProperty(value="accountId") @Nullable UUID accountId, @JsonProperty(value="bundleId") @Nullable UUID bundleId, @JsonProperty(value="externalKey") @Nullable String externalKey, @JsonProperty(value="events") @Nullable List<SubscriptionJson.EventSubscriptionJson> events, @JsonProperty(value="auditLogs") @Nullable List<AuditLogJson> auditLogs) {
        super(auditLogs);
        this.accountId = accountId;
        this.bundleId = bundleId;
        this.externalKey = externalKey;
        this.events = events;
    }

    public BundleTimelineJson(SubscriptionBundleTimeline bundleTimeline, @Nullable AccountAuditLogs accountAuditLogs) {
        super((List<AuditLogJson>)BundleTimelineJson.toAuditLogJson(accountAuditLogs == null ? null : accountAuditLogs.getAuditLogsForBundle(bundleTimeline.getBundleId())));
        this.accountId = bundleTimeline.getAccountId();
        this.bundleId = bundleTimeline.getBundleId();
        this.externalKey = bundleTimeline.getExternalKey();
        this.events = new LinkedList<SubscriptionJson.EventSubscriptionJson>();
        for (SubscriptionEvent subscriptionEvent : bundleTimeline.getSubscriptionEvents()) {
            this.events.add(new SubscriptionJson.EventSubscriptionJson(subscriptionEvent, accountAuditLogs));
        }
    }

    public UUID getAccountId() {
        return this.accountId;
    }

    public UUID getBundleId() {
        return this.bundleId;
    }

    public String getExternalKey() {
        return this.externalKey;
    }

    public List<SubscriptionJson.EventSubscriptionJson> getEvents() {
        return this.events;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BundleTimelineJson{");
        sb.append("accountId='").append(this.accountId).append('\'');
        sb.append(", bundleId='").append(this.bundleId).append('\'');
        sb.append(", externalKey='").append(this.externalKey).append('\'');
        sb.append(", events=").append(this.events);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BundleTimelineJson that = (BundleTimelineJson)o;
        if (this.accountId != null ? !this.accountId.equals(that.accountId) : that.accountId != null) {
            return false;
        }
        if (this.bundleId != null ? !this.bundleId.equals(that.bundleId) : that.bundleId != null) {
            return false;
        }
        if (this.events != null ? !this.events.equals(that.events) : that.events != null) {
            return false;
        }
        return !(this.externalKey != null ? !this.externalKey.equals(that.externalKey) : that.externalKey != null);
    }

    public int hashCode() {
        int result = this.accountId != null ? this.accountId.hashCode() : 0;
        result = 31 * result + (this.bundleId != null ? this.bundleId.hashCode() : 0);
        result = 31 * result + (this.externalKey != null ? this.externalKey.hashCode() : 0);
        result = 31 * result + (this.events != null ? this.events.hashCode() : 0);
        return result;
    }
}

