/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.entitlement.api.Subscription;
import org.killbill.billing.entitlement.api.SubscriptionBundle;
import org.killbill.billing.jaxrs.json.AuditLogJson;
import org.killbill.billing.jaxrs.json.BundleTimelineJson;
import org.killbill.billing.jaxrs.json.JsonBase;
import org.killbill.billing.jaxrs.json.SubscriptionJson;
import org.killbill.billing.util.audit.AccountAuditLogs;

@ApiModel(value="Bundle", parent=JsonBase.class)
public class BundleJson
extends JsonBase {
    @ApiModelProperty(required=true)
    private final UUID accountId;
    private final UUID bundleId;
    private final String externalKey;
    private final List<SubscriptionJson> subscriptions;
    private final BundleTimelineJson timeline;

    @JsonCreator
    public BundleJson(@JsonProperty(value="accountId") @Nullable UUID accountId, @JsonProperty(value="bundleId") @Nullable UUID bundleId, @JsonProperty(value="externalKey") @Nullable String externalKey, @JsonProperty(value="subscriptions") @Nullable List<SubscriptionJson> subscriptions, @JsonProperty(value="timeline") @Nullable BundleTimelineJson timeline, @JsonProperty(value="auditLogs") @Nullable List<AuditLogJson> auditLogs) {
        super(auditLogs);
        this.accountId = accountId;
        this.bundleId = bundleId;
        this.externalKey = externalKey;
        this.subscriptions = subscriptions;
        this.timeline = timeline;
    }

    public BundleJson(SubscriptionBundle bundle, @Nullable Currency currency, @Nullable AccountAuditLogs accountAuditLogs) throws CatalogApiException {
        super((List<AuditLogJson>)BundleJson.toAuditLogJson(accountAuditLogs == null ? null : accountAuditLogs.getAuditLogsForBundle(bundle.getId())));
        this.accountId = bundle.getAccountId();
        this.bundleId = bundle.getId();
        this.externalKey = bundle.getExternalKey();
        this.subscriptions = new LinkedList<SubscriptionJson>();
        for (Subscription subscription : bundle.getSubscriptions()) {
            this.subscriptions.add(new SubscriptionJson(subscription, currency, accountAuditLogs));
        }
        this.timeline = new BundleTimelineJson(bundle.getTimeline(), accountAuditLogs);
    }

    public List<SubscriptionJson> getSubscriptions() {
        return this.subscriptions;
    }

    public UUID getAccountId() {
        return this.accountId;
    }

    public UUID getBundleId() {
        return this.bundleId;
    }

    public String getExternalKey() {
        return this.externalKey;
    }

    public BundleTimelineJson getTimeline() {
        return this.timeline;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BundleJson{");
        sb.append("accountId='").append(this.accountId).append('\'');
        sb.append(", bundleId='").append(this.bundleId).append('\'');
        sb.append(", externalKey='").append(this.externalKey).append('\'');
        sb.append(", subscriptions=").append(this.subscriptions);
        sb.append(", timeline=").append(this.timeline);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BundleJson that = (BundleJson)o;
        if (this.accountId != null ? !this.accountId.equals(that.accountId) : that.accountId != null) {
            return false;
        }
        if (this.bundleId != null ? !this.bundleId.equals(that.bundleId) : that.bundleId != null) {
            return false;
        }
        if (this.externalKey != null ? !this.externalKey.equals(that.externalKey) : that.externalKey != null) {
            return false;
        }
        if (this.subscriptions != null ? !this.subscriptions.equals(that.subscriptions) : that.subscriptions != null) {
            return false;
        }
        return !(this.timeline != null ? !this.timeline.equals(that.timeline) : that.timeline != null);
    }

    public int hashCode() {
        int result = this.accountId != null ? this.accountId.hashCode() : 0;
        result = 31 * result + (this.bundleId != null ? this.bundleId.hashCode() : 0);
        result = 31 * result + (this.externalKey != null ? this.externalKey.hashCode() : 0);
        result = 31 * result + (this.subscriptions != null ? this.subscriptions.hashCode() : 0);
        result = 31 * result + (this.timeline != null ? this.timeline.hashCode() : 0);
        return result;
    }
}

