/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.killbill.billing.entitlement.api.BlockingState;
import org.killbill.billing.entitlement.api.BlockingStateType;
import org.killbill.billing.jaxrs.json.AuditLogJson;
import org.killbill.billing.jaxrs.json.JsonBase;
import org.killbill.billing.util.audit.AccountAuditLogs;

@ApiModel(value="BlockingState", parent=JsonBase.class)
public class BlockingStateJson
extends JsonBase {
    private final UUID blockedId;
    private final String stateName;
    private final String service;
    private final Boolean isBlockChange;
    private final Boolean isBlockEntitlement;
    private final Boolean isBlockBilling;
    private final DateTime effectiveDate;
    private final BlockingStateType type;

    @JsonCreator
    public BlockingStateJson(@JsonProperty(value="blockedId") UUID blockedId, @JsonProperty(value="stateName") String stateName, @JsonProperty(value="service") String service, @JsonProperty(value="isBlockChange") Boolean isBlockChange, @JsonProperty(value="isBlockEntitlement") Boolean isBlockEntitlement, @JsonProperty(value="isBlockBilling") Boolean isBlockBilling, @JsonProperty(value="effectiveDate") DateTime effectiveDate, @JsonProperty(value="type") BlockingStateType type, @JsonProperty(value="auditLogs") @Nullable List<AuditLogJson> auditLogs) {
        super(auditLogs);
        this.blockedId = blockedId;
        this.stateName = stateName;
        this.service = service;
        this.isBlockChange = isBlockChange;
        this.isBlockEntitlement = isBlockEntitlement;
        this.isBlockBilling = isBlockBilling;
        this.effectiveDate = effectiveDate;
        this.type = type;
    }

    public BlockingStateJson(BlockingState input, AccountAuditLogs accountAuditLogs) {
        this(input.getBlockedId(), input.getStateName(), input.getService(), input.isBlockChange(), input.isBlockEntitlement(), input.isBlockBilling(), input.getEffectiveDate(), input.getType(), (List<AuditLogJson>)BlockingStateJson.toAuditLogJson(accountAuditLogs == null ? null : accountAuditLogs.getAuditLogsForBlockingState(input.getId())));
    }

    public UUID getBlockedId() {
        return this.blockedId;
    }

    public String getStateName() {
        return this.stateName;
    }

    public String getService() {
        return this.service;
    }

    @JsonProperty(value="isBlockChange")
    public Boolean isBlockChange() {
        return this.isBlockChange;
    }

    @JsonProperty(value="isBlockEntitlement")
    public Boolean isBlockEntitlement() {
        return this.isBlockEntitlement;
    }

    @JsonProperty(value="isBlockBilling")
    public Boolean isBlockBilling() {
        return this.isBlockBilling;
    }

    public DateTime getEffectiveDate() {
        return this.effectiveDate;
    }

    public BlockingStateType getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BlockingStateJson)) {
            return false;
        }
        BlockingStateJson that = (BlockingStateJson)o;
        if (this.isBlockChange != that.isBlockChange) {
            return false;
        }
        if (this.isBlockEntitlement != that.isBlockEntitlement) {
            return false;
        }
        if (this.isBlockBilling != that.isBlockBilling) {
            return false;
        }
        if (this.blockedId != null ? !this.blockedId.equals(that.blockedId) : that.blockedId != null) {
            return false;
        }
        if (this.stateName != null ? !this.stateName.equals(that.stateName) : that.stateName != null) {
            return false;
        }
        if (this.service != null ? !this.service.equals(that.service) : that.service != null) {
            return false;
        }
        if (this.effectiveDate != null ? this.effectiveDate.compareTo((ReadableInstant)that.effectiveDate) != 0 : that.effectiveDate != null) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = this.blockedId != null ? this.blockedId.hashCode() : 0;
        result = 31 * result + (this.stateName != null ? this.stateName.hashCode() : 0);
        result = 31 * result + (this.service != null ? this.service.hashCode() : 0);
        result = 31 * result + (this.isBlockChange != false ? 1 : 0);
        result = 31 * result + (this.isBlockEntitlement != false ? 1 : 0);
        result = 31 * result + (this.isBlockBilling != false ? 1 : 0);
        result = 31 * result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "BlockingStateJson{blockedId='" + this.blockedId + '\'' + ", stateName='" + this.stateName + '\'' + ", service='" + this.service + '\'' + ", isBlockChange=" + this.isBlockChange + ", isBlockEntitlement=" + this.isBlockEntitlement + ", isBlockBilling=" + this.isBlockBilling + ", effectiveDate=" + this.effectiveDate + ", type=" + this.type + '}';
    }
}

