/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.killbill.billing.ObjectType;
import org.killbill.billing.util.audit.AuditLog;
import org.killbill.billing.util.audit.AuditLogWithHistory;
import org.killbill.billing.util.entity.Entity;

@ApiModel(value="AuditLog")
public class AuditLogJson {
    private final String changeType;
    @ApiModelProperty(dataType="org.joda.time.DateTime")
    private final DateTime changeDate;
    private final String changedBy;
    private final String reasonCode;
    private final String comments;
    private final String userToken;
    private final ObjectType objectType;
    private final UUID objectId;
    private final Entity history;

    @JsonCreator
    public AuditLogJson(@JsonProperty(value="changeType") String changeType, @JsonProperty(value="changeDate") DateTime changeDate, @JsonProperty(value="objectType") ObjectType objectType, @JsonProperty(value="objectId") UUID objectId, @JsonProperty(value="changedBy") String changedBy, @JsonProperty(value="reasonCode") String reasonCode, @JsonProperty(value="comments") String comments, @JsonProperty(value="userToken") String userToken, @JsonProperty(value="history") Entity history) {
        this.changeType = changeType;
        this.changeDate = changeDate;
        this.changedBy = changedBy;
        this.reasonCode = reasonCode;
        this.comments = comments;
        this.userToken = userToken;
        this.objectType = objectType;
        this.objectId = objectId;
        this.history = history;
    }

    public AuditLogJson(AuditLogWithHistory auditLogWithHistory) {
        this(auditLogWithHistory.getChangeType().toString(), auditLogWithHistory.getCreatedDate(), auditLogWithHistory.getAuditedObjectType(), auditLogWithHistory.getAuditedEntityId(), auditLogWithHistory.getUserName(), auditLogWithHistory.getReasonCode(), auditLogWithHistory.getComment(), auditLogWithHistory.getUserToken(), auditLogWithHistory.getEntity());
    }

    public AuditLogJson(AuditLog auditLog) {
        this(auditLog.getChangeType().toString(), auditLog.getCreatedDate(), auditLog.getAuditedObjectType(), auditLog.getAuditedEntityId(), auditLog.getUserName(), auditLog.getReasonCode(), auditLog.getComment(), auditLog.getUserToken(), null);
    }

    public String getChangeType() {
        return this.changeType;
    }

    public DateTime getChangeDate() {
        return this.changeDate;
    }

    public String getChangedBy() {
        return this.changedBy;
    }

    public String getReasonCode() {
        return this.reasonCode;
    }

    public String getComments() {
        return this.comments;
    }

    public String getUserToken() {
        return this.userToken;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public UUID getObjectId() {
        return this.objectId;
    }

    public Entity getHistory() {
        return this.history;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AuditLogJson");
        sb.append("{changeType='").append(this.changeType).append('\'');
        sb.append(", changeDate=").append(this.changeDate);
        sb.append(", objectType='").append(this.objectType).append('\'');
        sb.append(", objectId='").append(this.objectId).append('\'');
        sb.append(", changedBy=").append(this.changedBy);
        sb.append(", reasonCode='").append(this.reasonCode).append('\'');
        sb.append(", comments='").append(this.comments).append('\'');
        sb.append(", userToken='").append(this.userToken).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuditLogJson that = (AuditLogJson)o;
        if (this.changeDate != null ? this.changeDate.compareTo((ReadableInstant)that.changeDate) != 0 : that.changeDate != null) {
            return false;
        }
        if (this.changeType != null ? !this.changeType.equals(that.changeType) : that.changeType != null) {
            return false;
        }
        if (this.changedBy != null ? !this.changedBy.equals(that.changedBy) : that.changedBy != null) {
            return false;
        }
        if (this.comments != null ? !this.comments.equals(that.comments) : that.comments != null) {
            return false;
        }
        if (this.reasonCode != null ? !this.reasonCode.equals(that.reasonCode) : that.reasonCode != null) {
            return false;
        }
        if (this.userToken != null ? !this.userToken.equals(that.userToken) : that.userToken != null) {
            return false;
        }
        if (this.objectType != that.objectType) {
            return false;
        }
        return !(this.objectId != null ? !this.objectId.equals(that.objectId) : that.objectId != null);
    }

    public int hashCode() {
        int result = this.changeType != null ? this.changeType.hashCode() : 0;
        result = 31 * result + (this.changeDate != null ? this.changeDate.hashCode() : 0);
        result = 31 * result + (this.changedBy != null ? this.changedBy.hashCode() : 0);
        result = 31 * result + (this.reasonCode != null ? this.reasonCode.hashCode() : 0);
        result = 31 * result + (this.comments != null ? this.comments.hashCode() : 0);
        result = 31 * result + (this.userToken != null ? this.userToken.hashCode() : 0);
        result = 31 * result + (this.objectType != null ? this.objectType.hashCode() : 0);
        result = 31 * result + (this.objectId != null ? this.objectId.hashCode() : 0);
        return result;
    }
}

