/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.util.List;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.PhaseType;
import org.killbill.billing.catalog.api.ProductCategory;
import org.killbill.billing.entitlement.api.Entitlement;
import org.killbill.billing.entitlement.api.SubscriptionEventType;
import org.killbill.billing.jaxrs.JaxrsTestSuiteNoDB;
import org.killbill.billing.jaxrs.JaxrsTestUtils;
import org.killbill.billing.jaxrs.json.AuditLogJson;
import org.killbill.billing.jaxrs.json.PhasePriceJson;
import org.killbill.billing.jaxrs.json.SubscriptionJson;
import org.killbill.clock.DefaultClock;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestEntitlementJsonWithEvents
extends JaxrsTestSuiteNoDB {
    @Test(groups={"fast"})
    public void testJson() throws Exception {
        String externalKey = UUID.randomUUID().toString();
        DateTime effectiveDate = DefaultClock.toUTCDateTime((DateTime)new DateTime(DateTimeZone.UTC));
        UUID eventId = UUID.randomUUID();
        List<AuditLogJson> auditLogs = JaxrsTestUtils.createAuditLogsJson(this.clock.getUTCNow());
        SubscriptionJson.EventSubscriptionJson newEvent = new SubscriptionJson.EventSubscriptionJson(eventId, BillingPeriod.NO_BILLING_PERIOD, effectiveDate.toLocalDate(), UUID.randomUUID().toString(), UUID.randomUUID().toString(), UUID.randomUUID().toString(), SubscriptionEventType.PHASE, Boolean.valueOf(false), Boolean.valueOf(true), UUID.randomUUID().toString(), UUID.randomUUID().toString(), UUID.randomUUID().toString(), auditLogs);
        PhasePriceJson priceOverride = new PhasePriceJson("foo", "bar", null, BigDecimal.TEN, BigDecimal.ONE, null);
        SubscriptionJson entitlementJsonWithEvents = new SubscriptionJson(UUID.randomUUID(), UUID.randomUUID(), UUID.randomUUID(), externalKey, new LocalDate(), UUID.randomUUID().toString(), ProductCategory.BASE, BillingPeriod.MONTHLY, PhaseType.EVERGREEN, UUID.randomUUID().toString(), UUID.randomUUID().toString(), Entitlement.EntitlementState.ACTIVE, Entitlement.EntitlementSourceType.NATIVE, new LocalDate(), new LocalDate(), new LocalDate(), new LocalDate(), null, (List)ImmutableList.of((Object)newEvent), (List)ImmutableList.of((Object)priceOverride), null, auditLogs);
        String asJson = this.mapper.writeValueAsString((Object)entitlementJsonWithEvents);
        SubscriptionJson fromJson = (SubscriptionJson)this.mapper.readValue(asJson, SubscriptionJson.class);
        Assert.assertEquals((Object)fromJson, (Object)entitlementJsonWithEvents);
    }
}

