/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import java.math.BigDecimal;
import java.util.List;
import java.util.UUID;
import org.joda.time.LocalDate;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.jaxrs.JaxrsTestSuiteNoDB;
import org.killbill.billing.jaxrs.JaxrsTestUtils;
import org.killbill.billing.jaxrs.json.AuditLogJson;
import org.killbill.billing.jaxrs.json.CreditJson;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestCreditJson
extends JaxrsTestSuiteNoDB {
    @Test(groups={"fast"})
    public void testJson() throws Exception {
        UUID creditId = UUID.randomUUID();
        BigDecimal creditAmount = BigDecimal.TEN;
        Currency currency = Currency.AED;
        UUID invoiceId = UUID.randomUUID();
        String invoiceNumber = UUID.randomUUID().toString();
        LocalDate effectiveDate = this.clock.getUTCToday();
        UUID accountId = UUID.randomUUID();
        List<AuditLogJson> auditLogs = JaxrsTestUtils.createAuditLogsJson(this.clock.getUTCNow());
        CreditJson creditJson = new CreditJson(creditId, creditAmount, currency, invoiceId, invoiceNumber, effectiveDate, accountId, null, null, auditLogs);
        Assert.assertEquals((Object)creditJson.getCreditId(), (Object)creditId);
        Assert.assertEquals((Object)creditJson.getEffectiveDate(), (Object)effectiveDate);
        Assert.assertEquals((Object)creditJson.getCreditAmount(), (Object)creditAmount);
        Assert.assertEquals((Object)creditJson.getInvoiceId(), (Object)invoiceId);
        Assert.assertEquals((String)creditJson.getInvoiceNumber(), (String)invoiceNumber);
        Assert.assertEquals((Object)creditJson.getAccountId(), (Object)accountId);
        String asJson = this.mapper.writeValueAsString((Object)creditJson);
        CreditJson fromJson = (CreditJson)this.mapper.readValue(asJson, CreditJson.class);
        Assert.assertEquals((Object)fromJson, (Object)creditJson);
    }
}

