/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.jaxrs.JaxrsTestSuiteNoDB;
import org.killbill.billing.jaxrs.json.AccountJson;
import org.killbill.billing.mock.MockAccountBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAccountJson
extends JaxrsTestSuiteNoDB {
    @Test(groups={"fast"})
    public void testJson() throws Exception {
        UUID accountId = UUID.randomUUID();
        String name = UUID.randomUUID().toString();
        Integer length = 12;
        String externalKey = UUID.randomUUID().toString();
        String email = UUID.randomUUID().toString();
        Integer billCycleDayLocal = 6;
        Currency currency = Currency.USD;
        UUID paymentMethodId = UUID.randomUUID();
        DateTime referenceTime = new DateTime();
        String timeZone = UUID.randomUUID().toString();
        String address1 = UUID.randomUUID().toString();
        String address2 = UUID.randomUUID().toString();
        String postalCode = UUID.randomUUID().toString();
        String company = UUID.randomUUID().toString();
        String city = UUID.randomUUID().toString();
        String state = UUID.randomUUID().toString();
        String country = UUID.randomUUID().toString();
        String locale = UUID.randomUUID().toString();
        String phone = UUID.randomUUID().toString();
        String notes = UUID.randomUUID().toString();
        Boolean isMigrated = true;
        Boolean isNotifiedForInvoice = false;
        UUID parentAccountId = UUID.randomUUID();
        AccountJson accountJson = new AccountJson(accountId, name, length, externalKey, email, billCycleDayLocal, currency, parentAccountId, Boolean.valueOf(true), paymentMethodId, referenceTime, timeZone, address1, address2, postalCode, company, city, state, country, locale, phone, notes, isMigrated, null, null, null);
        Assert.assertEquals((Object)accountJson.getAccountId(), (Object)accountId);
        Assert.assertEquals((String)accountJson.getName(), (String)name);
        Assert.assertEquals((Object)accountJson.getFirstNameLength(), (Object)length);
        Assert.assertEquals((String)accountJson.getExternalKey(), (String)externalKey);
        Assert.assertEquals((String)accountJson.getEmail(), (String)email);
        Assert.assertEquals((Object)accountJson.getBillCycleDayLocal(), (Object)billCycleDayLocal);
        Assert.assertEquals((Object)accountJson.getCurrency(), (Object)currency);
        Assert.assertEquals((Object)accountJson.getPaymentMethodId(), (Object)paymentMethodId);
        Assert.assertEquals((String)accountJson.getTimeZone(), (String)timeZone);
        Assert.assertEquals((String)accountJson.getAddress1(), (String)address1);
        Assert.assertEquals((String)accountJson.getAddress2(), (String)address2);
        Assert.assertEquals((String)accountJson.getPostalCode(), (String)postalCode);
        Assert.assertEquals((String)accountJson.getCompany(), (String)company);
        Assert.assertEquals((String)accountJson.getCity(), (String)city);
        Assert.assertEquals((String)accountJson.getState(), (String)state);
        Assert.assertEquals((String)accountJson.getCountry(), (String)country);
        Assert.assertEquals((String)accountJson.getLocale(), (String)locale);
        Assert.assertEquals((String)accountJson.getPhone(), (String)phone);
        Assert.assertEquals((String)accountJson.getNotes(), (String)notes);
        Assert.assertEquals((Object)accountJson.isMigrated(), (Object)isMigrated);
        Assert.assertEquals((Object)accountJson.getParentAccountId(), (Object)parentAccountId);
        Assert.assertEquals((Object)accountJson.isPaymentDelegatedToParent(), (Object)Boolean.TRUE);
        String asJson = this.mapper.writeValueAsString((Object)accountJson);
        AccountJson fromJson = (AccountJson)this.mapper.readValue(asJson, AccountJson.class);
        Assert.assertEquals((Object)fromJson, (Object)accountJson);
    }

    @Test(groups={"fast"})
    public void testFromAccount() throws Exception {
        MockAccountBuilder accountBuilder = new MockAccountBuilder();
        accountBuilder.address1(UUID.randomUUID().toString());
        accountBuilder.address2(UUID.randomUUID().toString());
        int bcd = 4;
        accountBuilder.billingCycleDayLocal(4);
        accountBuilder.city(UUID.randomUUID().toString());
        accountBuilder.companyName(UUID.randomUUID().toString());
        accountBuilder.country(UUID.randomUUID().toString());
        accountBuilder.currency(Currency.GBP);
        accountBuilder.email(UUID.randomUUID().toString());
        accountBuilder.externalKey(UUID.randomUUID().toString());
        accountBuilder.firstNameLength(12);
        accountBuilder.locale(UUID.randomUUID().toString());
        accountBuilder.migrated(true);
        accountBuilder.name(UUID.randomUUID().toString());
        accountBuilder.paymentMethodId(UUID.randomUUID());
        accountBuilder.phone(UUID.randomUUID().toString());
        accountBuilder.postalCode(UUID.randomUUID().toString());
        accountBuilder.stateOrProvince(UUID.randomUUID().toString());
        accountBuilder.timeZone(DateTimeZone.UTC);
        accountBuilder.parentAccountId(UUID.randomUUID());
        Account account = accountBuilder.build();
        AccountJson accountJson = new AccountJson(account, null, null, null);
        Assert.assertEquals((String)accountJson.getAddress1(), (String)account.getAddress1());
        Assert.assertEquals((String)accountJson.getAddress2(), (String)account.getAddress2());
        Assert.assertEquals((Object)accountJson.getBillCycleDayLocal(), (Object)4);
        Assert.assertEquals((String)accountJson.getCountry(), (String)account.getCountry());
        Assert.assertEquals((String)accountJson.getLocale(), (String)account.getLocale());
        Assert.assertEquals((String)accountJson.getCompany(), (String)account.getCompanyName());
        Assert.assertEquals((String)accountJson.getCity(), (String)account.getCity());
        Assert.assertEquals((Object)accountJson.getCurrency(), (Object)account.getCurrency());
        Assert.assertEquals((String)accountJson.getEmail(), (String)account.getEmail());
        Assert.assertEquals((String)accountJson.getExternalKey(), (String)account.getExternalKey());
        Assert.assertEquals((String)accountJson.getName(), (String)account.getName());
        Assert.assertEquals((Object)accountJson.getPaymentMethodId(), (Object)account.getPaymentMethodId());
        Assert.assertEquals((String)accountJson.getPhone(), (String)account.getPhone());
        Assert.assertEquals((Object)accountJson.isMigrated(), (Object)account.isMigrated());
        Assert.assertEquals((String)accountJson.getState(), (String)account.getStateOrProvince());
        Assert.assertEquals((String)accountJson.getTimeZone(), (String)account.getTimeZone().toString());
        Assert.assertEquals((Object)accountJson.getParentAccountId(), (Object)account.getParentAccountId());
    }
}

