/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import java.util.UUID;
import org.killbill.billing.account.api.AccountEmail;
import org.killbill.billing.jaxrs.JaxrsTestSuiteNoDB;
import org.killbill.billing.jaxrs.json.AccountEmailJson;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAccountEmailJson
extends JaxrsTestSuiteNoDB {
    @Test(groups={"fast"})
    public void testJson() throws Exception {
        UUID accountId = UUID.randomUUID();
        String email = UUID.randomUUID().toString();
        AccountEmailJson accountEmailJson = new AccountEmailJson(accountId, email);
        Assert.assertEquals((Object)accountEmailJson.getAccountId(), (Object)accountId);
        Assert.assertEquals((String)accountEmailJson.getEmail(), (String)email);
        String asJson = this.mapper.writeValueAsString((Object)accountEmailJson);
        Assert.assertEquals((String)asJson, (String)("{\"accountId\":\"" + accountId + "\",\"email\":\"" + email + "\",\"auditLogs\":[]}"));
        AccountEmailJson fromJson = (AccountEmailJson)this.mapper.readValue(asJson, AccountEmailJson.class);
        Assert.assertEquals((Object)fromJson, (Object)accountEmailJson);
    }

    @Test(groups={"fast"})
    public void testToAccountEmail() throws Exception {
        UUID accountId = UUID.randomUUID();
        String email = UUID.randomUUID().toString();
        AccountEmailJson accountEmailJson = new AccountEmailJson(accountId, email);
        Assert.assertEquals((Object)accountEmailJson.getAccountId(), (Object)accountId);
        Assert.assertEquals((String)accountEmailJson.getEmail(), (String)email);
        AccountEmail accountEmail = accountEmailJson.toAccountEmail(UUID.randomUUID());
        Assert.assertEquals((Object)accountEmail.getAccountId(), (Object)accountId);
        Assert.assertEquals((String)accountEmail.getEmail(), (String)email);
    }
}

