/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.joda.time.LocalDate;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.invoice.api.Invoice;
import org.killbill.billing.invoice.api.InvoiceStatus;
import org.killbill.billing.jaxrs.JaxrsTestSuiteNoDB;
import org.killbill.billing.jaxrs.JaxrsTestUtils;
import org.killbill.billing.jaxrs.json.AuditLogJson;
import org.killbill.billing.jaxrs.json.CreditJson;
import org.killbill.billing.jaxrs.json.InvoiceJson;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestInvoiceJsonWithBundleKeys
extends JaxrsTestSuiteNoDB {
    @Test(groups={"fast"})
    public void testJson() throws Exception {
        BigDecimal amount = BigDecimal.TEN;
        BigDecimal creditAdj = BigDecimal.ONE;
        BigDecimal refundAdj = BigDecimal.ONE;
        UUID invoiceId = UUID.randomUUID();
        LocalDate invoiceDate = this.clock.getUTCToday();
        LocalDate targetDate = this.clock.getUTCToday();
        String invoiceNumber = UUID.randomUUID().toString();
        BigDecimal balance = BigDecimal.ZERO;
        UUID accountId = UUID.randomUUID();
        String bundleKeys = UUID.randomUUID().toString();
        CreditJson creditJson = this.createCreditJson();
        ImmutableList credits = ImmutableList.of((Object)creditJson);
        List<AuditLogJson> auditLogs = JaxrsTestUtils.createAuditLogsJson(this.clock.getUTCNow());
        InvoiceJson invoiceJsonSimple = new InvoiceJson(amount, Currency.USD.toString(), InvoiceStatus.COMMITTED.toString(), creditAdj, refundAdj, invoiceId, invoiceDate, targetDate, invoiceNumber, balance, accountId, bundleKeys, (List)credits, null, Boolean.valueOf(false), null, null, auditLogs);
        Assert.assertEquals((Object)invoiceJsonSimple.getAmount(), (Object)amount);
        Assert.assertEquals((Object)invoiceJsonSimple.getCreditAdj(), (Object)creditAdj);
        Assert.assertEquals((Object)invoiceJsonSimple.getRefundAdj(), (Object)refundAdj);
        Assert.assertEquals((Object)invoiceJsonSimple.getInvoiceId(), (Object)invoiceId);
        Assert.assertEquals((Object)invoiceJsonSimple.getInvoiceDate(), (Object)invoiceDate);
        Assert.assertEquals((Object)invoiceJsonSimple.getTargetDate(), (Object)targetDate);
        Assert.assertEquals((String)invoiceJsonSimple.getInvoiceNumber(), (String)invoiceNumber);
        Assert.assertEquals((Object)invoiceJsonSimple.getBalance(), (Object)balance);
        Assert.assertEquals((Object)invoiceJsonSimple.getAccountId(), (Object)accountId);
        Assert.assertEquals((String)invoiceJsonSimple.getBundleKeys(), (String)bundleKeys);
        Assert.assertEquals((Collection)invoiceJsonSimple.getCredits(), (Collection)credits);
        Assert.assertEquals((Collection)invoiceJsonSimple.getAuditLogs(), auditLogs);
        Assert.assertEquals((String)invoiceJsonSimple.getStatus(), (String)InvoiceStatus.COMMITTED.toString());
        Assert.assertFalse((boolean)invoiceJsonSimple.getIsParentInvoice());
        String asJson = this.mapper.writeValueAsString((Object)invoiceJsonSimple);
        InvoiceJson fromJson = (InvoiceJson)this.mapper.readValue(asJson, InvoiceJson.class);
        Assert.assertEquals((Object)fromJson, (Object)invoiceJsonSimple);
    }

    @Test(groups={"fast"})
    public void testFromInvoice() throws Exception {
        Invoice invoice = (Invoice)Mockito.mock(Invoice.class);
        Mockito.when((Object)invoice.getChargedAmount()).thenReturn((Object)BigDecimal.TEN);
        Mockito.when((Object)invoice.getCreditedAmount()).thenReturn((Object)BigDecimal.ONE);
        Mockito.when((Object)invoice.getRefundedAmount()).thenReturn((Object)BigDecimal.ONE);
        Mockito.when((Object)invoice.getId()).thenReturn((Object)UUID.randomUUID());
        LocalDate utcToday = this.clock.getUTCToday();
        Mockito.when((Object)invoice.getInvoiceDate()).thenReturn((Object)utcToday);
        Mockito.when((Object)invoice.getTargetDate()).thenReturn((Object)utcToday);
        Mockito.when((Object)invoice.getInvoiceNumber()).thenReturn((Object)Integer.MAX_VALUE);
        Mockito.when((Object)invoice.getBalance()).thenReturn((Object)BigDecimal.ZERO);
        Mockito.when((Object)invoice.getAccountId()).thenReturn((Object)UUID.randomUUID());
        Mockito.when((Object)invoice.getCurrency()).thenReturn((Object)Currency.MXN);
        Mockito.when((Object)invoice.getStatus()).thenReturn((Object)InvoiceStatus.COMMITTED);
        String bundleKeys = UUID.randomUUID().toString();
        ImmutableList credits = ImmutableList.of((Object)this.createCreditJson());
        InvoiceJson invoiceJson = new InvoiceJson(invoice, bundleKeys, (List)credits, null);
        Assert.assertEquals((Object)invoiceJson.getAmount(), (Object)invoice.getChargedAmount());
        Assert.assertEquals((Object)invoiceJson.getCreditAdj(), (Object)invoice.getCreditedAmount());
        Assert.assertEquals((Object)invoiceJson.getRefundAdj(), (Object)invoice.getRefundedAmount());
        Assert.assertEquals((Object)invoiceJson.getInvoiceId(), (Object)invoice.getId());
        Assert.assertEquals((Object)invoiceJson.getInvoiceDate(), (Object)invoice.getInvoiceDate());
        Assert.assertEquals((Object)invoiceJson.getTargetDate(), (Object)invoice.getTargetDate());
        Assert.assertEquals((String)invoiceJson.getInvoiceNumber(), (String)String.valueOf(invoice.getInvoiceNumber()));
        Assert.assertEquals((Object)invoiceJson.getBalance(), (Object)invoice.getBalance());
        Assert.assertEquals((Object)invoiceJson.getAccountId(), (Object)invoice.getAccountId());
        Assert.assertEquals((String)invoiceJson.getBundleKeys(), (String)bundleKeys);
        Assert.assertEquals((Collection)invoiceJson.getCredits(), (Collection)credits);
        Assert.assertNull((Object)invoiceJson.getAuditLogs());
        Assert.assertEquals((String)invoiceJson.getStatus(), (String)InvoiceStatus.COMMITTED.toString());
    }

    private CreditJson createCreditJson() {
        BigDecimal creditAmount = BigDecimal.TEN;
        Currency currency = Currency.USD;
        UUID invoiceId = UUID.randomUUID();
        String invoiceNumber = UUID.randomUUID().toString();
        LocalDate effectiveDate = this.clock.getUTCToday();
        UUID accountId = UUID.randomUUID();
        return new CreditJson(creditAmount, currency.name(), invoiceId, invoiceNumber, effectiveDate, accountId, null, null, null);
    }
}

