/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.joda.time.LocalDate;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.invoice.api.InvoiceItem;
import org.killbill.billing.invoice.api.InvoiceItemType;
import org.killbill.billing.jaxrs.JaxrsTestSuiteNoDB;
import org.killbill.billing.jaxrs.JaxrsTestUtils;
import org.killbill.billing.jaxrs.json.AuditLogJson;
import org.killbill.billing.jaxrs.json.InvoiceItemJson;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestInvoiceItemJsonSimple
extends JaxrsTestSuiteNoDB {
    @Test(groups={"fast"})
    public void testJson() throws Exception {
        UUID invoiceItemId = UUID.randomUUID();
        UUID invoiceId = UUID.randomUUID();
        UUID linkedInvoiceItemId = UUID.randomUUID();
        UUID accountId = UUID.randomUUID();
        UUID childAccountId = UUID.randomUUID();
        UUID bundleId = UUID.randomUUID();
        UUID subscriptionId = UUID.randomUUID();
        String productName = UUID.randomUUID().toString();
        String planName = UUID.randomUUID().toString();
        String phaseName = UUID.randomUUID().toString();
        String usageName = UUID.randomUUID().toString();
        String type = "FIXED";
        String description = UUID.randomUUID().toString();
        LocalDate startDate = this.clock.getUTCToday();
        LocalDate endDate = this.clock.getUTCToday();
        BigDecimal amount = BigDecimal.TEN;
        Currency currency = Currency.MXN;
        List<AuditLogJson> auditLogs = JaxrsTestUtils.createAuditLogsJson(this.clock.getUTCNow());
        InvoiceItemJson invoiceItemJson = new InvoiceItemJson(invoiceItemId, invoiceId, linkedInvoiceItemId, accountId, childAccountId, bundleId, subscriptionId, productName, planName, phaseName, usageName, null, null, null, null, "FIXED", description, startDate, endDate, amount, null, currency.name(), null, null, null, auditLogs);
        Assert.assertEquals((Object)invoiceItemJson.getInvoiceItemId(), (Object)invoiceItemId);
        Assert.assertEquals((Object)invoiceItemJson.getInvoiceId(), (Object)invoiceId);
        Assert.assertEquals((Object)invoiceItemJson.getLinkedInvoiceItemId(), (Object)linkedInvoiceItemId);
        Assert.assertEquals((Object)invoiceItemJson.getAccountId(), (Object)accountId);
        Assert.assertEquals((Object)invoiceItemJson.getChildAccountId(), (Object)childAccountId);
        Assert.assertEquals((Object)invoiceItemJson.getBundleId(), (Object)bundleId);
        Assert.assertEquals((Object)invoiceItemJson.getSubscriptionId(), (Object)subscriptionId);
        Assert.assertEquals((String)invoiceItemJson.getProductName(), (String)productName);
        Assert.assertEquals((String)invoiceItemJson.getPlanName(), (String)planName);
        Assert.assertEquals((String)invoiceItemJson.getPhaseName(), (String)phaseName);
        Assert.assertEquals((String)invoiceItemJson.getUsageName(), (String)usageName);
        Assert.assertEquals((String)invoiceItemJson.getItemType(), (String)"FIXED");
        Assert.assertEquals((String)invoiceItemJson.getDescription(), (String)description);
        Assert.assertEquals((Object)invoiceItemJson.getStartDate(), (Object)startDate);
        Assert.assertEquals((Object)invoiceItemJson.getEndDate(), (Object)endDate);
        Assert.assertEquals((Object)invoiceItemJson.getAmount(), (Object)amount);
        Assert.assertEquals((String)invoiceItemJson.getCurrency(), (String)currency.name());
        Assert.assertEquals((Collection)invoiceItemJson.getAuditLogs(), auditLogs);
        String asJson = this.mapper.writeValueAsString((Object)invoiceItemJson);
        InvoiceItemJson fromJson = (InvoiceItemJson)this.mapper.readValue(asJson, InvoiceItemJson.class);
        Assert.assertEquals((Object)fromJson, (Object)invoiceItemJson);
    }

    @Test(groups={"fast"})
    public void testFromInvoiceItem() throws Exception {
        InvoiceItem invoiceItem = (InvoiceItem)Mockito.mock(InvoiceItem.class);
        Mockito.when((Object)invoiceItem.getId()).thenReturn((Object)UUID.randomUUID());
        Mockito.when((Object)invoiceItem.getInvoiceId()).thenReturn((Object)UUID.randomUUID());
        Mockito.when((Object)invoiceItem.getLinkedItemId()).thenReturn((Object)UUID.randomUUID());
        Mockito.when((Object)invoiceItem.getAccountId()).thenReturn((Object)UUID.randomUUID());
        Mockito.when((Object)invoiceItem.getBundleId()).thenReturn((Object)UUID.randomUUID());
        Mockito.when((Object)invoiceItem.getSubscriptionId()).thenReturn((Object)UUID.randomUUID());
        Mockito.when((Object)invoiceItem.getPlanName()).thenReturn((Object)UUID.randomUUID().toString());
        Mockito.when((Object)invoiceItem.getPhaseName()).thenReturn((Object)UUID.randomUUID().toString());
        Mockito.when((Object)invoiceItem.getUsageName()).thenReturn((Object)UUID.randomUUID().toString());
        Mockito.when((Object)invoiceItem.getDescription()).thenReturn((Object)UUID.randomUUID().toString());
        LocalDate utcToday = this.clock.getUTCToday();
        Mockito.when((Object)invoiceItem.getStartDate()).thenReturn((Object)utcToday);
        Mockito.when((Object)invoiceItem.getEndDate()).thenReturn((Object)utcToday);
        Mockito.when((Object)invoiceItem.getAmount()).thenReturn((Object)BigDecimal.TEN);
        Mockito.when((Object)invoiceItem.getCurrency()).thenReturn((Object)Currency.EUR);
        Mockito.when((Object)invoiceItem.getInvoiceItemType()).thenReturn((Object)InvoiceItemType.FIXED);
        InvoiceItemJson invoiceItemJson = new InvoiceItemJson(invoiceItem);
        Assert.assertEquals((Object)invoiceItemJson.getInvoiceItemId(), (Object)invoiceItem.getId());
        Assert.assertEquals((Object)invoiceItemJson.getInvoiceId(), (Object)invoiceItem.getInvoiceId());
        Assert.assertEquals((Object)invoiceItemJson.getLinkedInvoiceItemId(), (Object)invoiceItem.getLinkedItemId());
        Assert.assertEquals((Object)invoiceItemJson.getAccountId(), (Object)invoiceItem.getAccountId());
        Assert.assertEquals((Object)invoiceItemJson.getBundleId(), (Object)invoiceItem.getBundleId());
        Assert.assertEquals((Object)invoiceItemJson.getSubscriptionId(), (Object)invoiceItem.getSubscriptionId());
        Assert.assertEquals((String)invoiceItemJson.getPlanName(), (String)invoiceItem.getPlanName());
        Assert.assertEquals((String)invoiceItemJson.getPhaseName(), (String)invoiceItem.getPhaseName());
        Assert.assertEquals((String)invoiceItemJson.getUsageName(), (String)invoiceItem.getUsageName());
        Assert.assertEquals((String)invoiceItemJson.getDescription(), (String)invoiceItem.getDescription());
        Assert.assertEquals((Object)invoiceItemJson.getStartDate(), (Object)invoiceItem.getStartDate());
        Assert.assertEquals((Object)invoiceItemJson.getEndDate(), (Object)invoiceItem.getEndDate());
        Assert.assertEquals((Object)invoiceItemJson.getAmount(), (Object)invoiceItem.getAmount());
        Assert.assertEquals((String)invoiceItemJson.getCurrency(), (String)invoiceItem.getCurrency().name());
    }
}

