/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.util.List;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.PhaseType;
import org.killbill.billing.jaxrs.JaxrsTestSuiteNoDB;
import org.killbill.billing.jaxrs.JaxrsTestUtils;
import org.killbill.billing.jaxrs.json.AuditLogJson;
import org.killbill.billing.jaxrs.json.PhasePriceOverrideJson;
import org.killbill.billing.jaxrs.json.SubscriptionJson;
import org.killbill.billing.subscription.api.SubscriptionBaseTransitionType;
import org.killbill.clock.DefaultClock;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestEntitlementJsonWithEvents
extends JaxrsTestSuiteNoDB {
    @Test(groups={"fast"})
    public void testJson() throws Exception {
        String accountId = UUID.randomUUID().toString();
        String bundleId = UUID.randomUUID().toString();
        String subscriptionId = UUID.randomUUID().toString();
        String externalKey = UUID.randomUUID().toString();
        DateTime effectiveDate = DefaultClock.toUTCDateTime((DateTime)new DateTime(DateTimeZone.UTC));
        UUID eventId = UUID.randomUUID();
        List<AuditLogJson> auditLogs = JaxrsTestUtils.createAuditLogsJson(this.clock.getUTCNow());
        SubscriptionJson.EventSubscriptionJson newEvent = new SubscriptionJson.EventSubscriptionJson(eventId.toString(), BillingPeriod.NO_BILLING_PERIOD.toString(), effectiveDate.toLocalDate(), UUID.randomUUID().toString(), UUID.randomUUID().toString(), UUID.randomUUID().toString(), SubscriptionBaseTransitionType.CREATE.toString(), Boolean.valueOf(false), Boolean.valueOf(true), UUID.randomUUID().toString(), UUID.randomUUID().toString(), PhaseType.DISCOUNT.toString(), auditLogs);
        PhasePriceOverrideJson priceOverride = new PhasePriceOverrideJson("foo", "bar", null, BigDecimal.TEN, BigDecimal.ONE);
        SubscriptionJson entitlementJsonWithEvents = new SubscriptionJson(accountId, bundleId, subscriptionId, externalKey, new LocalDate(), UUID.randomUUID().toString(), UUID.randomUUID().toString(), UUID.randomUUID().toString(), UUID.randomUUID().toString(), UUID.randomUUID().toString(), UUID.randomUUID().toString(), UUID.randomUUID().toString(), UUID.randomUUID().toString(), new LocalDate(), new LocalDate(), new LocalDate(), new LocalDate(), null, (List)ImmutableList.of((Object)newEvent), (List)ImmutableList.of((Object)priceOverride), null);
        String asJson = this.mapper.writeValueAsString((Object)entitlementJsonWithEvents);
        SubscriptionJson fromJson = (SubscriptionJson)this.mapper.readValue(asJson, SubscriptionJson.class);
        Assert.assertEquals((Object)fromJson, (Object)entitlementJsonWithEvents);
    }
}

