/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import java.util.UUID;
import org.joda.time.DateTime;
import org.killbill.billing.ObjectType;
import org.killbill.billing.jaxrs.JaxrsTestSuiteNoDB;
import org.killbill.billing.jaxrs.json.AuditLogJson;
import org.killbill.billing.util.audit.AuditLog;
import org.killbill.billing.util.audit.ChangeType;
import org.killbill.billing.util.audit.DefaultAuditLog;
import org.killbill.billing.util.audit.dao.AuditLogModelDao;
import org.killbill.billing.util.dao.EntityAudit;
import org.killbill.billing.util.dao.TableName;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAuditLogJson
extends JaxrsTestSuiteNoDB {
    @Test(groups={"fast"})
    public void testJson() throws Exception {
        String changeType = UUID.randomUUID().toString();
        DateTime changeDate = this.clock.getUTCNow();
        String changedBy = UUID.randomUUID().toString();
        String reasonCode = UUID.randomUUID().toString();
        String comments = UUID.randomUUID().toString();
        String userToken = UUID.randomUUID().toString();
        AuditLogJson auditLogJson = new AuditLogJson(changeType, changeDate, changedBy, reasonCode, comments, userToken);
        Assert.assertEquals((String)auditLogJson.getChangeType(), (String)changeType);
        Assert.assertEquals((Object)auditLogJson.getChangeDate(), (Object)changeDate);
        Assert.assertEquals((String)auditLogJson.getChangedBy(), (String)changedBy);
        Assert.assertEquals((String)auditLogJson.getReasonCode(), (String)reasonCode);
        Assert.assertEquals((String)auditLogJson.getComments(), (String)comments);
        Assert.assertEquals((String)auditLogJson.getUserToken(), (String)userToken);
        String asJson = this.mapper.writeValueAsString((Object)auditLogJson);
        Assert.assertEquals((String)asJson, (String)("{\"changeType\":\"" + auditLogJson.getChangeType() + "\",\"changeDate\":\"" + auditLogJson.getChangeDate().toDateTimeISO().toString() + "\",\"changedBy\":\"" + auditLogJson.getChangedBy() + "\",\"reasonCode\":\"" + auditLogJson.getReasonCode() + "\",\"comments\":\"" + auditLogJson.getComments() + "\",\"userToken\":\"" + auditLogJson.getUserToken() + "\"}"));
        AuditLogJson fromJson = (AuditLogJson)this.mapper.readValue(asJson, AuditLogJson.class);
        Assert.assertEquals((Object)fromJson, (Object)auditLogJson);
    }

    @Test(groups={"fast"})
    public void testConstructor() throws Exception {
        TableName tableName = TableName.ACCOUNT_EMAIL_HISTORY;
        long recordId = Long.MAX_VALUE;
        ChangeType changeType = ChangeType.DELETE;
        EntityAudit entityAudit = new EntityAudit(tableName, Long.valueOf(Long.MAX_VALUE), changeType, null);
        DefaultAuditLog auditLog = new DefaultAuditLog(new AuditLogModelDao(entityAudit, this.callContext), ObjectType.ACCOUNT_EMAIL, UUID.randomUUID());
        AuditLogJson auditLogJson = new AuditLogJson((AuditLog)auditLog);
        Assert.assertEquals((String)auditLogJson.getChangeType(), (String)changeType.toString());
        Assert.assertNotNull((Object)auditLogJson.getChangeDate());
        Assert.assertEquals((String)auditLogJson.getChangedBy(), (String)this.callContext.getUserName());
        Assert.assertEquals((String)auditLogJson.getReasonCode(), (String)this.callContext.getReasonCode());
        Assert.assertEquals((String)auditLogJson.getComments(), (String)this.callContext.getComments());
        Assert.assertEquals((String)auditLogJson.getUserToken(), (String)this.callContext.getUserToken().toString());
    }
}

