/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import java.util.Collection;
import java.util.UUID;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.InternationalPrice;
import org.killbill.billing.catalog.api.Listing;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.catalog.api.PriceList;
import org.killbill.billing.catalog.api.Product;
import org.killbill.billing.catalog.api.Recurring;
import org.killbill.billing.jaxrs.JaxrsTestSuiteNoDB;
import org.killbill.billing.jaxrs.json.PlanDetailJson;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPlanDetailJson
extends JaxrsTestSuiteNoDB {
    @Test(groups={"fast"})
    public void testJson() throws Exception {
        String productName = UUID.randomUUID().toString();
        String planName = UUID.randomUUID().toString();
        BillingPeriod billingPeriod = BillingPeriod.ANNUAL;
        String priceListName = UUID.randomUUID().toString();
        PlanDetailJson planDetailJason = new PlanDetailJson(productName, planName, billingPeriod, priceListName, null);
        Assert.assertEquals((String)planDetailJason.getProduct(), (String)productName);
        Assert.assertEquals((String)planDetailJason.getPlan(), (String)planName);
        Assert.assertEquals((Object)planDetailJason.getFinalPhaseBillingPeriod(), (Object)billingPeriod);
        Assert.assertEquals((String)planDetailJason.getPriceList(), (String)priceListName);
        Assert.assertEquals((Collection)planDetailJason.getFinalPhaseRecurringPrice(), null);
        String asJson = this.mapper.writeValueAsString((Object)planDetailJason);
        Assert.assertEquals((String)asJson, (String)("{\"product\":\"" + planDetailJason.getProduct() + "\"," + "\"plan\":\"" + planDetailJason.getPlan() + "\"," + "\"priceList\":\"" + planDetailJason.getPriceList() + "\"," + "\"finalPhaseBillingPeriod\":\"" + planDetailJason.getFinalPhaseBillingPeriod().toString() + "\"," + "\"finalPhaseRecurringPrice\":null}"));
        PlanDetailJson fromJson = (PlanDetailJson)this.mapper.readValue(asJson, PlanDetailJson.class);
        Assert.assertEquals((Object)fromJson, (Object)planDetailJason);
    }

    @Test(groups={"fast"})
    public void testFromListing() throws Exception {
        Product product = (Product)Mockito.mock(Product.class);
        Mockito.when((Object)product.getName()).thenReturn((Object)UUID.randomUUID().toString());
        InternationalPrice price = (InternationalPrice)Mockito.mock(InternationalPrice.class);
        PlanPhase planPhase = (PlanPhase)Mockito.mock(PlanPhase.class);
        Recurring recurring = (Recurring)Mockito.mock(Recurring.class);
        Mockito.when((Object)recurring.getRecurringPrice()).thenReturn((Object)price);
        Mockito.when((Object)planPhase.getRecurring()).thenReturn((Object)recurring);
        Plan plan = (Plan)Mockito.mock(Plan.class);
        Mockito.when((Object)plan.getProduct()).thenReturn((Object)product);
        Mockito.when((Object)plan.getName()).thenReturn((Object)UUID.randomUUID().toString());
        Mockito.when((Object)plan.getRecurringBillingPeriod()).thenReturn((Object)BillingPeriod.QUARTERLY);
        Mockito.when((Object)plan.getFinalPhase()).thenReturn((Object)planPhase);
        PriceList priceList = (PriceList)Mockito.mock(PriceList.class);
        Mockito.when((Object)priceList.getName()).thenReturn((Object)UUID.randomUUID().toString());
        Listing listing = (Listing)Mockito.mock(Listing.class);
        Mockito.when((Object)listing.getPlan()).thenReturn((Object)plan);
        Mockito.when((Object)listing.getPriceList()).thenReturn((Object)priceList);
        PlanDetailJson planDetailJson = new PlanDetailJson(listing);
        Assert.assertEquals((String)planDetailJson.getProduct(), (String)plan.getProduct().getName());
        Assert.assertEquals((String)planDetailJson.getPlan(), (String)plan.getName());
        Assert.assertEquals((Object)planDetailJson.getFinalPhaseBillingPeriod(), (Object)plan.getRecurringBillingPeriod());
        Assert.assertEquals((String)planDetailJson.getPriceList(), (String)priceList.getName());
        Assert.assertEquals((int)planDetailJson.getFinalPhaseRecurringPrice().size(), (int)0);
    }
}

