/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.UUID;
import org.killbill.billing.jaxrs.JaxrsTestSuiteNoDB;
import org.killbill.billing.jaxrs.json.BillingExceptionJson;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestBillingExceptionJson
extends JaxrsTestSuiteNoDB {
    @Test(groups={"fast"})
    public void testJson() throws Exception {
        String className = UUID.randomUUID().toString();
        int code = Integer.MIN_VALUE;
        String message = UUID.randomUUID().toString();
        String causeClassName = UUID.randomUUID().toString();
        String causeMessage = UUID.randomUUID().toString();
        BillingExceptionJson exceptionJson = new BillingExceptionJson(className, Integer.valueOf(Integer.MIN_VALUE), message, causeClassName, causeMessage, (List)ImmutableList.of());
        Assert.assertEquals((String)exceptionJson.getClassName(), (String)className);
        Assert.assertEquals((Object)exceptionJson.getCode(), (Object)Integer.MIN_VALUE);
        Assert.assertEquals((String)exceptionJson.getMessage(), (String)message);
        Assert.assertEquals((String)exceptionJson.getCauseClassName(), (String)causeClassName);
        Assert.assertEquals((String)exceptionJson.getCauseMessage(), (String)causeMessage);
        Assert.assertEquals((int)exceptionJson.getStackTrace().size(), (int)0);
        String asJson = this.mapper.writeValueAsString((Object)exceptionJson);
        BillingExceptionJson fromJson = (BillingExceptionJson)this.mapper.readValue(asJson, BillingExceptionJson.class);
        Assert.assertEquals((Object)fromJson, (Object)exceptionJson);
    }

    @Test(groups={"fast"})
    public void testFromException() throws Exception {
        String nil = null;
        try {
            nil.toString();
            Assert.fail();
        }
        catch (NullPointerException e) {
            BillingExceptionJson exceptionJson = new BillingExceptionJson((Exception)e, true);
            Assert.assertEquals((String)exceptionJson.getClassName(), (String)e.getClass().getName());
            Assert.assertNull((Object)exceptionJson.getCode());
            Assert.assertNull((Object)exceptionJson.getMessage());
            Assert.assertNull((Object)exceptionJson.getCauseClassName());
            Assert.assertNull((Object)exceptionJson.getCauseMessage());
            Assert.assertFalse((boolean)exceptionJson.getStackTrace().isEmpty());
            Assert.assertEquals((String)((BillingExceptionJson.StackTraceElementJson)exceptionJson.getStackTrace().get(0)).getClassName(), (String)TestBillingExceptionJson.class.getName());
            Assert.assertEquals((String)((BillingExceptionJson.StackTraceElementJson)exceptionJson.getStackTrace().get(0)).getMethodName(), (String)"testFromException");
            Assert.assertFalse((boolean)((BillingExceptionJson.StackTraceElementJson)exceptionJson.getStackTrace().get(0)).getNativeMethod());
            BillingExceptionJson exceptionJsonNoStackTrace = new BillingExceptionJson((Exception)e, false);
            Assert.assertEquals((String)exceptionJsonNoStackTrace.getClassName(), (String)e.getClass().getName());
            Assert.assertNull((Object)exceptionJsonNoStackTrace.getCode());
            Assert.assertNull((Object)exceptionJsonNoStackTrace.getMessage());
            Assert.assertNull((Object)exceptionJsonNoStackTrace.getCauseClassName());
            Assert.assertNull((Object)exceptionJsonNoStackTrace.getCauseMessage());
            Assert.assertTrue((boolean)exceptionJsonNoStackTrace.getStackTrace().isEmpty());
        }
    }
}

