/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.util;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import javax.servlet.ServletRequest;
import org.killbill.billing.tenant.api.Tenant;
import org.killbill.billing.util.UUIDs;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.CallContextFactory;
import org.killbill.billing.util.callcontext.CallOrigin;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.callcontext.UserType;

public class Context {
    private final CallOrigin origin = CallOrigin.EXTERNAL;
    private final UserType userType = UserType.CUSTOMER;
    final CallContextFactory contextFactory;

    @Inject
    public Context(CallContextFactory factory) {
        this.contextFactory = factory;
    }

    public CallContext createContext(String createdBy, String reason, String comment, ServletRequest request) throws IllegalArgumentException {
        try {
            Preconditions.checkNotNull((Object)createdBy, (Object)String.format("Header %s needs to be set", "X-Killbill-CreatedBy"));
            Tenant tenant = this.getTenantFromRequest(request);
            return this.contextFactory.createCallContext(tenant == null ? null : tenant.getId(), createdBy, this.origin, this.userType, reason, comment, UUIDs.randomUUID());
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public TenantContext createContext(ServletRequest request) {
        Tenant tenant = this.getTenantFromRequest(request);
        if (tenant == null) {
            return this.contextFactory.createTenantContext(null);
        }
        return this.contextFactory.createTenantContext(tenant.getId());
    }

    private Tenant getTenantFromRequest(ServletRequest request) {
        Object tenantObject = request.getAttribute("killbill_tenant");
        if (tenantObject == null) {
            return null;
        }
        return (Tenant)tenantObject;
    }
}

