/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.inject.Singleton;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.joda.time.LocalDate;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.entitlement.api.Entitlement;
import org.killbill.billing.entitlement.api.EntitlementApi;
import org.killbill.billing.entitlement.api.EntitlementApiException;
import org.killbill.billing.jaxrs.json.RolledUpUsageJson;
import org.killbill.billing.jaxrs.json.SubscriptionUsageRecordJson;
import org.killbill.billing.jaxrs.resources.JaxRsResourceBase;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.payment.api.PaymentApi;
import org.killbill.billing.usage.api.RolledUpUsage;
import org.killbill.billing.usage.api.SubscriptionUsageRecord;
import org.killbill.billing.usage.api.UsageUserApi;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.clock.Clock;
import org.killbill.commons.metrics.TimedResource;

@Singleton
@Path(value="/1.0/kb/usages")
@Api(value="/1.0/kb/usages", description="Operations on usage")
public class UsageResource
extends JaxRsResourceBase {
    private final UsageUserApi usageUserApi;
    private final EntitlementApi entitlementApi;

    @Inject
    public UsageResource(JaxrsUriBuilder uriBuilder, TagUserApi tagUserApi, CustomFieldUserApi customFieldUserApi, AuditUserApi auditUserApi, AccountUserApi accountUserApi, UsageUserApi usageUserApi, PaymentApi paymentApi, EntitlementApi entitlementApi, Clock clock, org.killbill.billing.jaxrs.util.Context context) {
        super(uriBuilder, tagUserApi, customFieldUserApi, auditUserApi, accountUserApi, paymentApi, clock, context);
        this.usageUserApi = usageUserApi;
        this.entitlementApi = entitlementApi;
    }

    @TimedResource
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Record usage for a subscription")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid subscription (e.g. inactive)")})
    public Response recordUsage(SubscriptionUsageRecordJson json, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request, @Context UriInfo uriInfo) throws EntitlementApiException, AccountApiException {
        this.verifyNonNullOrEmpty(json, "SubscriptionUsageRecordJson body should be specified");
        this.verifyNonNullOrEmpty(json.getSubscriptionId(), "SubscriptionUsageRecordJson subscriptionId needs to be set", json.getUnitUsageRecords(), "SubscriptionUsageRecordJson unitUsageRecords needs to be set");
        Preconditions.checkArgument((!json.getUnitUsageRecords().isEmpty() ? 1 : 0) != 0);
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        Entitlement entitlement = this.entitlementApi.getEntitlementForId(UUID.fromString(json.getSubscriptionId()), (TenantContext)callContext);
        if (entitlement.getState() != Entitlement.EntitlementState.ACTIVE) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        SubscriptionUsageRecord record = json.toSubscriptionUsageRecord();
        this.usageUserApi.recordRolledUpUsage(record, callContext);
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @TimedResource
    @GET
    @Path(value="/{subscriptionId:\\w+-\\w+-\\w+-\\w+-\\w+}/{unitType}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve usage for a subscription and unit type", response=RolledUpUsageJson.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Missing start date or end date")})
    public Response getUsage(@PathParam(value="subscriptionId") String subscriptionId, @PathParam(value="unitType") String unitType, @QueryParam(value="startDate") String startDate, @QueryParam(value="endDate") String endDate, @Context HttpServletRequest request) {
        if (startDate == null || endDate == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        LocalDate usageStartDate = this.LOCAL_DATE_FORMATTER.parseLocalDate(startDate);
        LocalDate usageEndDate = this.LOCAL_DATE_FORMATTER.parseLocalDate(endDate);
        RolledUpUsage usage = this.usageUserApi.getUsageForSubscription(UUID.fromString(subscriptionId), unitType, usageStartDate, usageEndDate, tenantContext);
        RolledUpUsageJson result = new RolledUpUsageJson(usage);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
    }

    @TimedResource
    @GET
    @Path(value="/{subscriptionId:\\w+-\\w+-\\w+-\\w+-\\w+}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve usage for a subscription", response=RolledUpUsageJson.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Missing start date or end date")})
    public Response getAllUsage(@PathParam(value="subscriptionId") String subscriptionId, @QueryParam(value="startDate") String startDate, @QueryParam(value="endDate") String endDate, @Context HttpServletRequest request) {
        if (startDate == null || endDate == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        LocalDate usageStartDate = this.LOCAL_DATE_FORMATTER.parseLocalDate(startDate);
        LocalDate usageEndDate = this.LOCAL_DATE_FORMATTER.parseLocalDate(endDate);
        ImmutableList startEndDate = ImmutableList.builder().add((Object)usageStartDate).add((Object)usageEndDate).build();
        List usage = this.usageUserApi.getAllUsageForSubscription(UUID.fromString(subscriptionId), (List)startEndDate, tenantContext);
        RolledUpUsageJson result = new RolledUpUsageJson((RolledUpUsage)usage.get(0));
        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
    }
}

