/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.google.common.collect.ImmutableList;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.UUID;
import javax.inject.Inject;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.jaxrs.json.PaymentTransactionJson;
import org.killbill.billing.jaxrs.resources.JaxRsResourceBase;
import org.killbill.billing.jaxrs.resources.PaymentResource;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.payment.api.Payment;
import org.killbill.billing.payment.api.PaymentApi;
import org.killbill.billing.payment.api.PaymentApiException;
import org.killbill.billing.payment.api.TransactionStatus;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.clock.Clock;
import org.killbill.commons.metrics.TimedResource;

@Path(value="/1.0/kb/paymentTransactions")
@Api(value="paymentTransactions", description="Operations on payment transactions")
public class TransactionResource
extends JaxRsResourceBase {
    @Inject
    public TransactionResource(JaxrsUriBuilder uriBuilder, TagUserApi tagUserApi, CustomFieldUserApi customFieldUserApi, AuditUserApi auditUserApi, AccountUserApi accountUserApi, PaymentApi paymentApi, Clock clock, org.killbill.billing.jaxrs.util.Context context) {
        super(uriBuilder, tagUserApi, customFieldUserApi, auditUserApi, accountUserApi, paymentApi, clock, context);
    }

    @TimedResource
    @POST
    @Path(value="/{transactionId:\\w+-\\w+-\\w+-\\w+-\\w+}/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Mark a pending payment transaction as succeeded or failed")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid paymentId supplied"), @ApiResponse(code=404, message="Account or Payment not found")})
    public Response notifyStateChanged(PaymentTransactionJson json, @PathParam(value="transactionId") String transactionIdStr, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws PaymentApiException, AccountApiException {
        this.verifyNonNullOrEmpty(json, "PaymentTransactionJson body should be specified");
        this.verifyNonNullOrEmpty(json.getPaymentId(), "PaymentTransactionJson paymentId needs to be set", json.getStatus(), "PaymentTransactionJson status needs to be set");
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        UUID paymentId = UUID.fromString(json.getPaymentId());
        Payment payment = this.paymentApi.getPayment(paymentId, false, (Iterable)ImmutableList.of(), (TenantContext)callContext);
        Account account = this.accountUserApi.getAccountById(payment.getAccountId(), (TenantContext)callContext);
        boolean success = TransactionStatus.SUCCESS.name().equals(json.getStatus());
        Payment result = this.paymentApi.notifyPendingTransactionOfStateChanged(account, UUID.fromString(transactionIdStr), success, callContext);
        return this.uriBuilder.buildResponse(uriInfo, PaymentResource.class, "getPayment", result.getId());
    }

    protected ObjectType getObjectType() {
        return ObjectType.TRANSACTION;
    }
}

