/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.jaxrs.json.TenantJson;
import org.killbill.billing.jaxrs.json.TenantKeyJson;
import org.killbill.billing.jaxrs.resources.JaxRsResourceBase;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.payment.api.PaymentApi;
import org.killbill.billing.tenant.api.Tenant;
import org.killbill.billing.tenant.api.TenantApiException;
import org.killbill.billing.tenant.api.TenantData;
import org.killbill.billing.tenant.api.TenantKV;
import org.killbill.billing.tenant.api.TenantUserApi;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.clock.Clock;
import org.killbill.commons.metrics.TimedResource;

@Singleton
@Path(value="/1.0/kb/tenants")
@Api(value="/1.0/kb/tenants", description="Operations on tenants")
public class TenantResource
extends JaxRsResourceBase {
    private final TenantUserApi tenantApi;

    @Inject
    public TenantResource(TenantUserApi tenantApi, JaxrsUriBuilder uriBuilder, TagUserApi tagUserApi, CustomFieldUserApi customFieldUserApi, AuditUserApi auditUserApi, AccountUserApi accountUserApi, PaymentApi paymentApi, Clock clock, org.killbill.billing.jaxrs.util.Context context) {
        super(uriBuilder, tagUserApi, customFieldUserApi, auditUserApi, accountUserApi, paymentApi, clock, context);
        this.tenantApi = tenantApi;
    }

    @TimedResource
    @GET
    @Path(value="/{tenantId:\\w+-\\w+-\\w+-\\w+-\\w+}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve a tenant by id", response=TenantJson.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid tenantId supplied"), @ApiResponse(code=404, message="Tenant not found")})
    public Response getTenant(@PathParam(value="tenantId") String tenantId) throws TenantApiException {
        Tenant tenant = this.tenantApi.getTenantById(UUID.fromString(tenantId));
        return Response.status((Response.Status)Response.Status.OK).entity((Object)new TenantJson(tenant)).build();
    }

    @TimedResource
    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve a tenant by its API key", response=TenantJson.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Tenant not found")})
    public Response getTenantByApiKey(@QueryParam(value="apiKey") String externalKey) throws TenantApiException {
        Tenant tenant = this.tenantApi.getTenantByApiKey(externalKey);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)new TenantJson(tenant)).build();
    }

    @TimedResource
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a tenant")
    @ApiResponses(value={@ApiResponse(code=500, message="Tenant already exists")})
    public Response createTenant(TenantJson json, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request, @Context UriInfo uriInfo) throws TenantApiException {
        this.verifyNonNullOrEmpty(json, "TenantJson body should be specified");
        this.verifyNonNullOrEmpty(json.getApiKey(), "TenantJson apiKey needs to be set", json.getApiSecret(), "TenantJson apiSecret needs to be set");
        TenantData data = json.toTenantData();
        Tenant tenant = this.tenantApi.createTenant(data, this.context.createContext(createdBy, reason, comment, (ServletRequest)request));
        return this.uriBuilder.buildResponse(uriInfo, TenantResource.class, "getTenant", tenant.getId());
    }

    @TimedResource
    @POST
    @Path(value="/registerNotificationCallback")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a push notification")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid tenantId supplied")})
    public Response registerPushNotificationCallback(@QueryParam(value="cb") String notificationCallback, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request, @Context UriInfo uriInfo) throws TenantApiException {
        return this.insertTenantKey(TenantKV.TenantKey.PUSH_NOTIFICATION_CB, null, notificationCallback, uriInfo, "getPushNotificationCallbacks", createdBy, reason, comment, request);
    }

    @TimedResource
    @GET
    @Path(value="/registerNotificationCallback")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve a push notification", response=TenantKeyJson.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid tenantId supplied")})
    public Response getPushNotificationCallbacks(@Context HttpServletRequest request) throws TenantApiException {
        return this.getTenantKey(TenantKV.TenantKey.PUSH_NOTIFICATION_CB, null, request);
    }

    @TimedResource
    @DELETE
    @Path(value="/registerNotificationCallback")
    @ApiOperation(value="Delete a push notification")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid tenantId supplied")})
    public Response deletePushNotificationCallbacks(@HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) throws TenantApiException {
        return this.deleteTenantKey(TenantKV.TenantKey.PUSH_NOTIFICATION_CB, null, createdBy, reason, comment, request);
    }

    @TimedResource
    @POST
    @Path(value="/uploadPluginConfig/{pluginName:.*}")
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Add a per tenant configuration for a plugin")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid tenantId supplied")})
    public Response uploadPluginConfiguration(String pluginConfig, @PathParam(value="pluginName") String pluginName, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request, @Context UriInfo uriInfo) throws TenantApiException {
        return this.insertTenantKey(TenantKV.TenantKey.PLUGIN_CONFIG_, pluginName, pluginConfig, uriInfo, "getPluginConfiguration", createdBy, reason, comment, request);
    }

    @TimedResource
    @GET
    @Path(value="/uploadPluginConfig/{pluginName:.*}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve a per tenant configuration for a plugin", response=TenantKeyJson.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid tenantId supplied")})
    public Response getPluginConfiguration(@PathParam(value="pluginName") String pluginName, @Context HttpServletRequest request) throws TenantApiException {
        return this.getTenantKey(TenantKV.TenantKey.PLUGIN_CONFIG_, pluginName, request);
    }

    @TimedResource
    @DELETE
    @Path(value="/uploadPluginConfig/{pluginName:.*}")
    @ApiOperation(value="Delete a per tenant configuration for a plugin")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid tenantId supplied")})
    public Response deletePluginConfiguration(@PathParam(value="pluginName") String pluginName, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) throws TenantApiException {
        return this.deleteTenantKey(TenantKV.TenantKey.PLUGIN_CONFIG_, pluginName, createdBy, reason, comment, request);
    }

    @TimedResource
    @POST
    @Path(value="/userKeyValue/{keyName:.*}")
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Add a per tenant user key/value")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid tenantId supplied")})
    public Response insertUserKeyValue(@PathParam(value="keyName") String key, String value, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request, @Context UriInfo uriInfo) throws TenantApiException {
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        this.tenantApi.addTenantKeyValue(key, value, callContext);
        return this.uriBuilder.buildResponse(uriInfo, TenantResource.class, "getUserKeyValue", (Object)key);
    }

    @TimedResource
    @GET
    @Path(value="/userKeyValue/{keyName:.*}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve a per tenant user key/value", response=TenantKeyJson.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid tenantId supplied")})
    public Response getUserKeyValue(@PathParam(value="keyName") String key, @Context HttpServletRequest request) throws TenantApiException {
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        List values = this.tenantApi.getTenantValuesForKey(key, tenantContext);
        TenantKeyJson result = new TenantKeyJson(key, values);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
    }

    @TimedResource
    @DELETE
    @Path(value="/userKeyValue/{keyName:.*}")
    @ApiOperation(value="Delete  a per tenant user key/value")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid tenantId supplied")})
    public Response deleteUserKeyValue(@PathParam(value="keyName") String key, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) throws TenantApiException {
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        this.tenantApi.deleteTenantKey(key, callContext);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    private Response insertTenantKey(TenantKV.TenantKey key, @Nullable String keyPostfix, String value, UriInfo uriInfo, String getMethodStr, String createdBy, String reason, String comment, HttpServletRequest request) throws TenantApiException {
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        String tenantKey = keyPostfix != null ? key.toString() + keyPostfix : key.toString();
        this.tenantApi.addTenantKeyValue(tenantKey, value, callContext);
        return this.uriBuilder.buildResponse(uriInfo, TenantResource.class, getMethodStr, (Object)keyPostfix);
    }

    private Response getTenantKey(TenantKV.TenantKey key, @Nullable String keyPostfix, HttpServletRequest request) throws TenantApiException {
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        String tenantKey = keyPostfix != null ? key.toString() + keyPostfix : key.toString();
        List values = this.tenantApi.getTenantValuesForKey(tenantKey, tenantContext);
        TenantKeyJson result = new TenantKeyJson(tenantKey, values);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
    }

    private Response deleteTenantKey(TenantKV.TenantKey key, @Nullable String keyPostfix, String createdBy, String reason, String comment, HttpServletRequest request) throws TenantApiException {
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        String tenantKey = keyPostfix != null ? key.toString() + keyPostfix : key.toString();
        this.tenantApi.deleteTenantKey(tenantKey, callContext);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    protected ObjectType getObjectType() {
        return ObjectType.TENANT;
    }
}

