/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.Set;
import javax.inject.Singleton;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.jaxrs.json.RoleDefinitionJson;
import org.killbill.billing.jaxrs.json.SubjectJson;
import org.killbill.billing.jaxrs.json.UserRolesJson;
import org.killbill.billing.jaxrs.resources.JaxRsResourceBase;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.payment.api.PaymentApi;
import org.killbill.billing.security.SecurityApiException;
import org.killbill.billing.security.api.SecurityApi;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.clock.Clock;
import org.killbill.commons.metrics.TimedResource;

@Singleton
@Path(value="/1.0/kb/security")
@Api(value="/1.0/kb/security", description="Information about RBAC")
public class SecurityResource
extends JaxRsResourceBase {
    private final SecurityApi securityApi;

    @Inject
    public SecurityResource(SecurityApi securityApi, JaxrsUriBuilder uriBuilder, TagUserApi tagUserApi, CustomFieldUserApi customFieldUserApi, AuditUserApi auditUserApi, AccountUserApi accountUserApi, PaymentApi paymentApi, Clock clock, org.killbill.billing.jaxrs.util.Context context) {
        super(uriBuilder, tagUserApi, customFieldUserApi, auditUserApi, accountUserApi, paymentApi, clock, context);
        this.securityApi = securityApi;
    }

    @TimedResource
    @GET
    @Path(value="/permissions")
    @Produces(value={"application/json"})
    @ApiOperation(value="List user permissions", response=String.class, responseContainer="List")
    @ApiResponses(value={})
    public Response getCurrentUserPermissions(@Context HttpServletRequest request) {
        TenantContext nullTenantContext = null;
        Set permissions = this.securityApi.getCurrentUserPermissions(nullTenantContext);
        ImmutableList json = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)permissions, (Function)Functions.toStringFunction()));
        return Response.status((Response.Status)Response.Status.OK).entity((Object)json).build();
    }

    @TimedResource
    @GET
    @Path(value="/subject")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get user information", response=SubjectJson.class)
    @ApiResponses(value={})
    public Response getCurrentUserSubject(@Context HttpServletRequest request) {
        Subject subject = SecurityUtils.getSubject();
        SubjectJson subjectJson = new SubjectJson(subject);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)subjectJson).build();
    }

    @TimedResource
    @POST
    @Path(value="/users")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Add a new user with roles (to make api requests)")
    public Response addUserRoles(UserRolesJson json, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request, @Context UriInfo uriInfo) throws SecurityApiException {
        this.securityApi.addUserRoles(json.getUsername(), json.getPassword(), json.getRoles(), this.context.createContext(createdBy, reason, comment, (ServletRequest)request));
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @TimedResource
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/users/{username:.*}/password")
    @ApiOperation(value="Update a user password")
    public Response updateUserPassword(UserRolesJson json, @PathParam(value="username") String username, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request, @Context UriInfo uriInfo) throws SecurityApiException {
        this.securityApi.updateUserPassword(username, json.getPassword(), this.context.createContext(createdBy, reason, comment, (ServletRequest)request));
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @TimedResource
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/users/{username:.*}/roles")
    @ApiOperation(value="Update roles associated to a user")
    public Response updateUserRoles(UserRolesJson json, @PathParam(value="username") String username, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request, @Context UriInfo uriInfo) throws SecurityApiException {
        this.securityApi.updateUserRoles(username, json.getRoles(), this.context.createContext(createdBy, reason, comment, (ServletRequest)request));
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @TimedResource
    @DELETE
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/users/{username:.*}")
    @ApiOperation(value="Invalidate an existing user")
    public Response invalidateUser(@PathParam(value="username") String username, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request, @Context UriInfo uriInfo) throws SecurityApiException {
        this.securityApi.invalidateUser(username, this.context.createContext(createdBy, reason, comment, (ServletRequest)request));
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @TimedResource
    @POST
    @Path(value="/roles")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Add a new role definition)")
    public Response addRoleDefinition(RoleDefinitionJson json, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request, @Context UriInfo uriInfo) throws SecurityApiException {
        this.securityApi.addRoleDefinition(json.getRole(), json.getPermissions(), this.context.createContext(createdBy, reason, comment, (ServletRequest)request));
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }
}

