/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.jaxrs.json.ComboPaymentTransactionJson;
import org.killbill.billing.jaxrs.json.PaymentJson;
import org.killbill.billing.jaxrs.json.PaymentTransactionJson;
import org.killbill.billing.jaxrs.resources.AuditMode;
import org.killbill.billing.jaxrs.resources.ComboPaymentResource;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.payment.api.Payment;
import org.killbill.billing.payment.api.PaymentApi;
import org.killbill.billing.payment.api.PaymentApiException;
import org.killbill.billing.payment.api.PaymentOptions;
import org.killbill.billing.payment.api.PaymentTransaction;
import org.killbill.billing.payment.api.PluginProperty;
import org.killbill.billing.payment.api.TransactionType;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.audit.AccountAuditLogs;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.entity.Pagination;
import org.killbill.clock.Clock;
import org.killbill.commons.metrics.MetricTag;
import org.killbill.commons.metrics.TimedResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/1.0/kb/payments")
@Api(value="/1.0/kb/payments", description="Operations on payments")
public class PaymentResource
extends ComboPaymentResource {
    @Inject
    public PaymentResource(JaxrsUriBuilder uriBuilder, TagUserApi tagUserApi, CustomFieldUserApi customFieldUserApi, AuditUserApi auditUserApi, AccountUserApi accountUserApi, PaymentApi paymentApi, Clock clock, org.killbill.billing.jaxrs.util.Context context) {
        super(uriBuilder, tagUserApi, customFieldUserApi, auditUserApi, accountUserApi, paymentApi, clock, context);
    }

    @TimedResource(name="getPayment")
    @GET
    @Path(value="/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}/")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve a payment by id", response=PaymentJson.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid paymentId supplied"), @ApiResponse(code=404, message="Payment not found")})
    public Response getPayment(@PathParam(value="paymentId") String paymentIdStr, @QueryParam(value="withPluginInfo") @DefaultValue(value="false") Boolean withPluginInfo, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) throws PaymentApiException {
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        UUID paymentIdId = UUID.fromString(paymentIdStr);
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        Payment payment = this.paymentApi.getPayment(paymentIdId, withPluginInfo.booleanValue(), pluginProperties, tenantContext);
        AccountAuditLogs accountAuditLogs = this.auditUserApi.getAccountAuditLogs(payment.getAccountId(), auditMode.getLevel(), tenantContext);
        PaymentJson result = new PaymentJson(payment, accountAuditLogs);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
    }

    @TimedResource(name="getPayment")
    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve a payment by id", response=PaymentJson.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Payment not found")})
    public Response getPaymentByExternalKey(@QueryParam(value="withPluginInfo") @DefaultValue(value="false") Boolean withPluginInfo, @QueryParam(value="externalKey") String paymentExternalKey, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) throws PaymentApiException {
        this.verifyNonNullOrEmpty(paymentExternalKey, "Payment externalKey needs to be specified");
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        Payment payment = this.paymentApi.getPaymentByExternalKey(paymentExternalKey, withPluginInfo.booleanValue(), pluginProperties, tenantContext);
        AccountAuditLogs accountAuditLogs = this.auditUserApi.getAccountAuditLogs(payment.getAccountId(), auditMode.getLevel(), tenantContext);
        PaymentJson result = new PaymentJson(payment, accountAuditLogs);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
    }

    @TimedResource
    @GET
    @Path(value="/pagination")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get payments", response=PaymentJson.class, responseContainer="List")
    @ApiResponses(value={})
    public Response getPayments(@QueryParam(value="offset") @DefaultValue(value="0") Long offset, @QueryParam(value="limit") @DefaultValue(value="100") Long limit, @QueryParam(value="pluginName") String pluginName, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, final @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @QueryParam(value="withPluginInfo") @DefaultValue(value="false") Boolean withPluginInfo, @Context HttpServletRequest request) throws PaymentApiException {
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        final TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        Pagination payments = Strings.isNullOrEmpty((String)pluginName) ? this.paymentApi.getPayments(offset, limit, withPluginInfo.booleanValue(), pluginProperties, tenantContext) : this.paymentApi.getPayments(offset, limit, pluginName, withPluginInfo.booleanValue(), pluginProperties, tenantContext);
        URI nextPageUri = this.uriBuilder.nextPage(PaymentResource.class, "getPayments", payments.getNextOffset(), limit, (Map<String, String>)ImmutableMap.of((Object)"pluginName", (Object)Strings.nullToEmpty((String)pluginName), (Object)"audit", (Object)auditMode.getLevel().toString()));
        final AtomicReference accountsAuditLogs = new AtomicReference(new HashMap());
        return this.buildStreamingPaginationResponse(payments, new Function<Payment, PaymentJson>(){

            public PaymentJson apply(Payment payment) {
                if (((Map)accountsAuditLogs.get()).get(payment.getAccountId()) == null) {
                    ((Map)accountsAuditLogs.get()).put(payment.getAccountId(), PaymentResource.this.auditUserApi.getAccountAuditLogs(payment.getAccountId(), auditMode.getLevel(), tenantContext));
                }
                AccountAuditLogs accountAuditLogs = (AccountAuditLogs)((Map)accountsAuditLogs.get()).get(payment.getAccountId());
                return new PaymentJson(payment, accountAuditLogs);
            }
        }, nextPageUri);
    }

    @TimedResource
    @GET
    @Path(value="/search/{searchKey:.*}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Search payments", response=PaymentJson.class, responseContainer="List")
    @ApiResponses(value={})
    public Response searchPayments(@PathParam(value="searchKey") String searchKey, @QueryParam(value="offset") @DefaultValue(value="0") Long offset, @QueryParam(value="limit") @DefaultValue(value="100") Long limit, @QueryParam(value="pluginName") String pluginName, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, final @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @QueryParam(value="withPluginInfo") @DefaultValue(value="false") Boolean withPluginInfo, @Context HttpServletRequest request) throws PaymentApiException {
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        final TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        Pagination payments = Strings.isNullOrEmpty((String)pluginName) ? this.paymentApi.searchPayments(searchKey, offset, limit, withPluginInfo.booleanValue(), pluginProperties, tenantContext) : this.paymentApi.searchPayments(searchKey, offset, limit, pluginName, withPluginInfo.booleanValue(), pluginProperties, tenantContext);
        URI nextPageUri = this.uriBuilder.nextPage(PaymentResource.class, "searchPayments", payments.getNextOffset(), limit, (Map<String, String>)ImmutableMap.of((Object)"searchKey", (Object)searchKey, (Object)"pluginName", (Object)Strings.nullToEmpty((String)pluginName), (Object)"audit", (Object)auditMode.getLevel().toString()));
        final AtomicReference accountsAuditLogs = new AtomicReference(new HashMap());
        return this.buildStreamingPaginationResponse(payments, new Function<Payment, PaymentJson>(){

            public PaymentJson apply(Payment payment) {
                if (((Map)accountsAuditLogs.get()).get(payment.getAccountId()) == null) {
                    ((Map)accountsAuditLogs.get()).put(payment.getAccountId(), PaymentResource.this.auditUserApi.getAccountAuditLogs(payment.getAccountId(), auditMode.getLevel(), tenantContext));
                }
                AccountAuditLogs accountAuditLogs = (AccountAuditLogs)((Map)accountsAuditLogs.get()).get(payment.getAccountId());
                return new PaymentJson(payment, accountAuditLogs);
            }
        }, nextPageUri);
    }

    @TimedResource(name="completeTransaction")
    @PUT
    @Path(value="/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Complete an existing transaction")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid paymentId supplied"), @ApiResponse(code=404, message="Account or payment not found")})
    public Response completeTransaction(@MetricTag(tag="type", property="transactionType") PaymentTransactionJson json, @PathParam(value="paymentId") String paymentIdStr, @QueryParam(value="controlPluginName") List<String> paymentControlPluginNames, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws PaymentApiException, AccountApiException {
        return this.completeTransactionInternal(json, paymentIdStr, paymentControlPluginNames, pluginPropertiesString, createdBy, reason, comment, uriInfo, request);
    }

    @TimedResource(name="completeTransaction")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Complete an existing transaction")
    @ApiResponses(value={@ApiResponse(code=404, message="Account or payment not found")})
    public Response completeTransactionByExternalKey(@MetricTag(tag="type", property="transactionType") PaymentTransactionJson json, @QueryParam(value="controlPluginName") List<String> paymentControlPluginNames, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws PaymentApiException, AccountApiException {
        return this.completeTransactionInternal(json, null, paymentControlPluginNames, pluginPropertiesString, createdBy, reason, comment, uriInfo, request);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Response completeTransactionInternal(final PaymentTransactionJson json, @Nullable String paymentIdStr, List<String> paymentControlPluginNames, Iterable<String> pluginPropertiesString, String createdBy, String reason, String comment, UriInfo uriInfo, HttpServletRequest request) throws PaymentApiException, AccountApiException {
        String transactionExternalKey;
        TransactionType transactionType;
        Collection paymentTransactionCandidates;
        Currency currency;
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        Payment initialPayment = this.getPaymentByIdOrKey(paymentIdStr, json == null ? null : json.getPaymentExternalKey(), pluginProperties, (TenantContext)callContext);
        Account account = this.accountUserApi.getAccountById(initialPayment.getAccountId(), (TenantContext)callContext);
        BigDecimal amount = json == null ? null : json.getAmount();
        Currency currency2 = currency = json == null || json.getCurrency() == null ? null : Currency.valueOf((String)json.getCurrency());
        if (json != null && json.getTransactionId() != null) {
            paymentTransactionCandidates = Collections2.filter((Collection)initialPayment.getTransactions(), (Predicate)new Predicate<PaymentTransaction>(){

                public boolean apply(PaymentTransaction input) {
                    return input.getId().toString().equals(json.getTransactionId());
                }
            });
            if (paymentTransactionCandidates.size() != 1) return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            PaymentTransaction paymentTransaction = (PaymentTransaction)paymentTransactionCandidates.iterator().next();
            transactionType = paymentTransaction.getTransactionType();
            transactionExternalKey = paymentTransaction.getExternalKey();
        } else if (json != null && json.getTransactionExternalKey() != null && json.getTransactionType() != null) {
            transactionType = TransactionType.valueOf((String)json.getTransactionType());
            transactionExternalKey = json.getTransactionExternalKey();
        } else if (json != null && json.getTransactionExternalKey() != null) {
            paymentTransactionCandidates = Collections2.filter((Collection)initialPayment.getTransactions(), (Predicate)new Predicate<PaymentTransaction>(){

                public boolean apply(PaymentTransaction input) {
                    return input.getExternalKey().equals(json.getTransactionExternalKey());
                }
            });
            if (paymentTransactionCandidates.size() != 1) {
                this.verifyNonNullOrEmpty(null, "PaymentTransactionJson transactionType needs to be set");
                return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
            }
            transactionType = ((PaymentTransaction)paymentTransactionCandidates.iterator().next()).getTransactionType();
            transactionExternalKey = json.getTransactionExternalKey();
        } else if (json != null && json.getTransactionType() != null) {
            paymentTransactionCandidates = Collections2.filter((Collection)initialPayment.getTransactions(), (Predicate)new Predicate<PaymentTransaction>(){

                public boolean apply(PaymentTransaction input) {
                    return input.getTransactionType().toString().equals(json.getTransactionType());
                }
            });
            if (paymentTransactionCandidates.size() != 1) {
                this.verifyNonNullOrEmpty(null, "PaymentTransactionJson externalKey needs to be set");
                return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
            }
            transactionType = TransactionType.valueOf((String)json.getTransactionType());
            transactionExternalKey = ((PaymentTransaction)paymentTransactionCandidates.iterator().next()).getExternalKey();
        } else {
            if (initialPayment.getTransactions().size() != 1) {
                this.verifyNonNullOrEmpty(null, "PaymentTransactionJson transactionType and externalKey need to be set");
                return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
            }
            PaymentTransaction paymentTransaction = (PaymentTransaction)initialPayment.getTransactions().get(0);
            transactionType = paymentTransaction.getTransactionType();
            transactionExternalKey = paymentTransaction.getExternalKey();
        }
        PaymentOptions paymentOptions = this.createControlPluginApiPaymentOptions(paymentControlPluginNames);
        switch (transactionType) {
            case AUTHORIZE: {
                this.paymentApi.createAuthorizationWithPaymentControl(account, initialPayment.getPaymentMethodId(), initialPayment.getId(), amount, currency, initialPayment.getExternalKey(), transactionExternalKey, pluginProperties, paymentOptions, callContext);
                return this.uriBuilder.buildResponse(uriInfo, PaymentResource.class, "getPayment", initialPayment.getId());
            }
            case PURCHASE: {
                this.paymentApi.createPurchaseWithPaymentControl(account, initialPayment.getPaymentMethodId(), initialPayment.getId(), amount, currency, initialPayment.getExternalKey(), transactionExternalKey, pluginProperties, paymentOptions, callContext);
                return this.uriBuilder.buildResponse(uriInfo, PaymentResource.class, "getPayment", initialPayment.getId());
            }
            case CREDIT: {
                this.paymentApi.createCreditWithPaymentControl(account, initialPayment.getPaymentMethodId(), initialPayment.getId(), amount, currency, initialPayment.getExternalKey(), transactionExternalKey, pluginProperties, paymentOptions, callContext);
                return this.uriBuilder.buildResponse(uriInfo, PaymentResource.class, "getPayment", initialPayment.getId());
            }
            case REFUND: {
                this.paymentApi.createRefundWithPaymentControl(account, initialPayment.getId(), amount, currency, transactionExternalKey, pluginProperties, paymentOptions, callContext);
                return this.uriBuilder.buildResponse(uriInfo, PaymentResource.class, "getPayment", initialPayment.getId());
            }
        }
        return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)("TransactionType " + transactionType + " cannot be completed")).build();
    }

    @TimedResource(name="captureAuthorization")
    @POST
    @Path(value="/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Capture an existing authorization")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid paymentId supplied"), @ApiResponse(code=404, message="Account or payment not found")})
    public Response captureAuthorization(PaymentTransactionJson json, @PathParam(value="paymentId") String paymentIdStr, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws PaymentApiException, AccountApiException {
        return this.captureAuthorizationInternal(json, paymentIdStr, pluginPropertiesString, createdBy, reason, comment, uriInfo, request);
    }

    @TimedResource(name="captureAuthorization")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Capture an existing authorization")
    @ApiResponses(value={@ApiResponse(code=404, message="Account or payment not found")})
    public Response captureAuthorizationByExternalKey(PaymentTransactionJson json, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws PaymentApiException, AccountApiException {
        return this.captureAuthorizationInternal(json, null, pluginPropertiesString, createdBy, reason, comment, uriInfo, request);
    }

    private Response captureAuthorizationInternal(PaymentTransactionJson json, @Nullable String paymentIdStr, List<String> pluginPropertiesString, String createdBy, String reason, String comment, UriInfo uriInfo, HttpServletRequest request) throws PaymentApiException, AccountApiException {
        this.verifyNonNullOrEmpty(json, "PaymentTransactionJson body should be specified");
        this.verifyNonNullOrEmpty(json.getAmount(), "PaymentTransactionJson amount needs to be set");
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        Payment initialPayment = this.getPaymentByIdOrKey(paymentIdStr, json.getPaymentExternalKey(), pluginProperties, (TenantContext)callContext);
        Account account = this.accountUserApi.getAccountById(initialPayment.getAccountId(), (TenantContext)callContext);
        Currency currency = json.getCurrency() == null ? account.getCurrency() : Currency.valueOf((String)json.getCurrency());
        Payment payment = this.paymentApi.createCapture(account, initialPayment.getId(), json.getAmount(), currency, json.getTransactionExternalKey(), pluginProperties, callContext);
        return this.uriBuilder.buildResponse(uriInfo, PaymentResource.class, "getPayment", payment.getId());
    }

    @TimedResource(name="refundPayment")
    @POST
    @Path(value="/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}/refunds")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Refund an existing payment")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid paymentId supplied"), @ApiResponse(code=404, message="Account or payment not found")})
    public Response refundPayment(PaymentTransactionJson json, @PathParam(value="paymentId") String paymentIdStr, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws PaymentApiException, AccountApiException {
        return this.refundPaymentInternal(json, paymentIdStr, pluginPropertiesString, createdBy, reason, comment, uriInfo, request);
    }

    @TimedResource(name="refundPayment")
    @POST
    @Path(value="/refunds")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Refund an existing payment")
    @ApiResponses(value={@ApiResponse(code=404, message="Account or payment not found")})
    public Response refundPaymentByExternalKey(PaymentTransactionJson json, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws PaymentApiException, AccountApiException {
        return this.refundPaymentInternal(json, null, pluginPropertiesString, createdBy, reason, comment, uriInfo, request);
    }

    private Response refundPaymentInternal(PaymentTransactionJson json, @Nullable String paymentIdStr, List<String> pluginPropertiesString, String createdBy, String reason, String comment, UriInfo uriInfo, HttpServletRequest request) throws PaymentApiException, AccountApiException {
        this.verifyNonNullOrEmpty(json, "PaymentTransactionJson body should be specified");
        this.verifyNonNullOrEmpty(json.getAmount(), "PaymentTransactionJson amount needs to be set");
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        Payment initialPayment = this.getPaymentByIdOrKey(paymentIdStr, json.getPaymentExternalKey(), pluginProperties, (TenantContext)callContext);
        Account account = this.accountUserApi.getAccountById(initialPayment.getAccountId(), (TenantContext)callContext);
        Currency currency = json.getCurrency() == null ? account.getCurrency() : Currency.valueOf((String)json.getCurrency());
        Payment payment = this.paymentApi.createRefund(account, initialPayment.getId(), json.getAmount(), currency, json.getTransactionExternalKey(), pluginProperties, callContext);
        return this.uriBuilder.buildResponse(uriInfo, PaymentResource.class, "getPayment", payment.getId());
    }

    @TimedResource(name="voidPayment")
    @DELETE
    @Path(value="/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Void an existing payment")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid paymentId supplied"), @ApiResponse(code=404, message="Account or payment not found")})
    public Response voidPayment(PaymentTransactionJson json, @PathParam(value="paymentId") String paymentIdStr, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws PaymentApiException, AccountApiException {
        return this.voidPaymentInternal(json, paymentIdStr, pluginPropertiesString, createdBy, reason, comment, uriInfo, request);
    }

    @TimedResource(name="voidPayment")
    @DELETE
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Void an existing payment")
    @ApiResponses(value={@ApiResponse(code=404, message="Account or payment not found")})
    public Response voidPaymentByExternalKey(PaymentTransactionJson json, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws PaymentApiException, AccountApiException {
        return this.voidPaymentInternal(json, null, pluginPropertiesString, createdBy, reason, comment, uriInfo, request);
    }

    private Response voidPaymentInternal(PaymentTransactionJson json, @Nullable String paymentIdStr, List<String> pluginPropertiesString, String createdBy, String reason, String comment, UriInfo uriInfo, HttpServletRequest request) throws PaymentApiException, AccountApiException {
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        Payment initialPayment = this.getPaymentByIdOrKey(paymentIdStr, json.getPaymentExternalKey(), pluginProperties, (TenantContext)callContext);
        Account account = this.accountUserApi.getAccountById(initialPayment.getAccountId(), (TenantContext)callContext);
        String transactionExternalKey = json != null ? json.getTransactionExternalKey() : null;
        Payment payment = this.paymentApi.createVoid(account, initialPayment.getId(), transactionExternalKey, pluginProperties, callContext);
        return this.uriBuilder.buildResponse(uriInfo, PaymentResource.class, "getPayment", payment.getId());
    }

    @TimedResource(name="chargebackPayment")
    @POST
    @Path(value="/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}/chargebacks")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Record a chargeback")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid paymentId supplied"), @ApiResponse(code=404, message="Account not found")})
    public Response chargebackPayment(PaymentTransactionJson json, @PathParam(value="paymentId") String paymentIdStr, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws PaymentApiException, AccountApiException {
        return this.chargebackPaymentInternal(json, paymentIdStr, pluginPropertiesString, createdBy, reason, comment, uriInfo, request);
    }

    @TimedResource(name="chargebackPayment")
    @POST
    @Path(value="/chargebacks")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Record a chargeback")
    @ApiResponses(value={@ApiResponse(code=404, message="Account not found")})
    public Response chargebackPaymentByExternalKey(PaymentTransactionJson json, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws PaymentApiException, AccountApiException {
        return this.chargebackPaymentInternal(json, null, pluginPropertiesString, createdBy, reason, comment, uriInfo, request);
    }

    private Response chargebackPaymentInternal(PaymentTransactionJson json, @Nullable String paymentIdStr, List<String> pluginPropertiesString, String createdBy, String reason, String comment, UriInfo uriInfo, HttpServletRequest request) throws PaymentApiException, AccountApiException {
        this.verifyNonNullOrEmpty(json, "PaymentTransactionJson body should be specified");
        this.verifyNonNullOrEmpty(json.getAmount(), "PaymentTransactionJson amount needs to be set");
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        Payment initialPayment = this.getPaymentByIdOrKey(paymentIdStr, json.getPaymentExternalKey(), pluginProperties, (TenantContext)callContext);
        Account account = this.accountUserApi.getAccountById(initialPayment.getAccountId(), (TenantContext)callContext);
        Currency currency = json.getCurrency() == null ? account.getCurrency() : Currency.valueOf((String)json.getCurrency());
        Payment payment = this.paymentApi.createChargeback(account, initialPayment.getId(), json.getAmount(), currency, json.getTransactionExternalKey(), callContext);
        return this.uriBuilder.buildResponse(uriInfo, PaymentResource.class, "getPayment", payment.getId());
    }

    @TimedResource
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/combo")
    @ApiOperation(value="Combo api to create a new payment transaction on a existing (or not) account ")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid data for Account or PaymentMethod")})
    public Response createComboPayment(@MetricTag(tag="type", property="transactionType") ComboPaymentTransactionJson json, @QueryParam(value="controlPluginName") List<String> paymentControlPluginNames, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws PaymentApiException, AccountApiException {
        Payment result;
        this.verifyNonNullOrEmpty(json, "ComboPaymentTransactionJson body should be specified");
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        Account account = this.getOrCreateAccount(json.getAccount(), callContext);
        Iterable<PluginProperty> paymentMethodPluginProperties = this.extractPluginProperties(json.getPaymentMethodPluginProperties());
        UUID paymentMethodId = this.getOrCreatePaymentMethod(account, json.getPaymentMethod(), paymentMethodPluginProperties, callContext);
        PaymentTransactionJson paymentTransactionJson = json.getTransaction();
        TransactionType transactionType = TransactionType.valueOf((String)paymentTransactionJson.getTransactionType());
        PaymentOptions paymentOptions = this.createControlPluginApiPaymentOptions(paymentControlPluginNames);
        Iterable<PluginProperty> transactionPluginProperties = this.extractPluginProperties(json.getTransactionPluginProperties());
        Currency currency = paymentTransactionJson.getCurrency() == null ? account.getCurrency() : Currency.valueOf((String)paymentTransactionJson.getCurrency());
        UUID paymentId = null;
        switch (transactionType) {
            case AUTHORIZE: {
                result = this.paymentApi.createAuthorizationWithPaymentControl(account, paymentMethodId, paymentId, paymentTransactionJson.getAmount(), currency, paymentTransactionJson.getPaymentExternalKey(), paymentTransactionJson.getTransactionExternalKey(), transactionPluginProperties, paymentOptions, callContext);
                break;
            }
            case PURCHASE: {
                result = this.paymentApi.createPurchaseWithPaymentControl(account, paymentMethodId, paymentId, paymentTransactionJson.getAmount(), currency, paymentTransactionJson.getPaymentExternalKey(), paymentTransactionJson.getTransactionExternalKey(), transactionPluginProperties, paymentOptions, callContext);
                break;
            }
            case CREDIT: {
                result = this.paymentApi.createCreditWithPaymentControl(account, paymentMethodId, paymentId, paymentTransactionJson.getAmount(), currency, paymentTransactionJson.getPaymentExternalKey(), paymentTransactionJson.getTransactionExternalKey(), transactionPluginProperties, paymentOptions, callContext);
                break;
            }
            default: {
                return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)("TransactionType " + transactionType + " is not allowed for an account")).build();
            }
        }
        return this.uriBuilder.buildResponse(uriInfo, PaymentResource.class, "getPayment", result.getId());
    }

    @Override
    protected ObjectType getObjectType() {
        return ObjectType.PAYMENT;
    }
}

