/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.jaxrs.json.CustomFieldJson;
import org.killbill.billing.jaxrs.json.PaymentMethodJson;
import org.killbill.billing.jaxrs.resources.AuditMode;
import org.killbill.billing.jaxrs.resources.JaxRsResourceBase;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.payment.api.PaymentApi;
import org.killbill.billing.payment.api.PaymentApiException;
import org.killbill.billing.payment.api.PaymentMethod;
import org.killbill.billing.payment.api.PluginProperty;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldApiException;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.audit.AccountAuditLogs;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.entity.Pagination;
import org.killbill.clock.Clock;
import org.killbill.commons.metrics.TimedResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
@Path(value="/1.0/kb/paymentMethods")
@Api(value="/1.0/kb/paymentMethods", description="Operations on payment methods")
public class PaymentMethodResource
extends JaxRsResourceBase {
    @Inject
    public PaymentMethodResource(AccountUserApi accountUserApi, JaxrsUriBuilder uriBuilder, TagUserApi tagUserApi, CustomFieldUserApi customFieldUserApi, AuditUserApi auditUserApi, PaymentApi paymentApi, Clock clock, org.killbill.billing.jaxrs.util.Context context) {
        super(uriBuilder, tagUserApi, customFieldUserApi, auditUserApi, accountUserApi, paymentApi, clock, context);
    }

    @TimedResource(name="getPaymentMethod")
    @GET
    @Path(value="/{paymentMethodId:\\w+-\\w+-\\w+-\\w+-\\w+}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve a payment method by id", response=PaymentMethodJson.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid paymentMethodId supplied"), @ApiResponse(code=404, message="Account or payment method not found")})
    public Response getPaymentMethod(@PathParam(value="paymentMethodId") String paymentMethodId, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @QueryParam(value="withPluginInfo") @DefaultValue(value="false") Boolean withPluginInfo, @Context HttpServletRequest request) throws AccountApiException, PaymentApiException {
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        PaymentMethod paymentMethod = this.paymentApi.getPaymentMethodById(UUID.fromString(paymentMethodId), false, withPluginInfo.booleanValue(), pluginProperties, tenantContext);
        Account account = this.accountUserApi.getAccountById(paymentMethod.getAccountId(), tenantContext);
        AccountAuditLogs accountAuditLogs = this.auditUserApi.getAccountAuditLogs(paymentMethod.getAccountId(), auditMode.getLevel(), tenantContext);
        PaymentMethodJson json = PaymentMethodJson.toPaymentMethodJson(account, paymentMethod, accountAuditLogs);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)json).build();
    }

    @TimedResource(name="getPaymentMethod")
    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve a payment method by external key", response=PaymentMethodJson.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Account or payment method not found")})
    public Response getPaymentMethodByKey(@QueryParam(value="externalKey") String externalKey, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @QueryParam(value="withPluginInfo") @DefaultValue(value="false") Boolean withPluginInfo, @Context HttpServletRequest request) throws AccountApiException, PaymentApiException {
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        PaymentMethod paymentMethod = this.paymentApi.getPaymentMethodByExternalKey(externalKey, false, withPluginInfo.booleanValue(), pluginProperties, tenantContext);
        Account account = this.accountUserApi.getAccountById(paymentMethod.getAccountId(), tenantContext);
        AccountAuditLogs accountAuditLogs = this.auditUserApi.getAccountAuditLogs(paymentMethod.getAccountId(), auditMode.getLevel(), tenantContext);
        PaymentMethodJson json = PaymentMethodJson.toPaymentMethodJson(account, paymentMethod, accountAuditLogs);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)json).build();
    }

    @TimedResource
    @GET
    @Path(value="/pagination")
    @Produces(value={"application/json"})
    @ApiOperation(value="List payment methods", response=PaymentMethodJson.class, responseContainer="List")
    @ApiResponses(value={})
    public Response getPaymentMethods(@QueryParam(value="offset") @DefaultValue(value="0") Long offset, @QueryParam(value="limit") @DefaultValue(value="100") Long limit, @QueryParam(value="pluginName") String pluginName, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, final @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @QueryParam(value="withPluginInfo") @DefaultValue(value="false") Boolean withPluginInfo, @Context HttpServletRequest request) throws PaymentApiException {
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        final TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        Pagination paymentMethods = Strings.isNullOrEmpty((String)pluginName) ? this.paymentApi.getPaymentMethods(offset, limit, withPluginInfo.booleanValue(), pluginProperties, tenantContext) : this.paymentApi.getPaymentMethods(offset, limit, pluginName, withPluginInfo.booleanValue(), pluginProperties, tenantContext);
        URI nextPageUri = this.uriBuilder.nextPage(PaymentMethodResource.class, "getPaymentMethods", paymentMethods.getNextOffset(), limit, (Map<String, String>)ImmutableMap.of((Object)"pluginName", (Object)Strings.nullToEmpty((String)pluginName), (Object)"audit", (Object)auditMode.getLevel().toString()));
        final AtomicReference accountsAuditLogs = new AtomicReference(new HashMap());
        final HashMap accounts = new HashMap();
        return this.buildStreamingPaginationResponse(paymentMethods, new Function<PaymentMethod, PaymentMethodJson>(){

            public PaymentMethodJson apply(PaymentMethod paymentMethod) {
                if (((Map)accountsAuditLogs.get()).get(paymentMethod.getAccountId()) == null) {
                    ((Map)accountsAuditLogs.get()).put(paymentMethod.getAccountId(), PaymentMethodResource.this.auditUserApi.getAccountAuditLogs(paymentMethod.getAccountId(), auditMode.getLevel(), tenantContext));
                }
                if (accounts.get(paymentMethod.getAccountId()) == null) {
                    try {
                        Account account = PaymentMethodResource.this.accountUserApi.getAccountById(paymentMethod.getAccountId(), tenantContext);
                        accounts.put(paymentMethod.getAccountId(), account);
                    }
                    catch (AccountApiException e) {
                        JaxRsResourceBase.log.warn("Unable to retrieve account", (Throwable)e);
                        return null;
                    }
                }
                return PaymentMethodJson.toPaymentMethodJson((Account)accounts.get(paymentMethod.getAccountId()), paymentMethod, (AccountAuditLogs)((Map)accountsAuditLogs.get()).get(paymentMethod.getAccountId()));
            }
        }, nextPageUri);
    }

    @TimedResource
    @GET
    @Path(value="/search/{searchKey:.*}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Search payment methods", response=PaymentMethodJson.class, responseContainer="List")
    @ApiResponses(value={})
    public Response searchPaymentMethods(@PathParam(value="searchKey") String searchKey, @QueryParam(value="offset") @DefaultValue(value="0") Long offset, @QueryParam(value="limit") @DefaultValue(value="100") Long limit, @QueryParam(value="pluginName") String pluginName, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, final @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @QueryParam(value="withPluginInfo") @DefaultValue(value="false") Boolean withPluginInfo, @Context HttpServletRequest request) throws PaymentApiException, AccountApiException {
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        final TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        Pagination paymentMethods = Strings.isNullOrEmpty((String)pluginName) ? this.paymentApi.searchPaymentMethods(searchKey, offset, limit, withPluginInfo.booleanValue(), pluginProperties, tenantContext) : this.paymentApi.searchPaymentMethods(searchKey, offset, limit, pluginName, withPluginInfo.booleanValue(), pluginProperties, tenantContext);
        URI nextPageUri = this.uriBuilder.nextPage(PaymentMethodResource.class, "searchPaymentMethods", paymentMethods.getNextOffset(), limit, (Map<String, String>)ImmutableMap.of((Object)"searchKey", (Object)searchKey, (Object)"pluginName", (Object)Strings.nullToEmpty((String)pluginName), (Object)"audit", (Object)auditMode.getLevel().toString()));
        final AtomicReference accountsAuditLogs = new AtomicReference(new HashMap());
        final HashMap accounts = new HashMap();
        return this.buildStreamingPaginationResponse(paymentMethods, new Function<PaymentMethod, PaymentMethodJson>(){

            public PaymentMethodJson apply(PaymentMethod paymentMethod) {
                if (((Map)accountsAuditLogs.get()).get(paymentMethod.getAccountId()) == null) {
                    ((Map)accountsAuditLogs.get()).put(paymentMethod.getAccountId(), PaymentMethodResource.this.auditUserApi.getAccountAuditLogs(paymentMethod.getAccountId(), auditMode.getLevel(), tenantContext));
                }
                if (accounts.get(paymentMethod.getAccountId()) == null) {
                    try {
                        Account account = PaymentMethodResource.this.accountUserApi.getAccountById(paymentMethod.getAccountId(), tenantContext);
                        accounts.put(paymentMethod.getAccountId(), account);
                    }
                    catch (AccountApiException e) {
                        JaxRsResourceBase.log.warn("Unable to retrieve account", (Throwable)e);
                        return null;
                    }
                }
                return PaymentMethodJson.toPaymentMethodJson((Account)accounts.get(paymentMethod.getAccountId()), paymentMethod, (AccountAuditLogs)((Map)accountsAuditLogs.get()).get(paymentMethod.getAccountId()));
            }
        }, nextPageUri);
    }

    @TimedResource
    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/{paymentMethodId:\\w+-\\w+-\\w+-\\w+-\\w+}")
    @ApiOperation(value="Delete a payment method")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid paymentMethodId supplied"), @ApiResponse(code=404, message="Account or payment method not found")})
    public Response deletePaymentMethod(@PathParam(value="paymentMethodId") String paymentMethodId, @QueryParam(value="deleteDefaultPmWithAutoPayOff") @DefaultValue(value="false") Boolean deleteDefaultPaymentMethodWithAutoPayOff, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) throws PaymentApiException, AccountApiException {
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        PaymentMethod paymentMethod = this.paymentApi.getPaymentMethodById(UUID.fromString(paymentMethodId), false, false, pluginProperties, (TenantContext)callContext);
        Account account = this.accountUserApi.getAccountById(paymentMethod.getAccountId(), (TenantContext)callContext);
        this.paymentApi.deletePaymentMethod(account, UUID.fromString(paymentMethodId), deleteDefaultPaymentMethodWithAutoPayOff.booleanValue(), pluginProperties, callContext);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @TimedResource
    @GET
    @Path(value="/{paymentMethodId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve payment method custom fields", response=CustomFieldJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid payment method id supplied")})
    public Response getCustomFields(@PathParam(value="paymentMethodId") String paymentMethodId, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) {
        return super.getCustomFields(UUID.fromString(paymentMethodId), auditMode, this.context.createContext((ServletRequest)request));
    }

    @TimedResource
    @POST
    @Path(value="/{paymentMethodId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Add custom fields to payment method")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid payment method id supplied")})
    public Response createCustomFields(@PathParam(value="paymentMethodId") String paymentMethodId, List<CustomFieldJson> customFields, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request, @Context UriInfo uriInfo) throws CustomFieldApiException {
        return super.createCustomFields(UUID.fromString(paymentMethodId), customFields, this.context.createContext(createdBy, reason, comment, (ServletRequest)request), uriInfo);
    }

    @TimedResource
    @DELETE
    @Path(value="/{paymentMethodId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Remove custom fields from payment method")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid payment method id supplied")})
    public Response deleteCustomFields(@PathParam(value="paymentMethodId") String paymentMethodId, @QueryParam(value="customFieldList") String customFieldList, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) throws CustomFieldApiException {
        return super.deleteCustomFields(UUID.fromString(paymentMethodId), customFieldList, this.context.createContext(createdBy, reason, comment, (ServletRequest)request));
    }

    @Override
    protected ObjectType getObjectType() {
        return ObjectType.PAYMENT_METHOD;
    }
}

