/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiResponses;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.jaxrs.resources.JaxRsResourceBase;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.overdue.api.OverdueApi;
import org.killbill.billing.overdue.config.DefaultOverdueConfig;
import org.killbill.billing.payment.api.PaymentApi;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.clock.Clock;
import org.killbill.commons.metrics.TimedResource;
import org.killbill.xmlloader.XMLLoader;
import org.killbill.xmlloader.XMLWriter;

@Singleton
@Path(value="/1.0/kb/overdue")
@Api(value="/1.0/kb/overdue", description="Overdue information")
public class OverdueResource
extends JaxRsResourceBase {
    private final OverdueApi overdueApi;

    @Inject
    public OverdueResource(JaxrsUriBuilder uriBuilder, TagUserApi tagUserApi, CustomFieldUserApi customFieldUserApi, AuditUserApi auditUserApi, AccountUserApi accountUserApi, PaymentApi paymentApi, OverdueApi overdueApi, Clock clock, org.killbill.billing.jaxrs.util.Context context) {
        super(uriBuilder, tagUserApi, customFieldUserApi, auditUserApi, accountUserApi, paymentApi, clock, context);
        this.overdueApi = overdueApi;
    }

    @TimedResource
    @GET
    @Produces(value={"application/xml"})
    @ApiOperation(value="Retrieve the full catalog as XML", response=String.class, hidden=true)
    @ApiResponses(value={})
    public Response getOverdueConfigXml(@Context HttpServletRequest request) throws Exception {
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)XMLWriter.writeXML((Object)((DefaultOverdueConfig)this.overdueApi.getOverdueConfig(tenantContext)), DefaultOverdueConfig.class)).build();
    }

    @TimedResource
    @POST
    @Consumes(value={"application/xml"})
    @ApiOperation(value="Upload the full overdue config as XML")
    @ApiResponses(value={})
    public Response uploadOverdueConfigXml(String overdueXML, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request, @Context UriInfo uriInfo) throws Exception {
        ByteArrayInputStream stream = new ByteArrayInputStream(overdueXML.getBytes());
        XMLLoader.getObjectFromStream((URI)new URI("/1.0/kb/overdue"), (InputStream)stream, DefaultOverdueConfig.class);
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        this.overdueApi.uploadOverdueConfig(overdueXML, callContext);
        return this.uriBuilder.buildResponse(uriInfo, OverdueResource.class, null, null);
    }
}

