/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriInfo;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.invoice.api.InvoicePayment;
import org.killbill.billing.invoice.api.InvoicePaymentType;
import org.killbill.billing.jaxrs.json.CustomFieldJson;
import org.killbill.billing.jaxrs.json.JsonBase;
import org.killbill.billing.jaxrs.json.PluginPropertyJson;
import org.killbill.billing.jaxrs.json.TagJson;
import org.killbill.billing.jaxrs.resources.AuditMode;
import org.killbill.billing.jaxrs.resources.JaxrsResource;
import org.killbill.billing.jaxrs.util.Context;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.payment.api.Payment;
import org.killbill.billing.payment.api.PaymentApi;
import org.killbill.billing.payment.api.PaymentApiException;
import org.killbill.billing.payment.api.PaymentMethod;
import org.killbill.billing.payment.api.PaymentOptions;
import org.killbill.billing.payment.api.PaymentTransaction;
import org.killbill.billing.payment.api.PluginProperty;
import org.killbill.billing.payment.api.TransactionType;
import org.killbill.billing.util.UUIDs;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldApiException;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.TagApiException;
import org.killbill.billing.util.api.TagDefinitionApiException;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.audit.AccountAuditLogsForObjectType;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.customfield.CustomField;
import org.killbill.billing.util.customfield.StringCustomField;
import org.killbill.billing.util.entity.Entity;
import org.killbill.billing.util.entity.Pagination;
import org.killbill.billing.util.jackson.ObjectMapper;
import org.killbill.billing.util.tag.Tag;
import org.killbill.billing.util.tag.TagDefinition;
import org.killbill.clock.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JaxRsResourceBase
implements JaxrsResource {
    static final Logger log = LoggerFactory.getLogger(JaxRsResourceBase.class);
    protected static final ObjectMapper mapper = new ObjectMapper();
    protected final JaxrsUriBuilder uriBuilder;
    protected final TagUserApi tagUserApi;
    protected final CustomFieldUserApi customFieldUserApi;
    protected final AuditUserApi auditUserApi;
    protected final AccountUserApi accountUserApi;
    protected final PaymentApi paymentApi;
    protected final Context context;
    protected final Clock clock;
    protected final DateTimeFormatter DATE_TIME_FORMATTER = ISODateTimeFormat.dateTimeParser();
    protected final DateTimeFormatter LOCAL_DATE_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd");

    public JaxRsResourceBase(JaxrsUriBuilder uriBuilder, TagUserApi tagUserApi, CustomFieldUserApi customFieldUserApi, AuditUserApi auditUserApi, AccountUserApi accountUserApi, PaymentApi paymentApi, Clock clock, Context context) {
        this.uriBuilder = uriBuilder;
        this.tagUserApi = tagUserApi;
        this.customFieldUserApi = customFieldUserApi;
        this.auditUserApi = auditUserApi;
        this.accountUserApi = accountUserApi;
        this.paymentApi = paymentApi;
        this.clock = clock;
        this.context = context;
    }

    protected ObjectType getObjectType() {
        return null;
    }

    protected Response getTags(UUID accountId, UUID taggedObjectId, AuditMode auditMode, boolean includeDeleted, TenantContext context) throws TagDefinitionApiException {
        List tags = this.tagUserApi.getTagsForObject(taggedObjectId, this.getObjectType(), includeDeleted, context);
        return this.createTagResponse(accountId, tags, auditMode, context);
    }

    protected Response createTagResponse(UUID accountId, List<Tag> tags, AuditMode auditMode, TenantContext context) throws TagDefinitionApiException {
        AccountAuditLogsForObjectType tagsAuditLogs = this.auditUserApi.getAccountAuditLogs(accountId, ObjectType.TAG, auditMode.getLevel(), context);
        HashMap<UUID, TagDefinition> tagDefinitionsCache = new HashMap<UUID, TagDefinition>();
        LinkedList<TagJson> result = new LinkedList<TagJson>();
        for (Tag tag : tags) {
            if (tagDefinitionsCache.get(tag.getTagDefinitionId()) == null) {
                tagDefinitionsCache.put(tag.getTagDefinitionId(), this.tagUserApi.getTagDefinition(tag.getTagDefinitionId(), context));
            }
            TagDefinition tagDefinition = (TagDefinition)tagDefinitionsCache.get(tag.getTagDefinitionId());
            List auditLogs = tagsAuditLogs.getAuditLogs(tag.getId());
            result.add(new TagJson(tag, tagDefinition, auditLogs));
        }
        return Response.status((Response.Status)Response.Status.OK).entity(result).build();
    }

    protected Response createTags(UUID id, String tagList, UriInfo uriInfo, CallContext context) throws TagApiException {
        Collection<UUID> input = this.getTagDefinitionUUIDs(tagList);
        this.tagUserApi.addTags(id, this.getObjectType(), input, context);
        return this.uriBuilder.buildResponse(this.getClass(), "getTags", id, uriInfo.getBaseUri().toString());
    }

    protected Collection<UUID> getTagDefinitionUUIDs(String tagList) {
        Object[] tagParts = tagList.split(",\\s*");
        return Collections2.transform((Collection)ImmutableList.copyOf((Object[])tagParts), (Function)new Function<String, UUID>(){

            public UUID apply(String input) {
                return UUID.fromString(input);
            }
        });
    }

    protected Response deleteTags(UUID id, String tagList, CallContext context) throws TagApiException {
        Collection<UUID> input = this.getTagDefinitionUUIDs(tagList);
        this.tagUserApi.removeTags(id, this.getObjectType(), input, context);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    protected Response getCustomFields(UUID id, AuditMode auditMode, TenantContext context) {
        List fields = this.customFieldUserApi.getCustomFieldsForObject(id, this.getObjectType(), context);
        LinkedList<CustomFieldJson> result = new LinkedList<CustomFieldJson>();
        for (CustomField cur : fields) {
            List auditLogs = this.auditUserApi.getAuditLogs(cur.getId(), ObjectType.CUSTOM_FIELD, auditMode.getLevel(), context);
            result.add(new CustomFieldJson(cur, auditLogs));
        }
        return Response.status((Response.Status)Response.Status.OK).entity(result).build();
    }

    protected Response createCustomFields(UUID id, List<CustomFieldJson> customFields, CallContext context, UriInfo uriInfo) throws CustomFieldApiException {
        LinkedList<StringCustomField> input = new LinkedList<StringCustomField>();
        for (CustomFieldJson cur : customFields) {
            this.verifyNonNullOrEmpty(cur.getName(), "CustomFieldJson name needs to be set");
            this.verifyNonNullOrEmpty(cur.getValue(), "CustomFieldJson value needs to be set");
            input.add(new StringCustomField(cur.getName(), cur.getValue(), this.getObjectType(), id, context.getCreatedDate()));
        }
        this.customFieldUserApi.addCustomFields(input, context);
        return this.uriBuilder.buildResponse(uriInfo, this.getClass(), "getCustomFields", id);
    }

    protected Response deleteCustomFields(UUID id, final @Nullable String customFieldList, CallContext context) throws CustomFieldApiException {
        String[] requestedIds;
        List fields = this.customFieldUserApi.getCustomFieldsForObject(id, this.getObjectType(), (TenantContext)context);
        Iterable inputIterable = Iterables.filter((Iterable)fields, (Predicate)new Predicate<CustomField>(requestedIds = customFieldList != null ? customFieldList.split("\\s*,\\s*") : null){
            final /* synthetic */ String[] val$requestedIds;
            {
                this.val$requestedIds = stringArray;
            }

            public boolean apply(CustomField input) {
                if (customFieldList == null) {
                    return true;
                }
                for (String cur : this.val$requestedIds) {
                    UUID curId = UUID.fromString(cur);
                    if (!input.getId().equals(curId)) continue;
                    return true;
                }
                return false;
            }
        });
        if (inputIterable.iterator().hasNext()) {
            ImmutableList input = ImmutableList.copyOf((Iterable)inputIterable);
            this.customFieldUserApi.removeCustomFields((List)input, context);
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    protected <E extends Entity, J extends JsonBase> Response buildStreamingPaginationResponse(final Pagination<E> entities, final Function<E, J> toJson, URI nextPageUri) {
        StreamingOutput json = new StreamingOutput(){

            public void write(OutputStream output) throws IOException, WebApplicationException {
                JsonGenerator generator = mapper.getFactory().createJsonGenerator(output);
                generator.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
                generator.writeStartArray();
                for (Entity entity : entities) {
                    JsonBase asJson = (JsonBase)toJson.apply((Object)entity);
                    if (asJson == null) continue;
                    generator.writeObject((Object)asJson);
                }
                generator.writeEndArray();
                generator.close();
            }
        };
        return Response.status((Response.Status)Response.Status.OK).entity((Object)json).header("X-Killbill-Pagination-CurrentOffset", (Object)entities.getCurrentOffset()).header("X-Killbill-Pagination-NextOffset", (Object)entities.getNextOffset()).header("X-Killbill-Pagination-TotalNbRecords", (Object)entities.getTotalNbRecords()).header("X-Killbill-Pagination-MaxNbRecords", (Object)entities.getMaxNbRecords()).header("X-Killbill-Pagination-NextPageUri", (Object)nextPageUri).build();
    }

    protected void validatePaymentMethodForAccount(UUID accountId, UUID paymentMethodId, CallContext callContext) throws PaymentApiException {
        this.verifyNonNull(paymentMethodId, "paymentMethodId should be specified");
        PaymentMethod paymentMethod = this.paymentApi.getPaymentMethodById(paymentMethodId, false, false, (Iterable)ImmutableList.of(), (TenantContext)callContext);
        if (!paymentMethod.getAccountId().equals(accountId)) {
            throw new PaymentApiException(ErrorCode.PAYMENT_NO_SUCH_PAYMENT_METHOD, new Object[]{paymentMethodId});
        }
    }

    protected LocalDate toLocalDate(UUID accountId, String inputDate, TenantContext context) throws AccountApiException {
        LocalDate maybeResult = this.extractLocalDate(inputDate);
        if (maybeResult != null) {
            return maybeResult;
        }
        Account account = accountId != null ? this.accountUserApi.getAccountById(accountId, context) : null;
        DateTime inputDateTime = inputDate != null ? this.DATE_TIME_FORMATTER.parseDateTime(inputDate) : this.clock.getUTCNow();
        return this.toLocalDate(account, inputDateTime, context);
    }

    protected LocalDate toLocalDate(Account account, String inputDate, TenantContext context) {
        LocalDate maybeResult = this.extractLocalDate(inputDate);
        if (maybeResult != null) {
            return maybeResult;
        }
        DateTime inputDateTime = inputDate != null ? this.DATE_TIME_FORMATTER.parseDateTime(inputDate) : this.clock.getUTCNow();
        return this.toLocalDate(account, inputDateTime, context);
    }

    private LocalDate toLocalDate(Account account, DateTime inputDate, TenantContext context) {
        if (account == null && inputDate == null) {
            return new LocalDate((Object)this.clock.getUTCNow(), DateTimeZone.UTC);
        }
        if (account == null && inputDate != null) {
            return new LocalDate((Object)inputDate, DateTimeZone.UTC);
        }
        if (account != null && inputDate == null) {
            return new LocalDate((Object)this.clock.getUTCNow(), account.getTimeZone());
        }
        return new LocalDate((Object)inputDate, account.getTimeZone());
    }

    private LocalDate extractLocalDate(String inputDate) {
        if (inputDate != null) {
            try {
                LocalDate localDate = LocalDate.parse((String)inputDate, (DateTimeFormatter)this.LOCAL_DATE_FORMATTER);
                return localDate;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    protected Iterable<PluginProperty> extractPluginProperties(@Nullable Iterable<PluginPropertyJson> pluginProperties) {
        return pluginProperties != null ? Iterables.transform(pluginProperties, (Function)new Function<PluginPropertyJson, PluginProperty>(){

            public PluginProperty apply(PluginPropertyJson pluginPropertyJson) {
                return pluginPropertyJson.toPluginProperty();
            }
        }) : ImmutableList.of();
    }

    protected Iterable<PluginProperty> extractPluginProperties(@Nullable Iterable<String> pluginProperties, PluginProperty ... additionalProperties) {
        LinkedList<PluginProperty> properties = new LinkedList<PluginProperty>();
        if (pluginProperties == null) {
            return properties;
        }
        for (String pluginProperty : pluginProperties) {
            ImmutableList property = ImmutableList.copyOf((Object[])pluginProperty.split("="));
            if (property.size() == 1) continue;
            String key = (String)property.get(0);
            String value = Joiner.on((String)"=").join(property.subList(1, property.size()));
            if (pluginProperty.endsWith("=")) {
                value = value + "=";
            }
            properties.add(new PluginProperty(key, (Object)value, Boolean.valueOf(false)));
        }
        for (PluginProperty cur : additionalProperties) {
            properties.add(cur);
        }
        return properties;
    }

    protected Payment createPurchaseForInvoice(Account account, UUID invoiceId, BigDecimal amountToPay, UUID paymentMethodId, Boolean externalPayment, Iterable<PluginProperty> pluginProperties, CallContext callContext) throws PaymentApiException {
        ArrayList<PluginProperty> properties = new ArrayList<PluginProperty>();
        Iterator<PluginProperty> pluginPropertyIterator = pluginProperties.iterator();
        while (pluginPropertyIterator.hasNext()) {
            properties.add(pluginPropertyIterator.next());
        }
        String paymentExternalKey = UUIDs.randomUUID().toString();
        String transactionExternalKey = UUIDs.randomUUID().toString();
        PluginProperty invoiceProperty = new PluginProperty("IPCD_INVOICE_ID", (Object)invoiceId.toString(), Boolean.valueOf(false));
        properties.add(invoiceProperty);
        return this.paymentApi.createPurchaseWithPaymentControl(account, paymentMethodId, null, amountToPay, account.getCurrency(), paymentExternalKey, transactionExternalKey, properties, this.createInvoicePaymentControlPluginApiPaymentOptions(externalPayment), callContext);
    }

    protected PaymentOptions createInvoicePaymentControlPluginApiPaymentOptions(boolean isExternalPayment) {
        return this.createControlPluginApiPaymentOptions(isExternalPayment, (List<String>)ImmutableList.of((Object)"__INVOICE_PAYMENT_CONTROL_PLUGIN__"));
    }

    protected PaymentOptions createControlPluginApiPaymentOptions(@Nullable List<String> paymentControlPluginNames) {
        return this.createControlPluginApiPaymentOptions(false, paymentControlPluginNames);
    }

    protected PaymentOptions createControlPluginApiPaymentOptions(final boolean isExternalPayment, final List<String> paymentControlPluginNames) {
        return new PaymentOptions(){

            public boolean isExternalPayment() {
                return isExternalPayment;
            }

            public List<String> getPaymentControlPluginNames() {
                return paymentControlPluginNames;
            }
        };
    }

    public static Iterable<PaymentTransaction> getPaymentTransactions(List<Payment> payments, final TransactionType transactionType) {
        return Iterables.concat((Iterable)Iterables.transform(payments, (Function)new Function<Payment, Iterable<PaymentTransaction>>(){

            public Iterable<PaymentTransaction> apply(Payment input) {
                return Iterables.filter((Iterable)input.getTransactions(), (Predicate)new Predicate<PaymentTransaction>(){

                    public boolean apply(PaymentTransaction input) {
                        return input.getTransactionType() == transactionType;
                    }
                });
            }
        }));
    }

    public static UUID getInvoiceId(List<InvoicePayment> invoicePayments, final Payment payment) {
        InvoicePayment invoicePayment = (InvoicePayment)Iterables.tryFind(invoicePayments, (Predicate)new Predicate<InvoicePayment>(){

            public boolean apply(InvoicePayment input) {
                return input.getPaymentId().equals(payment.getId()) && input.getType() == InvoicePaymentType.ATTEMPT;
            }
        }).orNull();
        return invoicePayment != null ? invoicePayment.getInvoiceId() : null;
    }

    protected void verifyNonNullOrEmpty(Object ... elements) {
        Preconditions.checkArgument((elements.length % 2 == 0 ? 1 : 0) != 0, (String)"%s should have an even number of elements", (Object[])new Object[]{Arrays.toString(elements)});
        for (int i = 0; i < elements.length; i += 2) {
            Object argument = elements[i];
            Object errorMessage = elements[i + 1];
            boolean expression = argument instanceof String ? Strings.emptyToNull((String)((String)argument)) != null : argument != null;
            Preconditions.checkArgument((boolean)expression, (Object)errorMessage);
        }
    }

    protected void verifyNonNull(Object ... elements) {
        Preconditions.checkArgument((elements.length % 2 == 0 ? 1 : 0) != 0, (String)"%s should have an even number of elements", (Object[])new Object[]{Arrays.toString(elements)});
        for (int i = 0; i < elements.length; i += 2) {
            Object argument = elements[i];
            Object errorMessage = elements[i + 1];
            boolean expression = argument != null;
            Preconditions.checkArgument((boolean)expression, (Object)errorMessage);
        }
    }
}

