/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.inject.Inject;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import org.joda.time.ReadableInstant;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.catalog.DefaultPlanPhasePriceOverride;
import org.killbill.billing.catalog.api.BillingActionPolicy;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.PhaseType;
import org.killbill.billing.catalog.api.PlanPhasePriceOverride;
import org.killbill.billing.catalog.api.PlanPhaseSpecifier;
import org.killbill.billing.catalog.api.ProductCategory;
import org.killbill.billing.entitlement.api.SubscriptionApiException;
import org.killbill.billing.entitlement.api.SubscriptionEventType;
import org.killbill.billing.invoice.api.DryRunArguments;
import org.killbill.billing.invoice.api.DryRunType;
import org.killbill.billing.invoice.api.Invoice;
import org.killbill.billing.invoice.api.InvoiceApiException;
import org.killbill.billing.invoice.api.InvoiceItem;
import org.killbill.billing.invoice.api.InvoiceNotifier;
import org.killbill.billing.invoice.api.InvoicePayment;
import org.killbill.billing.invoice.api.InvoiceUserApi;
import org.killbill.billing.jaxrs.json.CustomFieldJson;
import org.killbill.billing.jaxrs.json.InvoiceDryRunJson;
import org.killbill.billing.jaxrs.json.InvoiceItemJson;
import org.killbill.billing.jaxrs.json.InvoiceJson;
import org.killbill.billing.jaxrs.json.InvoicePaymentJson;
import org.killbill.billing.jaxrs.json.PhasePriceOverrideJson;
import org.killbill.billing.jaxrs.json.TagJson;
import org.killbill.billing.jaxrs.resources.AuditMode;
import org.killbill.billing.jaxrs.resources.InvoicePaymentResource;
import org.killbill.billing.jaxrs.resources.JaxRsResourceBase;
import org.killbill.billing.jaxrs.util.Context;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.payment.api.Payment;
import org.killbill.billing.payment.api.PaymentApi;
import org.killbill.billing.payment.api.PaymentApiException;
import org.killbill.billing.payment.api.PluginProperty;
import org.killbill.billing.tenant.api.TenantApiException;
import org.killbill.billing.tenant.api.TenantKV;
import org.killbill.billing.tenant.api.TenantUserApi;
import org.killbill.billing.util.LocaleUtils;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldApiException;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.TagApiException;
import org.killbill.billing.util.api.TagDefinitionApiException;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.audit.AccountAuditLogs;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.entity.Pagination;
import org.killbill.clock.Clock;
import org.killbill.clock.ClockUtil;
import org.killbill.commons.metrics.TimedResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/1.0/kb/invoices")
@Api(value="/1.0/kb/invoices", description="Operations on invoices")
public class InvoiceResource
extends JaxRsResourceBase {
    private static final Logger log = LoggerFactory.getLogger(InvoiceResource.class);
    private static final String ID_PARAM_NAME = "invoiceId";
    private static final String LOCALE_PARAM_NAME = "locale";
    private final InvoiceUserApi invoiceApi;
    private final InvoiceNotifier invoiceNotifier;
    private final TenantUserApi tenantApi;
    private final Locale defaultLocale;
    private static final Ordering<InvoicePaymentJson> INVOICE_PAYMENT_ORDERING = Ordering.from((Comparator)new Comparator<InvoicePaymentJson>(){

        @Override
        public int compare(InvoicePaymentJson o1, InvoicePaymentJson o2) {
            return o1.getTransactions().get(0).getEffectiveDate().compareTo((ReadableInstant)o2.getTransactions().get(0).getEffectiveDate());
        }
    });

    @Inject
    public InvoiceResource(AccountUserApi accountUserApi, InvoiceUserApi invoiceApi, PaymentApi paymentApi, InvoiceNotifier invoiceNotifier, Clock clock, JaxrsUriBuilder uriBuilder, TagUserApi tagUserApi, CustomFieldUserApi customFieldUserApi, AuditUserApi auditUserApi, TenantUserApi tenantApi, Context context) {
        super(uriBuilder, tagUserApi, customFieldUserApi, auditUserApi, accountUserApi, paymentApi, clock, context);
        this.invoiceApi = invoiceApi;
        this.invoiceNotifier = invoiceNotifier;
        this.tenantApi = tenantApi;
        this.defaultLocale = Locale.getDefault();
    }

    @TimedResource
    @GET
    @Path(value="/{invoiceId:\\w+-\\w+-\\w+-\\w+-\\w+}/")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve an invoice by id", response=InvoiceJson.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid invoice id supplied"), @ApiResponse(code=404, message="Invoice not found")})
    public Response getInvoice(@PathParam(value="invoiceId") String invoiceId, @QueryParam(value="withItems") @DefaultValue(value="false") boolean withItems, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @javax.ws.rs.core.Context HttpServletRequest request) throws InvoiceApiException {
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        Invoice invoice = this.invoiceApi.getInvoice(UUID.fromString(invoiceId), tenantContext);
        AccountAuditLogs accountAuditLogs = this.auditUserApi.getAccountAuditLogs(invoice.getAccountId(), auditMode.getLevel(), tenantContext);
        if (invoice == null) {
            throw new InvoiceApiException(ErrorCode.INVOICE_NOT_FOUND, new Object[]{invoiceId});
        }
        InvoiceJson json = new InvoiceJson(invoice, withItems, accountAuditLogs);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)json).build();
    }

    @TimedResource
    @GET
    @Path(value="/{invoiceNumber:[0-9]+}/")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve an invoice by number", response=InvoiceJson.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Invoice not found")})
    public Response getInvoiceByNumber(@PathParam(value="invoiceNumber") Integer invoiceNumber, @QueryParam(value="withItems") @DefaultValue(value="false") boolean withItems, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @javax.ws.rs.core.Context HttpServletRequest request) throws InvoiceApiException {
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        Invoice invoice = this.invoiceApi.getInvoiceByNumber(invoiceNumber, tenantContext);
        AccountAuditLogs accountAuditLogs = this.auditUserApi.getAccountAuditLogs(invoice.getAccountId(), auditMode.getLevel(), tenantContext);
        if (invoice == null) {
            throw new InvoiceApiException(ErrorCode.INVOICE_NOT_FOUND, new Object[]{invoiceNumber});
        }
        InvoiceJson json = new InvoiceJson(invoice, withItems, accountAuditLogs);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)json).build();
    }

    @TimedResource
    @GET
    @Path(value="/{invoiceId:\\w+-\\w+-\\w+-\\w+-\\w+}/html")
    @Produces(value={"text/html"})
    @ApiOperation(value="Render an invoice as HTML", response=String.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Invoice not found")})
    public Response getInvoiceAsHTML(@PathParam(value="invoiceId") String invoiceId, @javax.ws.rs.core.Context HttpServletRequest request) throws InvoiceApiException, IOException, AccountApiException {
        return Response.status((Response.Status)Response.Status.OK).entity((Object)this.invoiceApi.getInvoiceAsHTML(UUID.fromString(invoiceId), this.context.createContext((ServletRequest)request))).build();
    }

    @TimedResource
    @GET
    @Path(value="/pagination")
    @Produces(value={"application/json"})
    @ApiOperation(value="List invoices", response=InvoiceJson.class, responseContainer="List")
    @ApiResponses(value={})
    public Response getInvoices(@QueryParam(value="offset") @DefaultValue(value="0") Long offset, @QueryParam(value="limit") @DefaultValue(value="100") Long limit, final @QueryParam(value="withItems") @DefaultValue(value="false") Boolean withItems, final @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @javax.ws.rs.core.Context HttpServletRequest request) throws InvoiceApiException {
        final TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        Pagination invoices = this.invoiceApi.getInvoices(offset, limit, tenantContext);
        URI nextPageUri = this.uriBuilder.nextPage(InvoiceResource.class, "getInvoices", invoices.getNextOffset(), limit, (Map<String, String>)ImmutableMap.of((Object)"withItems", (Object)withItems.toString(), (Object)"audit", (Object)auditMode.getLevel().toString()));
        final AtomicReference accountsAuditLogs = new AtomicReference(new HashMap());
        return this.buildStreamingPaginationResponse(invoices, new Function<Invoice, InvoiceJson>(){

            public InvoiceJson apply(Invoice invoice) {
                if (((Map)accountsAuditLogs.get()).get(invoice.getAccountId()) == null) {
                    ((Map)accountsAuditLogs.get()).put(invoice.getAccountId(), InvoiceResource.this.auditUserApi.getAccountAuditLogs(invoice.getAccountId(), auditMode.getLevel(), tenantContext));
                }
                return new InvoiceJson(invoice, withItems, (AccountAuditLogs)((Map)accountsAuditLogs.get()).get(invoice.getAccountId()));
            }
        }, nextPageUri);
    }

    @TimedResource
    @GET
    @Path(value="/search/{searchKey:.*}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Search invoices", response=InvoiceJson.class, responseContainer="List")
    @ApiResponses(value={})
    public Response searchInvoices(@PathParam(value="searchKey") String searchKey, @QueryParam(value="offset") @DefaultValue(value="0") Long offset, @QueryParam(value="limit") @DefaultValue(value="100") Long limit, final @QueryParam(value="withItems") @DefaultValue(value="false") Boolean withItems, final @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @javax.ws.rs.core.Context HttpServletRequest request) throws SubscriptionApiException {
        final TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        Pagination invoices = this.invoiceApi.searchInvoices(searchKey, offset, limit, tenantContext);
        URI nextPageUri = this.uriBuilder.nextPage(InvoiceResource.class, "searchInvoices", invoices.getNextOffset(), limit, (Map<String, String>)ImmutableMap.of((Object)"searchKey", (Object)searchKey, (Object)"withItems", (Object)withItems.toString(), (Object)"audit", (Object)auditMode.getLevel().toString()));
        final AtomicReference accountsAuditLogs = new AtomicReference(new HashMap());
        return this.buildStreamingPaginationResponse(invoices, new Function<Invoice, InvoiceJson>(){

            public InvoiceJson apply(Invoice invoice) {
                if (((Map)accountsAuditLogs.get()).get(invoice.getAccountId()) == null) {
                    ((Map)accountsAuditLogs.get()).put(invoice.getAccountId(), InvoiceResource.this.auditUserApi.getAccountAuditLogs(invoice.getAccountId(), auditMode.getLevel(), tenantContext));
                }
                return new InvoiceJson(invoice, withItems, (AccountAuditLogs)((Map)accountsAuditLogs.get()).get(invoice.getAccountId()));
            }
        }, nextPageUri);
    }

    @TimedResource
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Trigger an invoice generation", response=InvoiceJson.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid account id or target datetime supplied")})
    public Response createFutureInvoice(@QueryParam(value="accountId") String accountId, @QueryParam(value="targetDate") String targetDate, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request, @javax.ws.rs.core.Context UriInfo uriInfo) throws AccountApiException, InvoiceApiException {
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        LocalDate inputDate = this.toLocalDate(UUID.fromString(accountId), targetDate, (TenantContext)callContext);
        try {
            Invoice generatedInvoice = this.invoiceApi.triggerInvoiceGeneration(UUID.fromString(accountId), inputDate, null, callContext);
            return this.uriBuilder.buildResponse(uriInfo, InvoiceResource.class, "getInvoice", generatedInvoice.getId());
        }
        catch (InvoiceApiException e) {
            if (e.getCode() == ErrorCode.INVOICE_NOTHING_TO_DO.getCode()) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            throw e;
        }
    }

    @TimedResource
    @POST
    @Path(value="/dryRun")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Generate a dryRun invoice", response=InvoiceJson.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid account id or target datetime supplied")})
    public Response generateDryRunInvoice(@Nullable InvoiceDryRunJson dryRunSubscriptionSpec, @QueryParam(value="accountId") String accountId, @Nullable @QueryParam(value="targetDate") String targetDate, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request, @javax.ws.rs.core.Context UriInfo uriInfo) throws AccountApiException, InvoiceApiException {
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        Object inputDate = dryRunSubscriptionSpec != null ? (DryRunType.UPCOMING_INVOICE.name().equals(dryRunSubscriptionSpec.getDryRunType()) ? null : (DryRunType.SUBSCRIPTION_ACTION.name().equals(dryRunSubscriptionSpec.getDryRunType()) && dryRunSubscriptionSpec.getEffectiveDate() != null ? dryRunSubscriptionSpec.getEffectiveDate() : this.toLocalDate(UUID.fromString(accountId), targetDate, (TenantContext)callContext))) : this.toLocalDate(UUID.fromString(accountId), targetDate, (TenantContext)callContext);
        if (dryRunSubscriptionSpec != null && dryRunSubscriptionSpec.getDryRunAction() != null) {
            if (SubscriptionEventType.START_BILLING.toString().equals(dryRunSubscriptionSpec.getDryRunAction())) {
                this.verifyNonNullOrEmpty(dryRunSubscriptionSpec.getProductName(), "DryRun subscription product category should be specified");
                this.verifyNonNullOrEmpty(dryRunSubscriptionSpec.getBillingPeriod(), "DryRun subscription billingPeriod should be specified");
                this.verifyNonNullOrEmpty(dryRunSubscriptionSpec.getProductCategory(), "DryRun subscription product category should be specified");
                if (dryRunSubscriptionSpec.getProductCategory().equals(ProductCategory.ADD_ON)) {
                    this.verifyNonNullOrEmpty(dryRunSubscriptionSpec.getBundleId(), "DryRun bundle ID should be specified");
                }
            } else if (SubscriptionEventType.CHANGE.toString().equals(dryRunSubscriptionSpec.getDryRunAction())) {
                this.verifyNonNullOrEmpty(dryRunSubscriptionSpec.getProductName(), "DryRun subscription product category should be specified");
                this.verifyNonNullOrEmpty(dryRunSubscriptionSpec.getBillingPeriod(), "DryRun subscription billingPeriod should be specified");
                this.verifyNonNullOrEmpty(dryRunSubscriptionSpec.getSubscriptionId(), "DryRun subscriptionID should be specified");
            } else if (SubscriptionEventType.STOP_BILLING.toString().equals(dryRunSubscriptionSpec.getDryRunAction())) {
                this.verifyNonNullOrEmpty(dryRunSubscriptionSpec.getSubscriptionId(), "DryRun subscriptionID should be specified");
            }
        }
        Account account = this.accountUserApi.getAccountById(UUID.fromString(accountId), (TenantContext)callContext);
        DefaultDryRunArguments dryRunArguments = new DefaultDryRunArguments(dryRunSubscriptionSpec, account.getTimeZone(), account.getCurrency(), this.clock);
        try {
            Invoice generatedInvoice = this.invoiceApi.triggerInvoiceGeneration(UUID.fromString(accountId), inputDate, (DryRunArguments)dryRunArguments, callContext);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)new InvoiceJson(generatedInvoice, true, null)).build();
        }
        catch (InvoiceApiException e) {
            if (e.getCode() == ErrorCode.INVOICE_NOTHING_TO_DO.getCode()) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            throw e;
        }
    }

    @TimedResource
    @DELETE
    @Path(value="/{invoiceId:\\w+-\\w+-\\w+-\\w+-\\w+}/{invoiceItemId:\\w+-\\w+-\\w+-\\w+-\\w+}/cba")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete a CBA item")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid account id, invoice id or invoice item id supplied"), @ApiResponse(code=404, message="Account or invoice not found")})
    public Response deleteCBA(@PathParam(value="invoiceId") String invoiceId, @PathParam(value="invoiceItemId") String invoiceItemId, @QueryParam(value="accountId") String accountId, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request) throws AccountApiException, InvoiceApiException {
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        Account account = this.accountUserApi.getAccountById(UUID.fromString(accountId), (TenantContext)callContext);
        this.invoiceApi.deleteCBA(account.getId(), UUID.fromString(invoiceId), UUID.fromString(invoiceItemId), callContext);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @TimedResource
    @POST
    @Path(value="/{invoiceId:\\w+-\\w+-\\w+-\\w+-\\w+}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Adjust an invoice item")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid account id, invoice id or invoice item id supplied"), @ApiResponse(code=404, message="Invoice not found")})
    public Response adjustInvoiceItem(InvoiceItemJson json, @PathParam(value="invoiceId") String invoiceId, @QueryParam(value="requestedDate") String requestedDateTimeString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request, @javax.ws.rs.core.Context UriInfo uriInfo) throws AccountApiException, InvoiceApiException {
        this.verifyNonNullOrEmpty(json, "InvoiceItemJson body should be specified");
        this.verifyNonNullOrEmpty(json.getAccountId(), "InvoiceItemJson accountId needs to be set", json.getInvoiceItemId(), "InvoiceItemJson invoiceItemId needs to be set");
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        UUID accountId = UUID.fromString(json.getAccountId());
        LocalDate requestedDate = this.toLocalDate(accountId, requestedDateTimeString, (TenantContext)callContext);
        InvoiceItem adjustmentItem = json.getAmount() == null ? this.invoiceApi.insertInvoiceItemAdjustment(accountId, UUID.fromString(invoiceId), UUID.fromString(json.getInvoiceItemId()), requestedDate, callContext) : this.invoiceApi.insertInvoiceItemAdjustment(accountId, UUID.fromString(invoiceId), UUID.fromString(json.getInvoiceItemId()), requestedDate, json.getAmount(), json.getCurrency(), callContext);
        return this.uriBuilder.buildResponse(uriInfo, InvoiceResource.class, "getInvoice", adjustmentItem.getInvoiceId());
    }

    @TimedResource
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/charges/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}")
    @ApiOperation(value="Create external charge(s)", response=InvoiceItemJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid account id supplied"), @ApiResponse(code=404, message="Account not found")})
    public Response createExternalCharges(Iterable<InvoiceItemJson> externalChargesJson, @PathParam(value="accountId") String accountId, @QueryParam(value="requestedDate") String requestedDateTimeString, @QueryParam(value="payInvoice") @DefaultValue(value="false") Boolean payInvoice, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context UriInfo uriInfo, @javax.ws.rs.core.Context HttpServletRequest request) throws AccountApiException, InvoiceApiException, PaymentApiException {
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        Account account = this.accountUserApi.getAccountById(UUID.fromString(accountId), (TenantContext)callContext);
        Iterable<InvoiceItemJson> sanitizedExternalChargesJson = this.cloneRefundItemsWithValidCurrency(account.getCurrency(), externalChargesJson);
        LocalDate requestedDate = this.toLocalDate(account, requestedDateTimeString, (TenantContext)callContext);
        Iterable externalCharges = Iterables.transform(sanitizedExternalChargesJson, (Function)new Function<InvoiceItemJson, InvoiceItem>(){

            public InvoiceItem apply(InvoiceItemJson invoiceItemJson) {
                return invoiceItemJson.toInvoiceItem();
            }
        });
        List createdExternalCharges = this.invoiceApi.insertExternalCharges(account.getId(), requestedDate, externalCharges, callContext);
        if (payInvoice.booleanValue()) {
            HashSet<UUID> paidInvoices = new HashSet<UUID>();
            for (InvoiceItem externalCharge : createdExternalCharges) {
                if (paidInvoices.contains(externalCharge.getInvoiceId())) continue;
                paidInvoices.add(externalCharge.getInvoiceId());
                Invoice invoice = this.invoiceApi.getInvoice(externalCharge.getInvoiceId(), (TenantContext)callContext);
                this.createPurchaseForInvoice(account, invoice.getId(), invoice.getBalance(), account.getPaymentMethodId(), false, pluginProperties, callContext);
            }
        }
        List createdExternalChargesJson = Lists.transform((List)createdExternalCharges, (Function)new Function<InvoiceItem, InvoiceItemJson>(){

            public InvoiceItemJson apply(InvoiceItem input) {
                return new InvoiceItemJson(input);
            }
        });
        return Response.status((Response.Status)Response.Status.OK).entity((Object)createdExternalChargesJson).build();
    }

    private Iterable<InvoiceItemJson> cloneRefundItemsWithValidCurrency(final Currency accountCurrency, Iterable<InvoiceItemJson> inputItems) throws InvoiceApiException {
        try {
            return Iterables.transform(inputItems, (Function)new Function<InvoiceItemJson, InvoiceItemJson>(){

                public InvoiceItemJson apply(InvoiceItemJson input) {
                    if (input.getCurrency() != null) {
                        if (!input.getCurrency().equals((Object)accountCurrency)) {
                            throw new IllegalArgumentException(input.getCurrency().toString());
                        }
                        return input;
                    }
                    return new InvoiceItemJson(null, input.getInvoiceId(), null, input.getAccountId(), input.getBundleId(), input.getSubscriptionId(), input.getPlanName(), input.getPhaseName(), input.getUsageName(), input.getItemType(), input.getDescription(), input.getStartDate(), input.getEndDate(), input.getAmount(), accountCurrency, null);
                }
            });
        }
        catch (IllegalArgumentException e) {
            throw new InvoiceApiException(ErrorCode.CURRENCY_INVALID, new Object[]{accountCurrency, e.getMessage()});
        }
    }

    @TimedResource
    @GET
    @Path(value="/{invoiceId:\\w+-\\w+-\\w+-\\w+-\\w+}/payments")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve payments associated with an invoice", response=InvoicePaymentJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid invoice id supplied"), @ApiResponse(code=404, message="Invoice not found")})
    public Response getPayments(@PathParam(value="invoiceId") String invoiceId, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @QueryParam(value="withPluginInfo") @DefaultValue(value="false") Boolean withPluginInfo, @javax.ws.rs.core.Context HttpServletRequest request) throws PaymentApiException, InvoiceApiException {
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        final Invoice invoice = this.invoiceApi.getInvoice(UUID.fromString(invoiceId), tenantContext);
        ImmutableSet invoicePaymentIds = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)invoice.getPayments(), (Function)new Function<InvoicePayment, UUID>(){

            public UUID apply(InvoicePayment input) {
                return input.getPaymentId();
            }
        }));
        if (invoicePaymentIds.isEmpty()) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)ImmutableList.of()).build();
        }
        ArrayList<Payment> payments = new ArrayList<Payment>();
        for (UUID paymentId : invoicePaymentIds) {
            Payment payment = this.paymentApi.getPayment(paymentId, withPluginInfo.booleanValue(), (Iterable)ImmutableList.of(), tenantContext);
            payments.add(payment);
        }
        List result = INVOICE_PAYMENT_ORDERING.sortedCopy(Iterables.transform(payments, (Function)new Function<Payment, InvoicePaymentJson>(){

            public InvoicePaymentJson apply(Payment input) {
                return new InvoicePaymentJson(input, invoice.getId(), null);
            }
        }));
        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
    }

    @TimedResource
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/{invoiceId:\\w+-\\w+-\\w+-\\w+-\\w+}/payments")
    @ApiOperation(value="Trigger a payment for invoice")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid account id or invoice id supplied"), @ApiResponse(code=404, message="Account not found")})
    public Response createInstantPayment(InvoicePaymentJson payment, @QueryParam(value="externalPayment") @DefaultValue(value="false") Boolean externalPayment, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request, @javax.ws.rs.core.Context UriInfo uriInfo) throws AccountApiException, PaymentApiException {
        this.verifyNonNullOrEmpty(payment, "InvoicePaymentJson body should be specified");
        this.verifyNonNullOrEmpty(payment.getAccountId(), "InvoicePaymentJson accountId needs to be set", payment.getTargetInvoiceId(), "InvoicePaymentJson targetInvoiceId needs to be set", payment.getPurchasedAmount(), "InvoicePaymentJson purchasedAmount needs to be set");
        Preconditions.checkArgument((externalPayment == false || payment.getPaymentMethodId() == null ? 1 : 0) != 0, (Object)"InvoicePaymentJson should not contain a paymwentMethodId when this is an external payment");
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        Account account = this.accountUserApi.getAccountById(UUID.fromString(payment.getAccountId()), (TenantContext)callContext);
        UUID paymentMethodId = externalPayment != false ? null : (payment.getPaymentMethodId() != null ? UUID.fromString(payment.getPaymentMethodId()) : account.getPaymentMethodId());
        UUID invoiceId = UUID.fromString(payment.getTargetInvoiceId());
        Payment result = this.createPurchaseForInvoice(account, invoiceId, payment.getPurchasedAmount(), paymentMethodId, externalPayment, pluginProperties, callContext);
        return this.uriBuilder.buildResponse(uriInfo, InvoicePaymentResource.class, "getInvoicePayment", result.getId());
    }

    @TimedResource
    @POST
    @Path(value="/{invoiceId:\\w+-\\w+-\\w+-\\w+-\\w+}/emailNotifications")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Trigger an email notification for invoice")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid invoice id supplied"), @ApiResponse(code=404, message="Account or invoice not found")})
    public Response triggerEmailNotificationForInvoice(@PathParam(value="invoiceId") String invoiceId, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request) throws InvoiceApiException, AccountApiException {
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        Invoice invoice = this.invoiceApi.getInvoice(UUID.fromString(invoiceId), (TenantContext)callContext);
        if (invoice == null) {
            throw new InvoiceApiException(ErrorCode.INVOICE_NOT_FOUND, new Object[]{invoiceId});
        }
        Account account = this.accountUserApi.getAccountById(invoice.getAccountId(), (TenantContext)callContext);
        this.invoiceNotifier.notify(account, invoice, (TenantContext)callContext);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @TimedResource
    @GET
    @Path(value="/translation/{locale:.*}/")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Retrieves the invoice translation for the tenant", response=String.class, hidden=true)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid locale supplied"), @ApiResponse(code=404, message="Translation not found")})
    public Response getInvoiceTranslation(@PathParam(value="locale") String localeStr, @javax.ws.rs.core.Context HttpServletRequest request) throws InvoiceApiException, TenantApiException {
        return this.getTemplateResource(localeStr, TenantKV.TenantKey.INVOICE_TRANSLATION_, request);
    }

    @TimedResource
    @POST
    @Produces(value={"text/plain"})
    @Consumes(value={"text/plain"})
    @Path(value="/translation/{locale:.*}/")
    @ApiOperation(value="Upload the invoice translation for the tenant")
    @ApiResponses(value={})
    public Response uploadInvoiceTranslation(String invoiceTranslation, @PathParam(value="locale") String localeStr, @QueryParam(value="deleteIfExists") @DefaultValue(value="false") boolean deleteIfExists, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request, @javax.ws.rs.core.Context UriInfo uriInfo) throws Exception {
        return this.uploadTemplateResource(invoiceTranslation, localeStr, deleteIfExists, TenantKV.TenantKey.INVOICE_TRANSLATION_, "getInvoiceTranslation", createdBy, reason, comment, request, uriInfo);
    }

    @TimedResource
    @GET
    @Path(value="/catalogTranslation/{locale:.*}/")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Retrieves the catalog translation for the tenant", response=String.class, hidden=true)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid locale supplied"), @ApiResponse(code=404, message="Template not found")})
    public Response getCatalogTranslation(@PathParam(value="locale") String localeStr, @javax.ws.rs.core.Context HttpServletRequest request) throws InvoiceApiException, TenantApiException {
        return this.getTemplateResource(localeStr, TenantKV.TenantKey.CATALOG_TRANSLATION_, request);
    }

    @TimedResource
    @POST
    @Produces(value={"text/plain"})
    @Consumes(value={"text/plain"})
    @Path(value="/catalogTranslation/{locale:.*}/")
    @ApiOperation(value="Upload the catalog translation for the tenant")
    @ApiResponses(value={})
    public Response uploadCatalogTranslation(String catalogTranslation, @PathParam(value="locale") String localeStr, @QueryParam(value="deleteIfExists") @DefaultValue(value="false") boolean deleteIfExists, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request, @javax.ws.rs.core.Context UriInfo uriInfo) throws Exception {
        return this.uploadTemplateResource(catalogTranslation, localeStr, deleteIfExists, TenantKV.TenantKey.CATALOG_TRANSLATION_, "getCatalogTranslation", createdBy, reason, comment, request, uriInfo);
    }

    @TimedResource
    @GET
    @Path(value="/template")
    @Produces(value={"text/html"})
    @ApiOperation(value="Retrieves the invoice template for the tenant", response=String.class, hidden=true)
    @ApiResponses(value={@ApiResponse(code=404, message="Template not found")})
    public Response getInvoiceTemplate(@javax.ws.rs.core.Context HttpServletRequest request) throws InvoiceApiException, TenantApiException {
        return this.getTemplateResource(null, TenantKV.TenantKey.INVOICE_TEMPLATE, request);
    }

    @TimedResource
    @POST
    @Produces(value={"text/html"})
    @Consumes(value={"text/html"})
    @Path(value="/template")
    @ApiOperation(value="Upload the invoice template for the tenant")
    @ApiResponses(value={})
    public Response uploadInvoiceTemplate(String catalogTranslation, @QueryParam(value="deleteIfExists") @DefaultValue(value="false") boolean deleteIfExists, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request, @javax.ws.rs.core.Context UriInfo uriInfo) throws Exception {
        return this.uploadTemplateResource(catalogTranslation, null, deleteIfExists, TenantKV.TenantKey.INVOICE_TEMPLATE, "getInvoiceTemplate", createdBy, reason, comment, request, uriInfo);
    }

    @TimedResource
    @GET
    @Path(value="/manualPayTemplate")
    @Produces(value={"text/html"})
    @ApiOperation(value="Retrieves the manualPay invoice template for the tenant", response=String.class, hidden=true)
    @ApiResponses(value={@ApiResponse(code=404, message="Template not found")})
    public Response getInvoiceMPTemplate(@PathParam(value="locale") String localeStr, @javax.ws.rs.core.Context HttpServletRequest request) throws InvoiceApiException, TenantApiException {
        return this.getTemplateResource(null, TenantKV.TenantKey.INVOICE_MP_TEMPLATE, request);
    }

    @TimedResource
    @POST
    @Produces(value={"text/html"})
    @Consumes(value={"text/html"})
    @Path(value="/manualPayTemplate")
    @ApiOperation(value="Upload the manualPay invoice template for the tenant")
    @ApiResponses(value={})
    public Response uploadInvoiceMPTemplate(String catalogTranslation, @QueryParam(value="deleteIfExists") @DefaultValue(value="false") boolean deleteIfExists, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request, @javax.ws.rs.core.Context UriInfo uriInfo) throws Exception {
        return this.uploadTemplateResource(catalogTranslation, null, deleteIfExists, TenantKV.TenantKey.INVOICE_MP_TEMPLATE, "getInvoiceMPTemplate", createdBy, reason, comment, request, uriInfo);
    }

    private Response uploadTemplateResource(String templateResource, @Nullable String localeStr, boolean deleteIfExists, TenantKV.TenantKey tenantKey, String getMethodStr, String createdBy, String reason, String comment, HttpServletRequest request, UriInfo uriInfo) throws Exception {
        String tenantKeyStr;
        if (localeStr != null) {
            ByteArrayInputStream stream = new ByteArrayInputStream(templateResource.getBytes());
            new PropertyResourceBundle(stream);
            Locale locale = localeStr != null ? LocaleUtils.toLocale((String)localeStr) : this.defaultLocale;
            tenantKeyStr = LocaleUtils.localeString((Locale)locale, (String)tenantKey.toString());
        } else {
            tenantKeyStr = tenantKey.toString();
        }
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        if (!this.tenantApi.getTenantValuesForKey(tenantKeyStr, (TenantContext)callContext).isEmpty()) {
            if (deleteIfExists) {
                this.tenantApi.deleteTenantKey(tenantKeyStr, callContext);
            } else {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
        }
        this.tenantApi.addTenantKeyValue(tenantKeyStr, templateResource, callContext);
        return this.uriBuilder.buildResponse(uriInfo, InvoiceResource.class, getMethodStr, (Object)localeStr);
    }

    private Response getTemplateResource(@Nullable String localeStr, TenantKV.TenantKey tenantKey, HttpServletRequest request) throws InvoiceApiException, TenantApiException {
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        String tenantKeyStr = localeStr != null ? LocaleUtils.localeString((Locale)LocaleUtils.toLocale((String)localeStr), (String)tenantKey.toString()) : tenantKey.toString();
        List result = this.tenantApi.getTenantValuesForKey(tenantKeyStr, tenantContext);
        return result.isEmpty() ? Response.status((Response.Status)Response.Status.NOT_FOUND).build() : Response.status((Response.Status)Response.Status.OK).entity(result.get(0)).build();
    }

    @TimedResource
    @GET
    @Path(value="/{invoiceId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve invoice custom fields", response=CustomFieldJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid invoice id supplied")})
    public Response getCustomFields(@PathParam(value="invoiceId") String id, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @javax.ws.rs.core.Context HttpServletRequest request) {
        return super.getCustomFields(UUID.fromString(id), auditMode, this.context.createContext((ServletRequest)request));
    }

    @TimedResource
    @POST
    @Path(value="/{invoiceId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Add custom fields to invoice")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid invoice id supplied")})
    public Response createCustomFields(@PathParam(value="invoiceId") String id, List<CustomFieldJson> customFields, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request, @javax.ws.rs.core.Context UriInfo uriInfo) throws CustomFieldApiException {
        return super.createCustomFields(UUID.fromString(id), customFields, this.context.createContext(createdBy, reason, comment, (ServletRequest)request), uriInfo);
    }

    @TimedResource
    @DELETE
    @Path(value="/{invoiceId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Remove custom fields from invoice")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid invoice id supplied")})
    public Response deleteCustomFields(@PathParam(value="invoiceId") String id, @QueryParam(value="customFieldList") String customFieldList, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request) throws CustomFieldApiException {
        return super.deleteCustomFields(UUID.fromString(id), customFieldList, this.context.createContext(createdBy, reason, comment, (ServletRequest)request));
    }

    @TimedResource
    @GET
    @Path(value="/{invoiceId:\\w+-\\w+-\\w+-\\w+-\\w+}/tags")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve invoice tags", response=TagJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid invoice id supplied"), @ApiResponse(code=404, message="Invoice not found")})
    public Response getTags(@PathParam(value="invoiceId") String invoiceIdString, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @QueryParam(value="includedDeleted") @DefaultValue(value="false") Boolean includedDeleted, @javax.ws.rs.core.Context HttpServletRequest request) throws TagDefinitionApiException, InvoiceApiException {
        UUID invoiceId = UUID.fromString(invoiceIdString);
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        Invoice invoice = this.invoiceApi.getInvoice(invoiceId, tenantContext);
        return super.getTags(invoice.getAccountId(), invoiceId, auditMode, includedDeleted, tenantContext);
    }

    @TimedResource
    @POST
    @Path(value="/{invoiceId:\\w+-\\w+-\\w+-\\w+-\\w+}/tags")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Add tags to invoice")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid invoice id supplied")})
    public Response createTags(@PathParam(value="invoiceId") String id, @QueryParam(value="tagList") String tagList, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context UriInfo uriInfo, @javax.ws.rs.core.Context HttpServletRequest request) throws TagApiException {
        return super.createTags(UUID.fromString(id), tagList, uriInfo, this.context.createContext(createdBy, reason, comment, (ServletRequest)request));
    }

    @TimedResource
    @DELETE
    @Path(value="/{invoiceId:\\w+-\\w+-\\w+-\\w+-\\w+}/tags")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Remove tags from invoice")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid invoice id supplied")})
    public Response deleteTags(@PathParam(value="invoiceId") String id, @QueryParam(value="tagList") String tagList, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request) throws TagApiException {
        return super.deleteTags(UUID.fromString(id), tagList, this.context.createContext(createdBy, reason, comment, (ServletRequest)request));
    }

    @Override
    protected ObjectType getObjectType() {
        return ObjectType.INVOICE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultDryRunArguments
    implements DryRunArguments {
        private final DryRunType dryRunType;
        private final SubscriptionEventType action;
        private final UUID subscriptionId;
        private final DateTime effectiveDate;
        private final PlanPhaseSpecifier specifier;
        private final UUID bundleId;
        private final BillingActionPolicy billingPolicy;
        private final List<PlanPhasePriceOverride> overrides;

        public DefaultDryRunArguments(InvoiceDryRunJson input, DateTimeZone accountTimeZone, final Currency currency, Clock clock) {
            if (input == null) {
                this.dryRunType = DryRunType.TARGET_DATE;
                this.action = null;
                this.subscriptionId = null;
                this.effectiveDate = null;
                this.specifier = null;
                this.bundleId = null;
                this.billingPolicy = null;
                this.overrides = null;
            } else {
                PlanPhaseSpecifier planPhaseSpecifier;
                this.dryRunType = input.getDryRunType() != null ? DryRunType.valueOf((String)input.getDryRunType()) : DryRunType.TARGET_DATE;
                this.action = input.getDryRunAction() != null ? SubscriptionEventType.valueOf((String)input.getDryRunAction()) : null;
                this.subscriptionId = input.getSubscriptionId() != null ? UUID.fromString(input.getSubscriptionId()) : null;
                this.bundleId = input.getBundleId() != null ? UUID.fromString(input.getBundleId()) : null;
                this.effectiveDate = input.getEffectiveDate() != null ? ClockUtil.computeDateTimeWithUTCReferenceTime((LocalDate)input.getEffectiveDate(), (LocalTime)clock.getUTCNow().toLocalTime(), (DateTimeZone)accountTimeZone, (Clock)clock) : null;
                BillingActionPolicy billingActionPolicy = this.billingPolicy = input.getBillingPolicy() != null ? BillingActionPolicy.valueOf((String)input.getBillingPolicy()) : null;
                this.specifier = planPhaseSpecifier = input.getProductName() != null && input.getProductCategory() != null && input.getBillingPeriod() != null ? new PlanPhaseSpecifier(input.getProductName(), ProductCategory.valueOf((String)input.getProductCategory()), BillingPeriod.valueOf((String)input.getBillingPeriod()), input.getPriceListName(), input.getPhaseType() != null ? PhaseType.valueOf((String)input.getPhaseType()) : null) : null;
                this.overrides = input.getPriceOverrides() != null ? ImmutableList.copyOf((Iterable)Iterables.transform(input.getPriceOverrides(), (Function)new Function<PhasePriceOverrideJson, PlanPhasePriceOverride>(){

                    @Nullable
                    public PlanPhasePriceOverride apply(@Nullable PhasePriceOverrideJson input) {
                        if (input.getPhaseName() != null) {
                            return new DefaultPlanPhasePriceOverride(input.getPhaseName(), currency, input.getFixedPrice(), input.getRecurringPrice());
                        }
                        return new DefaultPlanPhasePriceOverride(planPhaseSpecifier, currency, input.getFixedPrice(), input.getRecurringPrice());
                    }
                })) : ImmutableList.of();
            }
        }

        public DryRunType getDryRunType() {
            return this.dryRunType;
        }

        public PlanPhaseSpecifier getPlanPhaseSpecifier() {
            return this.specifier;
        }

        public SubscriptionEventType getAction() {
            return this.action;
        }

        public UUID getSubscriptionId() {
            return this.subscriptionId;
        }

        public DateTime getEffectiveDate() {
            return this.effectiveDate;
        }

        public UUID getBundleId() {
            return this.bundleId;
        }

        public BillingActionPolicy getBillingActionPolicy() {
            return this.billingPolicy;
        }

        public List<PlanPhasePriceOverride> getPlanPhasePriceOverrides() {
            return this.overrides;
        }
    }
}

