/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.invoice.api.InvoicePayment;
import org.killbill.billing.invoice.api.InvoicePaymentApi;
import org.killbill.billing.invoice.api.InvoicePaymentType;
import org.killbill.billing.jaxrs.json.CustomFieldJson;
import org.killbill.billing.jaxrs.json.InvoiceItemJson;
import org.killbill.billing.jaxrs.json.InvoicePaymentJson;
import org.killbill.billing.jaxrs.json.InvoicePaymentTransactionJson;
import org.killbill.billing.jaxrs.json.TagJson;
import org.killbill.billing.jaxrs.resources.AuditMode;
import org.killbill.billing.jaxrs.resources.JaxRsResourceBase;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.payment.api.Payment;
import org.killbill.billing.payment.api.PaymentApi;
import org.killbill.billing.payment.api.PaymentApiException;
import org.killbill.billing.payment.api.PluginProperty;
import org.killbill.billing.util.UUIDs;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldApiException;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.TagApiException;
import org.killbill.billing.util.api.TagDefinitionApiException;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.audit.AccountAuditLogs;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.clock.Clock;
import org.killbill.commons.metrics.TimedResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/1.0/kb/invoicePayments")
@Api(value="/1.0/kb/invoicePayments", description="Operations on invoice payments")
public class InvoicePaymentResource
extends JaxRsResourceBase {
    private static final String ID_PARAM_NAME = "paymentId";
    private final InvoicePaymentApi invoicePaymentApi;

    @Inject
    public InvoicePaymentResource(AccountUserApi accountUserApi, PaymentApi paymentApi, JaxrsUriBuilder uriBuilder, TagUserApi tagUserApi, CustomFieldUserApi customFieldUserApi, AuditUserApi auditUserApi, InvoicePaymentApi invoicePaymentApi, Clock clock, org.killbill.billing.jaxrs.util.Context context) {
        super(uriBuilder, tagUserApi, customFieldUserApi, auditUserApi, accountUserApi, paymentApi, clock, context);
        this.invoicePaymentApi = invoicePaymentApi;
    }

    @TimedResource
    @GET
    @Path(value="/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}/")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve a payment by id", response=InvoicePaymentJson.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid payment id supplied"), @ApiResponse(code=404, message="Payment not found")})
    public Response getInvoicePayment(@PathParam(value="paymentId") String paymentIdStr, @QueryParam(value="withPluginInfo") @DefaultValue(value="false") Boolean withPluginInfo, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) throws PaymentApiException {
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        UUID paymentIdId = UUID.fromString(paymentIdStr);
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        Payment payment = this.paymentApi.getPayment(paymentIdId, withPluginInfo.booleanValue(), pluginProperties, tenantContext);
        AccountAuditLogs accountAuditLogs = this.auditUserApi.getAccountAuditLogs(payment.getAccountId(), auditMode.getLevel(), tenantContext);
        List invoicePayments = this.invoicePaymentApi.getInvoicePayments(paymentIdId, tenantContext);
        InvoicePayment invoicePayment = (InvoicePayment)Iterables.tryFind((Iterable)invoicePayments, (Predicate)new Predicate<InvoicePayment>(){

            public boolean apply(InvoicePayment input) {
                return input.getType() == InvoicePaymentType.ATTEMPT;
            }
        }).orNull();
        UUID invoiceId = invoicePayment != null ? invoicePayment.getInvoiceId() : null;
        InvoicePaymentJson result = new InvoicePaymentJson(payment, invoiceId, accountAuditLogs);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
    }

    @TimedResource
    @POST
    @Path(value="/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}/refunds")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Refund a payment, and adjust the invoice if needed")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid payment id supplied"), @ApiResponse(code=404, message="Account or payment not found")})
    public Response createRefundWithAdjustments(InvoicePaymentTransactionJson json, @PathParam(value="paymentId") String paymentId, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws PaymentApiException, AccountApiException {
        Iterable<PluginProperty> pluginProperties;
        String transactionExternalKey;
        this.verifyNonNullOrEmpty(json, "InvoicePaymentTransactionJson body should be specified");
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        UUID paymentUuid = UUID.fromString(paymentId);
        Payment payment = this.paymentApi.getPayment(paymentUuid, false, (Iterable)ImmutableList.of(), (TenantContext)callContext);
        Account account = this.accountUserApi.getAccountById(payment.getAccountId(), (TenantContext)callContext);
        String string = transactionExternalKey = json.getTransactionExternalKey() != null ? json.getTransactionExternalKey() : UUIDs.randomUUID().toString();
        if (json.isAdjusted() != null && json.isAdjusted().booleanValue()) {
            if (json.getAdjustments() != null && json.getAdjustments().size() > 0) {
                HashMap<UUID, BigDecimal> adjustments = new HashMap<UUID, BigDecimal>();
                for (InvoiceItemJson item : json.getAdjustments()) {
                    adjustments.put(UUID.fromString(item.getInvoiceItemId()), item.getAmount());
                }
                pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty("IPCD_REFUND_WITH_ADJUSTMENTS", (Object)"true", Boolean.valueOf(false)), new PluginProperty("IPCD_REFUND_IDS_AMOUNTS", adjustments, Boolean.valueOf(false)));
            } else {
                pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty("IPCD_REFUND_WITH_ADJUSTMENTS", (Object)"true", Boolean.valueOf(false)));
            }
        } else {
            pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        }
        Payment result = this.paymentApi.createRefundWithPaymentControl(account, payment.getId(), json.getAmount(), account.getCurrency(), transactionExternalKey, pluginProperties, this.createInvoicePaymentControlPluginApiPaymentOptions(false), callContext);
        return this.uriBuilder.buildResponse(InvoicePaymentResource.class, "getInvoicePayment", result.getId(), uriInfo.getBaseUri().toString());
    }

    @TimedResource
    @POST
    @Path(value="/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}/chargebacks")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Record a chargeback")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid payment id supplied"), @ApiResponse(code=404, message="Account or payment not found")})
    public Response createChargeback(InvoicePaymentTransactionJson json, @PathParam(value="paymentId") String paymentId, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws PaymentApiException, AccountApiException {
        this.verifyNonNullOrEmpty(json, "InvoicePaymentTransactionJson body should be specified");
        this.verifyNonNullOrEmpty(json.getAmount(), "InvoicePaymentTransactionJson amount needs to be set");
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        UUID paymentUuid = UUID.fromString(paymentId);
        Payment payment = this.paymentApi.getPayment(paymentUuid, false, (Iterable)ImmutableList.of(), (TenantContext)callContext);
        Account account = this.accountUserApi.getAccountById(payment.getAccountId(), (TenantContext)callContext);
        String transactionExternalKey = json.getTransactionExternalKey() != null ? json.getTransactionExternalKey() : UUIDs.randomUUID().toString();
        Payment result = this.paymentApi.createChargebackWithPaymentControl(account, payment.getId(), json.getAmount(), account.getCurrency(), transactionExternalKey, this.createInvoicePaymentControlPluginApiPaymentOptions(false), callContext);
        return this.uriBuilder.buildResponse(uriInfo, InvoicePaymentResource.class, "getInvoicePayment", result.getId());
    }

    @TimedResource
    @GET
    @Path(value="/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve payment custom fields", response=CustomFieldJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid payment id supplied")})
    public Response getCustomFields(@PathParam(value="paymentId") String id, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) {
        return super.getCustomFields(UUID.fromString(id), auditMode, this.context.createContext((ServletRequest)request));
    }

    @TimedResource
    @POST
    @Path(value="/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Add custom fields to payment")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid payment id supplied")})
    public Response createCustomFields(@PathParam(value="paymentId") String id, List<CustomFieldJson> customFields, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request, @Context UriInfo uriInfo) throws CustomFieldApiException {
        return super.createCustomFields(UUID.fromString(id), customFields, this.context.createContext(createdBy, reason, comment, (ServletRequest)request), uriInfo);
    }

    @TimedResource
    @DELETE
    @Path(value="/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Remove custom fields from payment")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid payment id supplied")})
    public Response deleteCustomFields(@PathParam(value="paymentId") String id, @QueryParam(value="customFieldList") String customFieldList, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) throws CustomFieldApiException {
        return super.deleteCustomFields(UUID.fromString(id), customFieldList, this.context.createContext(createdBy, reason, comment, (ServletRequest)request));
    }

    @TimedResource
    @GET
    @Path(value="/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}/tags")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve payment tags", response=TagJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid payment id supplied"), @ApiResponse(code=404, message="Payment not found")})
    public Response getTags(@PathParam(value="paymentId") String paymentIdString, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @QueryParam(value="includedDeleted") @DefaultValue(value="false") Boolean includedDeleted, @Context HttpServletRequest request) throws TagDefinitionApiException, PaymentApiException {
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        UUID paymentId = UUID.fromString(paymentIdString);
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        Payment payment = this.paymentApi.getPayment(paymentId, false, pluginProperties, tenantContext);
        return super.getTags(payment.getAccountId(), paymentId, auditMode, includedDeleted, tenantContext);
    }

    @TimedResource
    @POST
    @Path(value="/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}/tags")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Add tags to payment")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid payment id supplied")})
    public Response createTags(@PathParam(value="paymentId") String id, @QueryParam(value="tagList") String tagList, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws TagApiException {
        return super.createTags(UUID.fromString(id), tagList, uriInfo, this.context.createContext(createdBy, reason, comment, (ServletRequest)request));
    }

    @TimedResource
    @DELETE
    @Path(value="/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}/tags")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Remove tags from payment")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid payment id supplied")})
    public Response deleteTags(@PathParam(value="paymentId") String id, @QueryParam(value="tagList") String tagList, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) throws TagApiException {
        return super.deleteTags(UUID.fromString(id), tagList, this.context.createContext(createdBy, reason, comment, (ServletRequest)request));
    }

    @Override
    protected ObjectType getObjectType() {
        return ObjectType.PAYMENT;
    }
}

