/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.jaxrs.json.AccountJson;
import org.killbill.billing.jaxrs.json.PaymentMethodJson;
import org.killbill.billing.jaxrs.resources.JaxRsResourceBase;
import org.killbill.billing.jaxrs.util.Context;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.payment.api.Payment;
import org.killbill.billing.payment.api.PaymentApi;
import org.killbill.billing.payment.api.PaymentApiException;
import org.killbill.billing.payment.api.PaymentMethod;
import org.killbill.billing.payment.api.PluginProperty;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.clock.Clock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ComboPaymentResource
extends JaxRsResourceBase {
    @Inject
    public ComboPaymentResource(JaxrsUriBuilder uriBuilder, TagUserApi tagUserApi, CustomFieldUserApi customFieldUserApi, AuditUserApi auditUserApi, AccountUserApi accountUserApi, PaymentApi paymentApi, Clock clock, Context context) {
        super(uriBuilder, tagUserApi, customFieldUserApi, auditUserApi, accountUserApi, paymentApi, clock, context);
    }

    protected Account getOrCreateAccount(AccountJson accountJson, CallContext callContext) throws AccountApiException {
        if (accountJson.getAccountId() != null) {
            return this.accountUserApi.getAccountById(UUID.fromString(accountJson.getAccountId()), (TenantContext)callContext);
        }
        if (accountJson.getExternalKey() != null) {
            try {
                return this.accountUserApi.getAccountByKey(accountJson.getExternalKey(), (TenantContext)callContext);
            }
            catch (AccountApiException accountApiException) {
                // empty catch block
            }
        }
        return this.accountUserApi.createAccount(accountJson.toAccountData(), callContext);
    }

    protected UUID getOrCreatePaymentMethod(Account account, final PaymentMethodJson paymentMethodJson, Iterable<PluginProperty> pluginProperties, CallContext callContext) throws PaymentApiException {
        PaymentMethod match;
        List accountPaymentMethods = this.paymentApi.getAccountPaymentMethods(account.getId(), false, (Iterable)ImmutableList.of(), (TenantContext)callContext);
        if (paymentMethodJson.getPaymentMethodId() != null) {
            final UUID match2 = UUID.fromString(paymentMethodJson.getPaymentMethodId());
            if (Iterables.any((Iterable)accountPaymentMethods, (Predicate)new Predicate<PaymentMethod>(){

                public boolean apply(PaymentMethod input) {
                    return input.getId().equals(match2);
                }
            })) {
                return match2;
            }
            throw new PaymentApiException(ErrorCode.PAYMENT_NO_SUCH_PAYMENT_METHOD, new Object[]{match2});
        }
        if (paymentMethodJson.getExternalKey() != null && (match = (PaymentMethod)Iterables.tryFind((Iterable)accountPaymentMethods, (Predicate)new Predicate<PaymentMethod>(){

            public boolean apply(PaymentMethod input) {
                return input.getExternalKey().equals(paymentMethodJson.getExternalKey());
            }
        }).orNull()) != null) {
            return match.getId();
        }
        boolean isDefault = accountPaymentMethods.isEmpty();
        PaymentMethod paymentData = paymentMethodJson.toPaymentMethod(account.getId().toString());
        return this.paymentApi.addPaymentMethod(account, paymentMethodJson.getExternalKey(), paymentMethodJson.getPluginName(), isDefault, paymentData.getPluginDetail(), pluginProperties, callContext);
    }

    protected Payment getPaymentByIdOrKey(@Nullable String paymentIdStr, @Nullable String externalKey, Iterable<PluginProperty> pluginProperties, TenantContext tenantContext) throws PaymentApiException {
        Preconditions.checkArgument((paymentIdStr != null || externalKey != null ? 1 : 0) != 0, (Object)"Need to set either paymentId or payment externalKey");
        if (paymentIdStr != null) {
            UUID paymentId = UUID.fromString(paymentIdStr);
            return this.paymentApi.getPayment(paymentId, false, pluginProperties, tenantContext);
        }
        return this.paymentApi.getPaymentByExternalKey(externalKey, false, pluginProperties, tenantContext);
    }
}

