/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiResponses;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.VersionedCatalog;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.CatalogUserApi;
import org.killbill.billing.catalog.api.Listing;
import org.killbill.billing.catalog.api.StaticCatalog;
import org.killbill.billing.jaxrs.json.CatalogJsonSimple;
import org.killbill.billing.jaxrs.json.PlanDetailJson;
import org.killbill.billing.jaxrs.resources.JaxRsResourceBase;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.payment.api.PaymentApi;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.clock.Clock;
import org.killbill.commons.metrics.TimedResource;
import org.killbill.xmlloader.XMLLoader;
import org.killbill.xmlloader.XMLWriter;

@Singleton
@Path(value="/1.0/kb/catalog")
@Api(value="/1.0/kb/catalog", description="Catalog information")
public class CatalogResource
extends JaxRsResourceBase {
    private final CatalogUserApi catalogUserApi;
    private static final String catalogName = "unused";

    @Inject
    public CatalogResource(JaxrsUriBuilder uriBuilder, TagUserApi tagUserApi, CustomFieldUserApi customFieldUserApi, AuditUserApi auditUserApi, AccountUserApi accountUserApi, PaymentApi paymentApi, CatalogUserApi catalogUserApi, Clock clock, org.killbill.billing.jaxrs.util.Context context) {
        super(uriBuilder, tagUserApi, customFieldUserApi, auditUserApi, accountUserApi, paymentApi, clock, context);
        this.catalogUserApi = catalogUserApi;
    }

    @TimedResource
    @GET
    @Produces(value={"application/xml"})
    @ApiOperation(value="Retrieve the full catalog as XML", response=String.class, hidden=true)
    @ApiResponses(value={})
    public Response getCatalogXml(@Context HttpServletRequest request) throws Exception {
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)XMLWriter.writeXML((Object)((VersionedCatalog)this.catalogUserApi.getCatalog(catalogName, tenantContext)), VersionedCatalog.class)).build();
    }

    @TimedResource
    @POST
    @Consumes(value={"application/xml"})
    @ApiOperation(value="Upload the full catalog as XML")
    @ApiResponses(value={})
    public Response uploadCatalogXml(String catalogXML, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request, @Context UriInfo uriInfo) throws Exception {
        ByteArrayInputStream stream = new ByteArrayInputStream(catalogXML.getBytes());
        XMLLoader.getObjectFromStream((URI)new URI("/1.0/kb/catalog"), (InputStream)stream, StandaloneCatalog.class);
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        this.catalogUserApi.uploadCatalog(catalogXML, callContext);
        return this.uriBuilder.buildResponse(uriInfo, CatalogResource.class, null, null);
    }

    @TimedResource
    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve the full catalog as JSON", response=StaticCatalog.class)
    @ApiResponses(value={})
    public Response getCatalogJson(@Context HttpServletRequest request) throws Exception {
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        StaticCatalog catalog = this.catalogUserApi.getCurrentCatalog(catalogName, tenantContext);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)catalog).build();
    }

    @TimedResource
    @GET
    @Path(value="/availableAddons")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve available add-ons for a given product", response=PlanDetailJson.class, responseContainer="List")
    @ApiResponses(value={})
    public Response getAvailableAddons(@QueryParam(value="baseProductName") String baseProductName, @Nullable @QueryParam(value="priceListName") String priceListName, @Context HttpServletRequest request) throws CatalogApiException {
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        StaticCatalog catalog = this.catalogUserApi.getCurrentCatalog(catalogName, tenantContext);
        List listings = catalog.getAvailableAddOnListings(baseProductName, priceListName);
        ArrayList<PlanDetailJson> details = new ArrayList<PlanDetailJson>();
        for (Listing listing : listings) {
            details.add(new PlanDetailJson(listing));
        }
        return Response.status((Response.Status)Response.Status.OK).entity(details).build();
    }

    @TimedResource
    @GET
    @Path(value="/availableBasePlans")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve available base plans", response=PlanDetailJson.class, responseContainer="List")
    @ApiResponses(value={})
    public Response getAvailableBasePlans(@Context HttpServletRequest request) throws CatalogApiException {
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        StaticCatalog catalog = this.catalogUserApi.getCurrentCatalog(catalogName, tenantContext);
        List listings = catalog.getAvailableBasePlanListings();
        ArrayList<PlanDetailJson> details = new ArrayList<PlanDetailJson>();
        for (Listing listing : listings) {
            details.add(new PlanDetailJson(listing));
        }
        return Response.status((Response.Status)Response.Status.OK).entity(details).build();
    }

    @TimedResource
    @GET
    @Path(value="/simpleCatalog")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve a summarized version of the catalog as JSON", response=CatalogJsonSimple.class)
    @ApiResponses(value={})
    public Response getSimpleCatalog(@Context HttpServletRequest request) throws CatalogApiException {
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        StaticCatalog catalog = this.catalogUserApi.getCurrentCatalog(catalogName, tenantContext);
        CatalogJsonSimple json = new CatalogJsonSimple(catalog);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)json).build();
    }
}

