/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.joda.time.LocalDate;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.catalog.api.BillingActionPolicy;
import org.killbill.billing.entitlement.api.EntitlementApi;
import org.killbill.billing.entitlement.api.EntitlementApiException;
import org.killbill.billing.entitlement.api.SubscriptionApi;
import org.killbill.billing.entitlement.api.SubscriptionApiException;
import org.killbill.billing.entitlement.api.SubscriptionBundle;
import org.killbill.billing.jaxrs.json.BlockingStateJson;
import org.killbill.billing.jaxrs.json.BundleJson;
import org.killbill.billing.jaxrs.json.CustomFieldJson;
import org.killbill.billing.jaxrs.json.TagJson;
import org.killbill.billing.jaxrs.resources.AuditMode;
import org.killbill.billing.jaxrs.resources.JaxRsResourceBase;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.payment.api.PaymentApi;
import org.killbill.billing.payment.api.PluginProperty;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldApiException;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.TagApiException;
import org.killbill.billing.util.api.TagDefinitionApiException;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.audit.AccountAuditLogs;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.entity.Pagination;
import org.killbill.clock.Clock;
import org.killbill.commons.metrics.TimedResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/1.0/kb/bundles")
@Api(value="/1.0/kb/bundles", description="Operations on bundles")
public class BundleResource
extends JaxRsResourceBase {
    private static final String ID_PARAM_NAME = "bundleId";
    private final SubscriptionApi subscriptionApi;
    private final EntitlementApi entitlementApi;

    @Inject
    public BundleResource(JaxrsUriBuilder uriBuilder, TagUserApi tagUserApi, CustomFieldUserApi customFieldUserApi, AuditUserApi auditUserApi, AccountUserApi accountUserApi, SubscriptionApi subscriptionApi, EntitlementApi entitlementApi, PaymentApi paymentApi, Clock clock, org.killbill.billing.jaxrs.util.Context context) {
        super(uriBuilder, tagUserApi, customFieldUserApi, auditUserApi, accountUserApi, paymentApi, clock, context);
        this.entitlementApi = entitlementApi;
        this.subscriptionApi = subscriptionApi;
    }

    @TimedResource
    @GET
    @Path(value="/{bundleId:\\w+-\\w+-\\w+-\\w+-\\w+}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve a bundle by id", response=BundleJson.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid bundle id supplied"), @ApiResponse(code=404, message="Bundle not found")})
    public Response getBundle(@PathParam(value="bundleId") String bundleId, @Context HttpServletRequest request) throws SubscriptionApiException {
        UUID id = UUID.fromString(bundleId);
        SubscriptionBundle bundle = this.subscriptionApi.getSubscriptionBundle(id, this.context.createContext((ServletRequest)request));
        BundleJson json = new BundleJson(bundle, null);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)json).build();
    }

    @TimedResource
    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve a bundle by external key", response=BundleJson.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Bundle not found")})
    public Response getBundleByKey(@QueryParam(value="externalKey") String externalKey, @Context HttpServletRequest request) throws SubscriptionApiException {
        SubscriptionBundle bundle = this.subscriptionApi.getActiveSubscriptionBundleForExternalKey(externalKey, this.context.createContext((ServletRequest)request));
        BundleJson json = new BundleJson(bundle, null);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)json).build();
    }

    @TimedResource
    @GET
    @Path(value="/pagination")
    @Produces(value={"application/json"})
    @ApiOperation(value="List bundles", response=BundleJson.class, responseContainer="List")
    @ApiResponses(value={})
    public Response getBundles(@QueryParam(value="offset") @DefaultValue(value="0") Long offset, @QueryParam(value="limit") @DefaultValue(value="100") Long limit, final @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) throws SubscriptionApiException {
        final TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        Pagination bundles = this.subscriptionApi.getSubscriptionBundles(offset, limit, tenantContext);
        URI nextPageUri = this.uriBuilder.nextPage(BundleResource.class, "getBundles", bundles.getNextOffset(), limit, (Map<String, String>)ImmutableMap.of((Object)"audit", (Object)auditMode.getLevel().toString()));
        final AtomicReference accountsAuditLogs = new AtomicReference(new HashMap());
        return this.buildStreamingPaginationResponse(bundles, new Function<SubscriptionBundle, BundleJson>(){

            public BundleJson apply(SubscriptionBundle bundle) {
                if (((Map)accountsAuditLogs.get()).get(bundle.getAccountId()) == null) {
                    ((Map)accountsAuditLogs.get()).put(bundle.getAccountId(), BundleResource.this.auditUserApi.getAccountAuditLogs(bundle.getAccountId(), auditMode.getLevel(), tenantContext));
                }
                return new BundleJson(bundle, (AccountAuditLogs)((Map)accountsAuditLogs.get()).get(bundle.getAccountId()));
            }
        }, nextPageUri);
    }

    @TimedResource
    @GET
    @Path(value="/search/{searchKey:.*}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Search bundles", response=BundleJson.class, responseContainer="List")
    @ApiResponses(value={})
    public Response searchBundles(@PathParam(value="searchKey") String searchKey, @QueryParam(value="offset") @DefaultValue(value="0") Long offset, @QueryParam(value="limit") @DefaultValue(value="100") Long limit, final @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) throws SubscriptionApiException {
        final TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        Pagination bundles = this.subscriptionApi.searchSubscriptionBundles(searchKey, offset, limit, tenantContext);
        URI nextPageUri = this.uriBuilder.nextPage(BundleResource.class, "searchBundles", bundles.getNextOffset(), limit, (Map<String, String>)ImmutableMap.of((Object)"searchKey", (Object)searchKey, (Object)"audit", (Object)auditMode.getLevel().toString()));
        final AtomicReference accountsAuditLogs = new AtomicReference(new HashMap());
        return this.buildStreamingPaginationResponse(bundles, new Function<SubscriptionBundle, BundleJson>(){

            public BundleJson apply(SubscriptionBundle bundle) {
                if (((Map)accountsAuditLogs.get()).get(bundle.getAccountId()) == null) {
                    ((Map)accountsAuditLogs.get()).put(bundle.getAccountId(), BundleResource.this.auditUserApi.getAccountAuditLogs(bundle.getAccountId(), auditMode.getLevel(), tenantContext));
                }
                return new BundleJson(bundle, (AccountAuditLogs)((Map)accountsAuditLogs.get()).get(bundle.getAccountId()));
            }
        }, nextPageUri);
    }

    @TimedResource
    @PUT
    @Path(value="/{bundleId:\\w+-\\w+-\\w+-\\w+-\\w+}/pause")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Pause a bundle")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid bundle id supplied"), @ApiResponse(code=404, message="Bundle not found")})
    public Response pauseBundle(@PathParam(value="bundleId") String id, @QueryParam(value="requestedDate") String requestedDate, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) throws SubscriptionApiException, EntitlementApiException, AccountApiException {
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        UUID bundleId = UUID.fromString(id);
        SubscriptionBundle bundle = this.subscriptionApi.getSubscriptionBundle(bundleId, (TenantContext)callContext);
        LocalDate inputLocalDate = this.toLocalDate(bundle.getAccountId(), requestedDate, (TenantContext)callContext);
        this.entitlementApi.pause(bundleId, inputLocalDate, pluginProperties, callContext);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @TimedResource
    @PUT
    @Path(value="/{bundleId:\\w+-\\w+-\\w+-\\w+-\\w+}/resume")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Resume a bundle")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid bundle id supplied"), @ApiResponse(code=404, message="Bundle not found")})
    public Response resumeBundle(@PathParam(value="bundleId") String id, @QueryParam(value="requestedDate") String requestedDate, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) throws SubscriptionApiException, EntitlementApiException, AccountApiException {
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        UUID bundleId = UUID.fromString(id);
        SubscriptionBundle bundle = this.subscriptionApi.getSubscriptionBundle(bundleId, (TenantContext)callContext);
        LocalDate inputLocalDate = this.toLocalDate(bundle.getAccountId(), requestedDate, (TenantContext)callContext);
        this.entitlementApi.resume(bundleId, inputLocalDate, pluginProperties, callContext);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @TimedResource
    @PUT
    @Path(value="/{bundleId:\\w+-\\w+-\\w+-\\w+-\\w+}/block")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Block a bundle")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid bundle id supplied"), @ApiResponse(code=404, message="Bundle not found")})
    public Response addBundleBlockingState(BlockingStateJson json, @PathParam(value="bundleId") String id, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) throws SubscriptionApiException, EntitlementApiException, AccountApiException {
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        UUID bundleId = UUID.fromString(id);
        boolean isBlockBilling = json.isBlockBilling() != null && json.isBlockBilling() != false;
        boolean isBlockEntitlement = json.isBlockEntitlement() != null && json.isBlockEntitlement() != false;
        boolean isBlockChange = json.isBlockChange() != null && json.isBlockChange() != false;
        this.entitlementApi.setBlockingState(bundleId, json.getStateName(), json.getService(), json.getEffectiveDate(), isBlockBilling, isBlockEntitlement, isBlockChange, pluginProperties, callContext);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @TimedResource
    @GET
    @Path(value="/{bundleId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve bundle custom fields", response=CustomFieldJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid bundle id supplied")})
    public Response getCustomFields(@PathParam(value="bundleId") String id, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) {
        return super.getCustomFields(UUID.fromString(id), auditMode, this.context.createContext((ServletRequest)request));
    }

    @TimedResource
    @POST
    @Path(value="/{bundleId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Add custom fields to bundle")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid bundle id supplied")})
    public Response createCustomFields(@PathParam(value="bundleId") String id, List<CustomFieldJson> customFields, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request, @Context UriInfo uriInfo) throws CustomFieldApiException {
        return super.createCustomFields(UUID.fromString(id), customFields, this.context.createContext(createdBy, reason, comment, (ServletRequest)request), uriInfo);
    }

    @TimedResource
    @DELETE
    @Path(value="/{bundleId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Remove custom fields from bundle")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid bundle id supplied")})
    public Response deleteCustomFields(@PathParam(value="bundleId") String id, @QueryParam(value="customFieldList") String customFieldList, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) throws CustomFieldApiException {
        return super.deleteCustomFields(UUID.fromString(id), customFieldList, this.context.createContext(createdBy, reason, comment, (ServletRequest)request));
    }

    @TimedResource
    @GET
    @Path(value="/{bundleId:\\w+-\\w+-\\w+-\\w+-\\w+}/tags")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve bundle tags", response=TagJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid bundle id supplied"), @ApiResponse(code=404, message="Bundle not found")})
    public Response getTags(@PathParam(value="bundleId") String bundleIdString, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @QueryParam(value="includedDeleted") @DefaultValue(value="false") Boolean includedDeleted, @Context HttpServletRequest request) throws TagDefinitionApiException, SubscriptionApiException {
        UUID bundleId = UUID.fromString(bundleIdString);
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        SubscriptionBundle bundle = this.subscriptionApi.getSubscriptionBundle(bundleId, this.context.createContext((ServletRequest)request));
        return super.getTags(bundle.getAccountId(), bundleId, auditMode, includedDeleted, tenantContext);
    }

    @TimedResource
    @PUT
    @Path(value="/{bundleId:\\w+-\\w+-\\w+-\\w+-\\w+}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Transfer a bundle to another account")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid bundle id, requested date or policy supplied"), @ApiResponse(code=404, message="Bundle not found")})
    public Response transferBundle(BundleJson json, @PathParam(value="bundleId") String id, @QueryParam(value="requestedDate") String requestedDate, @QueryParam(value="billingPolicy") @DefaultValue(value="END_OF_TERM") String policyString, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws EntitlementApiException, SubscriptionApiException, AccountApiException {
        this.verifyNonNullOrEmpty(json, "BundleJson body should be specified");
        this.verifyNonNullOrEmpty(json.getAccountId(), "BundleJson accountId needs to be set");
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        BillingActionPolicy policy = BillingActionPolicy.valueOf((String)policyString.toUpperCase());
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        UUID bundleId = UUID.fromString(id);
        SubscriptionBundle bundle = this.subscriptionApi.getSubscriptionBundle(bundleId, (TenantContext)callContext);
        LocalDate inputLocalDate = this.toLocalDate(bundle.getAccountId(), requestedDate, (TenantContext)callContext);
        UUID newBundleId = this.entitlementApi.transferEntitlementsOverrideBillingPolicy(bundle.getAccountId(), UUID.fromString(json.getAccountId()), bundle.getExternalKey(), inputLocalDate, policy, pluginProperties, callContext);
        return this.uriBuilder.buildResponse(BundleResource.class, "getBundle", newBundleId, uriInfo.getBaseUri().toString());
    }

    @TimedResource
    @POST
    @Path(value="/{bundleId:\\w+-\\w+-\\w+-\\w+-\\w+}/tags")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Add tags to bundle")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid bundle id supplied")})
    public Response createTags(@PathParam(value="bundleId") String id, @QueryParam(value="tagList") String tagList, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws TagApiException {
        return super.createTags(UUID.fromString(id), tagList, uriInfo, this.context.createContext(createdBy, reason, comment, (ServletRequest)request));
    }

    @TimedResource
    @DELETE
    @Path(value="/{bundleId:\\w+-\\w+-\\w+-\\w+-\\w+}/tags")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Remove tags from bundle")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid bundle id supplied")})
    public Response deleteTags(@PathParam(value="bundleId") String id, @QueryParam(value="tagList") String tagList, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) throws TagApiException {
        return super.deleteTags(UUID.fromString(id), tagList, this.context.createContext(createdBy, reason, comment, (ServletRequest)request));
    }

    @Override
    protected ObjectType getObjectType() {
        return ObjectType.BUNDLE;
    }
}

