/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.inject.Singleton;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.UUID;
import javax.inject.Inject;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.jaxrs.json.AdminPaymentJson;
import org.killbill.billing.jaxrs.resources.JaxRsResourceBase;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.payment.api.AdminPaymentApi;
import org.killbill.billing.payment.api.Payment;
import org.killbill.billing.payment.api.PaymentApi;
import org.killbill.billing.payment.api.PaymentApiException;
import org.killbill.billing.payment.api.PaymentTransaction;
import org.killbill.billing.payment.api.TransactionStatus;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.clock.Clock;

@Singleton
@Path(value="/1.0/kb/admin")
@Api(value="/1.0/kb/admin", description="Admin operations (will require special privileges)")
public class AdminResource
extends JaxRsResourceBase {
    private final AdminPaymentApi adminPaymentApi;

    @Inject
    public AdminResource(JaxrsUriBuilder uriBuilder, TagUserApi tagUserApi, CustomFieldUserApi customFieldUserApi, AuditUserApi auditUserApi, AccountUserApi accountUserApi, PaymentApi paymentApi, AdminPaymentApi adminPaymentApi, Clock clock, org.killbill.billing.jaxrs.util.Context context) {
        super(uriBuilder, tagUserApi, customFieldUserApi, auditUserApi, accountUserApi, paymentApi, clock, context);
        this.adminPaymentApi = adminPaymentApi;
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/payments/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}/transactions/{paymentTransactionId:\\w+-\\w+-\\w+-\\w+-\\w+}")
    @ApiOperation(value="Update existing paymentTransaction and associated payment state")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid account data supplied")})
    public Response updatePaymentTransactionState(AdminPaymentJson json, @PathParam(value="paymentId") String paymentIdStr, @PathParam(value="paymentTransactionId") String paymentTransactionIdStr, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) throws PaymentApiException {
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        Payment payment = this.paymentApi.getPayment(UUID.fromString(paymentIdStr), false, (Iterable)ImmutableList.of(), (TenantContext)callContext);
        final UUID paymentTransactionId = UUID.fromString(paymentTransactionIdStr);
        PaymentTransaction paymentTransaction = (PaymentTransaction)Iterables.tryFind((Iterable)payment.getTransactions(), (Predicate)new Predicate<PaymentTransaction>(){

            public boolean apply(PaymentTransaction input) {
                return input.getId().equals(paymentTransactionId);
            }
        }).orNull();
        this.adminPaymentApi.fixPaymentTransactionState(payment, paymentTransaction, TransactionStatus.valueOf((String)json.getTransactionStatus()), json.getLastSuccessPaymentState(), json.getCurrentPaymentStateName(), (Iterable)ImmutableList.of(), callContext);
        return Response.status((Response.Status)Response.Status.OK).build();
    }
}

