/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.AccountData;
import org.killbill.billing.account.api.AccountEmail;
import org.killbill.billing.account.api.AccountInternalApi;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.account.api.ImmutableAccountData;
import org.killbill.billing.account.api.MutableAccountData;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.entitlement.api.SubscriptionApi;
import org.killbill.billing.entitlement.api.SubscriptionApiException;
import org.killbill.billing.entitlement.api.SubscriptionBundle;
import org.killbill.billing.invoice.api.Invoice;
import org.killbill.billing.invoice.api.InvoiceApiException;
import org.killbill.billing.invoice.api.InvoicePayment;
import org.killbill.billing.invoice.api.InvoicePaymentApi;
import org.killbill.billing.invoice.api.InvoiceUserApi;
import org.killbill.billing.jaxrs.JaxrsExecutors;
import org.killbill.billing.jaxrs.json.AccountEmailJson;
import org.killbill.billing.jaxrs.json.AccountJson;
import org.killbill.billing.jaxrs.json.AccountTimelineJson;
import org.killbill.billing.jaxrs.json.BundleJson;
import org.killbill.billing.jaxrs.json.CustomFieldJson;
import org.killbill.billing.jaxrs.json.InvoiceEmailJson;
import org.killbill.billing.jaxrs.json.InvoiceJson;
import org.killbill.billing.jaxrs.json.InvoicePaymentJson;
import org.killbill.billing.jaxrs.json.OverdueStateJson;
import org.killbill.billing.jaxrs.json.PaymentJson;
import org.killbill.billing.jaxrs.json.PaymentMethodJson;
import org.killbill.billing.jaxrs.json.PaymentTransactionJson;
import org.killbill.billing.jaxrs.json.TagJson;
import org.killbill.billing.jaxrs.resources.AuditMode;
import org.killbill.billing.jaxrs.resources.JaxRsResourceBase;
import org.killbill.billing.jaxrs.resources.PaymentMethodResource;
import org.killbill.billing.jaxrs.resources.PaymentResource;
import org.killbill.billing.jaxrs.util.Context;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.overdue.OverdueInternalApi;
import org.killbill.billing.overdue.api.OverdueApiException;
import org.killbill.billing.overdue.api.OverdueState;
import org.killbill.billing.overdue.config.api.OverdueException;
import org.killbill.billing.payment.api.Payment;
import org.killbill.billing.payment.api.PaymentApi;
import org.killbill.billing.payment.api.PaymentApiException;
import org.killbill.billing.payment.api.PaymentMethod;
import org.killbill.billing.payment.api.PaymentOptions;
import org.killbill.billing.payment.api.PluginProperty;
import org.killbill.billing.payment.api.TransactionType;
import org.killbill.billing.util.UUIDs;
import org.killbill.billing.util.api.AuditLevel;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldApiException;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.TagApiException;
import org.killbill.billing.util.api.TagDefinitionApiException;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.audit.AccountAuditLogs;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.config.JaxrsConfig;
import org.killbill.billing.util.config.PaymentConfig;
import org.killbill.billing.util.entity.Pagination;
import org.killbill.billing.util.tag.ControlTagType;
import org.killbill.clock.Clock;
import org.killbill.commons.metrics.MetricTag;
import org.killbill.commons.metrics.TimedResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
@Path(value="/1.0/kb/accounts")
@Api(value="/1.0/kb/accounts", description="Operations on accounts")
public class AccountResource
extends JaxRsResourceBase {
    private static final String ID_PARAM_NAME = "accountId";
    private final SubscriptionApi subscriptionApi;
    private final InvoiceUserApi invoiceApi;
    private final InvoicePaymentApi invoicePaymentApi;
    private final OverdueInternalApi overdueApi;
    private final PaymentConfig paymentConfig;
    private final JaxrsExecutors jaxrsExecutors;
    private final JaxrsConfig jaxrsConfig;

    @Inject
    public AccountResource(JaxrsUriBuilder uriBuilder, AccountUserApi accountApi, InvoiceUserApi invoiceApi, InvoicePaymentApi invoicePaymentApi, PaymentApi paymentApi, TagUserApi tagUserApi, AuditUserApi auditUserApi, CustomFieldUserApi customFieldUserApi, SubscriptionApi subscriptionApi, AccountInternalApi accountInternalApi, OverdueInternalApi overdueApi, Clock clock, PaymentConfig paymentConfig, JaxrsExecutors jaxrsExecutors, JaxrsConfig jaxrsConfig, Context context) {
        super(uriBuilder, tagUserApi, customFieldUserApi, auditUserApi, accountApi, paymentApi, clock, context);
        this.subscriptionApi = subscriptionApi;
        this.invoiceApi = invoiceApi;
        this.invoicePaymentApi = invoicePaymentApi;
        this.overdueApi = overdueApi;
        this.paymentConfig = paymentConfig;
        this.jaxrsExecutors = jaxrsExecutors;
        this.jaxrsConfig = jaxrsConfig;
    }

    @TimedResource
    @GET
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve an account by id", response=AccountJson.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid account id supplied"), @ApiResponse(code=404, message="Account not found")})
    public Response getAccount(@PathParam(value="accountId") String accountId, @QueryParam(value="accountWithBalance") @DefaultValue(value="false") Boolean accountWithBalance, @QueryParam(value="accountWithBalanceAndCBA") @DefaultValue(value="false") Boolean accountWithBalanceAndCBA, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @javax.ws.rs.core.Context HttpServletRequest request) throws AccountApiException {
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        Account account = this.accountUserApi.getAccountById(UUID.fromString(accountId), tenantContext);
        AccountAuditLogs accountAuditLogs = this.auditUserApi.getAccountAuditLogs(account.getId(), auditMode.getLevel(), tenantContext);
        AccountJson accountJson = this.getAccount(account, accountWithBalance, accountWithBalanceAndCBA, accountAuditLogs, tenantContext);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)accountJson).build();
    }

    @TimedResource
    @GET
    @Path(value="/pagination")
    @Produces(value={"application/json"})
    @ApiOperation(value="List accounts", response=AccountJson.class, responseContainer="List")
    @ApiResponses(value={})
    public Response getAccounts(@QueryParam(value="offset") @DefaultValue(value="0") Long offset, @QueryParam(value="limit") @DefaultValue(value="100") Long limit, final @QueryParam(value="accountWithBalance") @DefaultValue(value="false") Boolean accountWithBalance, final @QueryParam(value="accountWithBalanceAndCBA") @DefaultValue(value="false") Boolean accountWithBalanceAndCBA, final @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @javax.ws.rs.core.Context HttpServletRequest request) throws AccountApiException {
        final TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        Pagination accounts = this.accountUserApi.getAccounts(offset, limit, tenantContext);
        URI nextPageUri = this.uriBuilder.nextPage(AccountResource.class, "getAccounts", accounts.getNextOffset(), limit, (Map<String, String>)ImmutableMap.of((Object)"accountWithBalance", (Object)accountWithBalance.toString(), (Object)"accountWithBalanceAndCBA", (Object)accountWithBalanceAndCBA.toString(), (Object)"audit", (Object)auditMode.getLevel().toString()));
        return this.buildStreamingPaginationResponse(accounts, new Function<Account, AccountJson>(){

            public AccountJson apply(Account account) {
                AccountAuditLogs accountAuditLogs = AccountResource.this.auditUserApi.getAccountAuditLogs(account.getId(), auditMode.getLevel(), tenantContext);
                return AccountResource.this.getAccount(account, accountWithBalance, accountWithBalanceAndCBA, accountAuditLogs, tenantContext);
            }
        }, nextPageUri);
    }

    @TimedResource
    @GET
    @Path(value="/search/{searchKey:.*}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Search accounts", response=AccountJson.class, responseContainer="List")
    @ApiResponses(value={})
    public Response searchAccounts(@PathParam(value="searchKey") String searchKey, @QueryParam(value="offset") @DefaultValue(value="0") Long offset, @QueryParam(value="limit") @DefaultValue(value="100") Long limit, final @QueryParam(value="accountWithBalance") @DefaultValue(value="false") Boolean accountWithBalance, final @QueryParam(value="accountWithBalanceAndCBA") @DefaultValue(value="false") Boolean accountWithBalanceAndCBA, final @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @javax.ws.rs.core.Context HttpServletRequest request) throws AccountApiException {
        final TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        Pagination accounts = this.accountUserApi.searchAccounts(searchKey, offset, limit, tenantContext);
        URI nextPageUri = this.uriBuilder.nextPage(AccountResource.class, "searchAccounts", accounts.getNextOffset(), limit, (Map<String, String>)ImmutableMap.of((Object)"searchKey", (Object)searchKey, (Object)"accountWithBalance", (Object)accountWithBalance.toString(), (Object)"accountWithBalanceAndCBA", (Object)accountWithBalanceAndCBA.toString(), (Object)"audit", (Object)auditMode.getLevel().toString()));
        return this.buildStreamingPaginationResponse(accounts, new Function<Account, AccountJson>(){

            public AccountJson apply(Account account) {
                AccountAuditLogs accountAuditLogs = AccountResource.this.auditUserApi.getAccountAuditLogs(account.getId(), auditMode.getLevel(), tenantContext);
                return AccountResource.this.getAccount(account, accountWithBalance, accountWithBalanceAndCBA, accountAuditLogs, tenantContext);
            }
        }, nextPageUri);
    }

    @TimedResource
    @GET
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/bundles")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve bundles for account", response=BundleJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid account id supplied"), @ApiResponse(code=404, message="Account not found")})
    public Response getAccountBundles(@PathParam(value="accountId") String accountId, @QueryParam(value="externalKey") String externalKey, @javax.ws.rs.core.Context HttpServletRequest request) throws AccountApiException, SubscriptionApiException {
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        UUID uuid = UUID.fromString(accountId);
        this.accountUserApi.getAccountById(uuid, tenantContext);
        List bundles = externalKey != null ? this.subscriptionApi.getSubscriptionBundlesForAccountIdAndExternalKey(uuid, externalKey, tenantContext) : this.subscriptionApi.getSubscriptionBundlesForAccountId(uuid, tenantContext);
        Collection result = Collections2.transform((Collection)bundles, (Function)new Function<SubscriptionBundle, BundleJson>(){

            public BundleJson apply(SubscriptionBundle input) {
                return new BundleJson(input, null);
            }
        });
        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
    }

    @TimedResource
    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve an account by external key", response=AccountJson.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Account not found")})
    public Response getAccountByKey(@QueryParam(value="externalKey") String externalKey, @QueryParam(value="accountWithBalance") @DefaultValue(value="false") Boolean accountWithBalance, @QueryParam(value="accountWithBalanceAndCBA") @DefaultValue(value="false") Boolean accountWithBalanceAndCBA, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @javax.ws.rs.core.Context HttpServletRequest request) throws AccountApiException {
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        Account account = this.accountUserApi.getAccountByKey(externalKey, tenantContext);
        AccountAuditLogs accountAuditLogs = this.auditUserApi.getAccountAuditLogs(account.getId(), auditMode.getLevel(), tenantContext);
        AccountJson accountJson = this.getAccount(account, accountWithBalance, accountWithBalanceAndCBA, accountAuditLogs, tenantContext);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)accountJson).build();
    }

    private AccountJson getAccount(Account account, Boolean accountWithBalance, Boolean accountWithBalanceAndCBA, AccountAuditLogs auditLogs, TenantContext tenantContext) {
        if (accountWithBalanceAndCBA.booleanValue()) {
            BigDecimal accountBalance = this.invoiceApi.getAccountBalance(account.getId(), tenantContext);
            BigDecimal accountCBA = this.invoiceApi.getAccountCBA(account.getId(), tenantContext);
            return new AccountJson(account, accountBalance, accountCBA, auditLogs);
        }
        if (accountWithBalance.booleanValue()) {
            BigDecimal accountBalance = this.invoiceApi.getAccountBalance(account.getId(), tenantContext);
            return new AccountJson(account, accountBalance, null, auditLogs);
        }
        return new AccountJson(account, null, null, auditLogs);
    }

    @TimedResource
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create account")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid account data supplied")})
    public Response createAccount(AccountJson json, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request, @javax.ws.rs.core.Context UriInfo uriInfo) throws AccountApiException {
        this.verifyNonNullOrEmpty(json, "AccountJson body should be specified");
        AccountData data = json.toAccountData();
        Account account = this.accountUserApi.createAccount(data, this.context.createContext(createdBy, reason, comment, (ServletRequest)request));
        return this.uriBuilder.buildResponse(uriInfo, AccountResource.class, "getAccount", account.getId());
    }

    @TimedResource
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}")
    @ApiOperation(value="Update account")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid account data supplied")})
    public Response updateAccount(AccountJson json, @PathParam(value="accountId") String accountId, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request) throws AccountApiException {
        this.verifyNonNullOrEmpty(json, "AccountJson body should be specified");
        AccountData data = json.toAccountData();
        UUID uuid = UUID.fromString(accountId);
        this.accountUserApi.updateAccount(uuid, data, this.context.createContext(createdBy, reason, comment, (ServletRequest)request));
        return this.getAccount(accountId, (Boolean)false, (Boolean)false, new AuditMode(AuditLevel.NONE.toString()), request);
    }

    @TimedResource
    @DELETE
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete account", hidden=true)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid account id supplied")})
    public Response cancelAccount(@PathParam(value="accountId") String accountId, @javax.ws.rs.core.Context HttpServletRequest request) {
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
    }

    @TimedResource
    @GET
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/timeline")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve account timeline", response=AccountTimelineJson.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid account id supplied"), @ApiResponse(code=404, message="Account not found")})
    public Response getAccountTimeline(@PathParam(value="accountId") String accountIdString, final @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @QueryParam(value="parallel") @DefaultValue(value="false") Boolean parallel, @javax.ws.rs.core.Context HttpServletRequest request) throws AccountApiException, PaymentApiException, SubscriptionApiException, InvoiceApiException {
        final TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        final UUID accountId = UUID.fromString(accountIdString);
        final Account account = this.accountUserApi.getAccountById(accountId, tenantContext);
        Callable<List<SubscriptionBundle>> bundlesCallable = new Callable<List<SubscriptionBundle>>(){

            @Override
            public List<SubscriptionBundle> call() throws Exception {
                return AccountResource.this.subscriptionApi.getSubscriptionBundlesForAccountId(account.getId(), tenantContext);
            }
        };
        Callable<List<Invoice>> invoicesCallable = new Callable<List<Invoice>>(){

            @Override
            public List<Invoice> call() throws Exception {
                return AccountResource.this.invoiceApi.getInvoicesByAccount(account.getId(), tenantContext);
            }
        };
        Callable<List<InvoicePayment>> invoicePaymentsCallable = new Callable<List<InvoicePayment>>(){

            @Override
            public List<InvoicePayment> call() throws Exception {
                return AccountResource.this.invoicePaymentApi.getInvoicePaymentsByAccount(accountId, tenantContext);
            }
        };
        Callable<List<Payment>> paymentsCallable = new Callable<List<Payment>>(){

            @Override
            public List<Payment> call() throws Exception {
                return AccountResource.this.paymentApi.getAccountPayments(accountId, false, (Iterable)ImmutableList.of(), tenantContext);
            }
        };
        Callable<AccountAuditLogs> auditsCallable = new Callable<AccountAuditLogs>(){

            @Override
            public AccountAuditLogs call() throws Exception {
                return AccountResource.this.auditUserApi.getAccountAuditLogs(accountId, auditMode.getLevel(), tenantContext);
            }
        };
        List<Invoice> invoices = null;
        List<SubscriptionBundle> bundles = null;
        List<InvoicePayment> invoicePayments = null;
        List<Payment> payments = null;
        AccountAuditLogs accountAuditLogs = null;
        if (parallel.booleanValue()) {
            ExecutorService executor = this.jaxrsExecutors.getJaxrsExecutorService();
            Future<List<SubscriptionBundle>> futureBundlesCallable = executor.submit(bundlesCallable);
            Future<List<Invoice>> futureInvoicesCallable = executor.submit(invoicesCallable);
            Future<List<InvoicePayment>> futureInvoicePaymentsCallable = executor.submit(invoicePaymentsCallable);
            Future<List<Payment>> futurePaymentsCallable = executor.submit(paymentsCallable);
            Future<AccountAuditLogs> futureAuditsCallable = executor.submit(auditsCallable);
            try {
                long ini = System.currentTimeMillis();
                do {
                    bundles = bundles == null ? this.runCallableAndHandleTimeout(futureBundlesCallable, 100L) : bundles;
                    invoices = invoices == null ? this.runCallableAndHandleTimeout(futureInvoicesCallable, 100L) : invoices;
                    invoicePayments = invoicePayments == null ? this.runCallableAndHandleTimeout(futureInvoicePaymentsCallable, 100L) : invoicePayments;
                    payments = payments == null ? this.runCallableAndHandleTimeout(futurePaymentsCallable, 100L) : payments;
                    AccountAuditLogs accountAuditLogs2 = accountAuditLogs = accountAuditLogs == null ? this.runCallableAndHandleTimeout(futureAuditsCallable, 100L) : accountAuditLogs;
                } while (System.currentTimeMillis() - ini < this.jaxrsConfig.getJaxrsTimeout().getMillis() && (bundles == null || invoices == null || invoicePayments == null || payments == null || accountAuditLogs == null));
                if (bundles == null || invoices == null || invoicePayments == null || payments == null || accountAuditLogs == null) {
                    Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
                }
            }
            catch (InterruptedException e) {
                this.handleCallableException(e, (List<Future>)ImmutableList.of(futureBundlesCallable, futureInvoicesCallable, futureInvoicePaymentsCallable, futurePaymentsCallable, futureAuditsCallable));
            }
            catch (ExecutionException e) {
                this.handleCallableException(e.getCause(), (List<Future>)ImmutableList.of(futureBundlesCallable, futureInvoicesCallable, futureInvoicePaymentsCallable, futurePaymentsCallable, futureAuditsCallable));
            }
        } else {
            try {
                invoices = (List<Invoice>)invoicesCallable.call();
                payments = (List<Payment>)paymentsCallable.call();
                bundles = (List<SubscriptionBundle>)bundlesCallable.call();
                accountAuditLogs = (AccountAuditLogs)auditsCallable.call();
                invoicePayments = (List<InvoicePayment>)invoicePaymentsCallable.call();
            }
            catch (Exception e) {
                this.handleCallableException(e);
            }
        }
        AccountTimelineJson json = new AccountTimelineJson(account, invoices, payments, invoicePayments, bundles, accountAuditLogs);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)json).build();
    }

    private <T> T runCallableAndHandleTimeout(Future<T> future, long timeoutMsec) throws ExecutionException, InterruptedException {
        try {
            return future.get(timeoutMsec, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            return null;
        }
    }

    private void handleCallableException(Throwable causeOrException, List<Future> toBeCancelled) throws AccountApiException, SubscriptionApiException, PaymentApiException, InvoiceApiException {
        for (Future f : toBeCancelled) {
            f.cancel(true);
        }
        this.handleCallableException(causeOrException);
    }

    private void handleCallableException(Throwable causeOrException) throws AccountApiException, SubscriptionApiException, PaymentApiException, InvoiceApiException {
        if (causeOrException instanceof AccountApiException) {
            throw (AccountApiException)causeOrException;
        }
        if (causeOrException instanceof SubscriptionApiException) {
            throw (SubscriptionApiException)causeOrException;
        }
        if (causeOrException instanceof InvoiceApiException) {
            throw (InvoiceApiException)causeOrException;
        }
        if (causeOrException instanceof PaymentApiException) {
            throw (PaymentApiException)causeOrException;
        }
        if (causeOrException instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        throw new RuntimeException(causeOrException.getMessage(), causeOrException);
    }

    @TimedResource
    @GET
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/emailNotifications")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve account email notification", response=InvoiceEmailJson.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid account id supplied"), @ApiResponse(code=404, message="Account not found")})
    public Response getEmailNotificationsForAccount(@PathParam(value="accountId") String accountId, @javax.ws.rs.core.Context HttpServletRequest request) throws AccountApiException {
        Account account = this.accountUserApi.getAccountById(UUID.fromString(accountId), this.context.createContext((ServletRequest)request));
        InvoiceEmailJson invoiceEmailJson = new InvoiceEmailJson(accountId, account.isNotifiedForInvoices());
        return Response.status((Response.Status)Response.Status.OK).entity((Object)invoiceEmailJson).build();
    }

    @TimedResource
    @PUT
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/emailNotifications")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Set account email notification")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid account id supplied"), @ApiResponse(code=404, message="Account not found")})
    public Response setEmailNotificationsForAccount(InvoiceEmailJson json, @PathParam(value="accountId") String accountIdString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request) throws AccountApiException {
        this.verifyNonNullOrEmpty(json, "InvoiceEmailJson body should be specified");
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        UUID accountId = UUID.fromString(accountIdString);
        Account account = this.accountUserApi.getAccountById(accountId, (TenantContext)callContext);
        MutableAccountData mutableAccountData = account.toMutableAccountData();
        mutableAccountData.setIsNotifiedForInvoices(json.isNotifiedForInvoices());
        this.accountUserApi.updateAccount(accountId, (AccountData)mutableAccountData, callContext);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @TimedResource
    @POST
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/cbaRebalancing")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Rebalance account CBA")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid account id supplied")})
    public Response rebalanceExistingCBAOnAccount(@PathParam(value="accountId") String accountIdString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request) throws AccountApiException {
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        UUID accountId = UUID.fromString(accountIdString);
        this.invoiceApi.consumeExstingCBAOnAccountWithUnpaidInvoices(accountId, callContext);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @TimedResource
    @GET
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/invoices")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve account invoices", response=InvoiceJson.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid account id supplied"), @ApiResponse(code=404, message="Account not found")})
    public Response getInvoices(@PathParam(value="accountId") String accountIdString, @QueryParam(value="withItems") @DefaultValue(value="false") boolean withItems, @QueryParam(value="unpaidInvoicesOnly") @DefaultValue(value="false") boolean unpaidInvoicesOnly, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @javax.ws.rs.core.Context HttpServletRequest request) throws AccountApiException {
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        UUID accountId = UUID.fromString(accountIdString);
        this.accountUserApi.getAccountById(accountId, tenantContext);
        List invoices = unpaidInvoicesOnly ? new ArrayList(this.invoiceApi.getUnpaidInvoicesByAccountId(accountId, null, tenantContext)) : this.invoiceApi.getInvoicesByAccount(accountId, tenantContext);
        AccountAuditLogs accountAuditLogs = this.auditUserApi.getAccountAuditLogs(accountId, auditMode.getLevel(), tenantContext);
        LinkedList<InvoiceJson> result = new LinkedList<InvoiceJson>();
        for (Invoice invoice : invoices) {
            result.add(new InvoiceJson(invoice, withItems, accountAuditLogs));
        }
        return Response.status((Response.Status)Response.Status.OK).entity(result).build();
    }

    @TimedResource
    @GET
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/invoicePayments")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve account invoice payments", response=InvoicePaymentJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid account id supplied"), @ApiResponse(code=404, message="Account not found")})
    public Response getInvoicePayments(@PathParam(value="accountId") String accountIdStr, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @QueryParam(value="withPluginInfo") @DefaultValue(value="false") Boolean withPluginInfo, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @javax.ws.rs.core.Context HttpServletRequest request) throws PaymentApiException, AccountApiException {
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        UUID accountId = UUID.fromString(accountIdStr);
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        Account account = this.accountUserApi.getAccountById(accountId, tenantContext);
        List payments = this.paymentApi.getAccountPayments(account.getId(), withPluginInfo.booleanValue(), pluginProperties, tenantContext);
        List invoicePayments = this.invoicePaymentApi.getInvoicePaymentsByAccount(accountId, tenantContext);
        AccountAuditLogs accountAuditLogs = this.auditUserApi.getAccountAuditLogs(accountId, auditMode.getLevel(), tenantContext);
        ArrayList<InvoicePaymentJson> result = new ArrayList<InvoicePaymentJson>(payments.size());
        for (Payment payment : payments) {
            UUID invoiceId = AccountResource.getInvoiceId(invoicePayments, payment);
            result.add(new InvoicePaymentJson(payment, invoiceId, accountAuditLogs));
        }
        return Response.status((Response.Status)Response.Status.OK).entity(result).build();
    }

    @TimedResource
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/invoicePayments")
    @ApiOperation(value="Trigger a payment for all unpaid invoices")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid account id supplied"), @ApiResponse(code=404, message="Account not found")})
    public Response payAllInvoices(@PathParam(value="accountId") String accountId, @QueryParam(value="externalPayment") @DefaultValue(value="false") Boolean externalPayment, @QueryParam(value="paymentAmount") BigDecimal paymentAmount, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request) throws AccountApiException, PaymentApiException, InvoiceApiException {
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        Account account = this.accountUserApi.getAccountById(UUID.fromString(accountId), (TenantContext)callContext);
        Collection unpaidInvoices = this.invoiceApi.getUnpaidInvoicesByAccountId(account.getId(), this.clock.getUTCToday(), (TenantContext)callContext);
        BigDecimal remainingRequestPayment = paymentAmount;
        if (remainingRequestPayment == null) {
            remainingRequestPayment = BigDecimal.ZERO;
            for (Invoice invoice : unpaidInvoices) {
                remainingRequestPayment = remainingRequestPayment.add(invoice.getBalance());
            }
        }
        for (Invoice invoice : unpaidInvoices) {
            BigDecimal amountToPay;
            BigDecimal bigDecimal = amountToPay = remainingRequestPayment.compareTo(invoice.getBalance()) >= 0 ? invoice.getBalance() : remainingRequestPayment;
            if (amountToPay.compareTo(BigDecimal.ZERO) > 0) {
                UUID paymentMethodId = externalPayment != false ? null : account.getPaymentMethodId();
                this.createPurchaseForInvoice(account, invoice.getId(), amountToPay, paymentMethodId, externalPayment, pluginProperties, callContext);
            }
            if ((remainingRequestPayment = remainingRequestPayment.subtract(amountToPay)).compareTo(BigDecimal.ZERO) != 0) continue;
            break;
        }
        if (externalPayment.booleanValue() && remainingRequestPayment.compareTo(BigDecimal.ZERO) > 0) {
            this.invoiceApi.insertCredit(account.getId(), remainingRequestPayment, this.clock.getUTCToday(), account.getCurrency(), callContext);
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @TimedResource
    @POST
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/paymentMethods")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Add a payment method")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid account id supplied"), @ApiResponse(code=404, message="Account not found")})
    public Response createPaymentMethod(PaymentMethodJson json, @PathParam(value="accountId") String accountId, @QueryParam(value="isDefault") @DefaultValue(value="false") Boolean isDefault, @QueryParam(value="payAllUnpaidInvoices") @DefaultValue(value="false") Boolean payAllUnpaidInvoices, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context UriInfo uriInfo, @javax.ws.rs.core.Context HttpServletRequest request) throws AccountApiException, PaymentApiException {
        List<Invoice> unpaidInvoices;
        this.verifyNonNullOrEmpty(json, "PaymentMethodJson body should be specified");
        this.verifyNonNullOrEmpty(json.getPluginName(), "PaymentMethodJson pluginName should be specified");
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        PaymentMethod data = json.toPaymentMethod(accountId);
        Account account = this.accountUserApi.getAccountById(data.getAccountId(), (TenantContext)callContext);
        boolean hasDefaultPaymentMethod = account.getPaymentMethodId() != null || isDefault != false;
        Collection<Object> collection = unpaidInvoices = payAllUnpaidInvoices != false ? this.invoiceApi.getUnpaidInvoicesByAccountId(account.getId(), this.clock.getUTCToday(), (TenantContext)callContext) : Collections.emptyList();
        if (payAllUnpaidInvoices.booleanValue() && unpaidInvoices.size() > 0 && !hasDefaultPaymentMethod) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        UUID paymentMethodId = this.paymentApi.addPaymentMethod(account, data.getExternalKey(), data.getPluginName(), isDefault.booleanValue(), data.getPluginDetail(), pluginProperties, callContext);
        if (payAllUnpaidInvoices.booleanValue() && unpaidInvoices.size() > 0) {
            for (Invoice invoice : unpaidInvoices) {
                this.createPurchaseForInvoice(account, invoice.getId(), invoice.getBalance(), paymentMethodId, false, pluginProperties, callContext);
            }
        }
        return this.uriBuilder.buildResponse(PaymentMethodResource.class, "getPaymentMethod", paymentMethodId, uriInfo.getBaseUri().toString());
    }

    @TimedResource
    @GET
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/paymentMethods")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve account payment methods", response=PaymentMethodJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid account id supplied"), @ApiResponse(code=404, message="Account not found")})
    public Response getPaymentMethods(@PathParam(value="accountId") String accountId, @QueryParam(value="withPluginInfo") @DefaultValue(value="false") Boolean withPluginInfo, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @javax.ws.rs.core.Context HttpServletRequest request) throws AccountApiException, PaymentApiException {
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        final Account account = this.accountUserApi.getAccountById(UUID.fromString(accountId), tenantContext);
        List methods = this.paymentApi.getAccountPaymentMethods(account.getId(), withPluginInfo.booleanValue(), pluginProperties, tenantContext);
        final AccountAuditLogs accountAuditLogs = this.auditUserApi.getAccountAuditLogs(account.getId(), auditMode.getLevel(), tenantContext);
        ArrayList json = new ArrayList(Collections2.transform((Collection)methods, (Function)new Function<PaymentMethod, PaymentMethodJson>(){

            public PaymentMethodJson apply(PaymentMethod input) {
                return PaymentMethodJson.toPaymentMethodJson(account, input, accountAuditLogs);
            }
        }));
        return Response.status((Response.Status)Response.Status.OK).entity(json).build();
    }

    @TimedResource
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/paymentMethods/{paymentMethodId:\\w+-\\w+-\\w+-\\w+-\\w+}/setDefault")
    @ApiOperation(value="Set the default payment method")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid account id or payment method id supplied"), @ApiResponse(code=404, message="Account not found")})
    public Response setDefaultPaymentMethod(@PathParam(value="accountId") String accountId, @PathParam(value="paymentMethodId") String paymentMethodId, @QueryParam(value="payAllUnpaidInvoices") @DefaultValue(value="false") Boolean payAllUnpaidInvoices, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request) throws AccountApiException, PaymentApiException {
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        Account account = this.accountUserApi.getAccountById(UUID.fromString(accountId), (TenantContext)callContext);
        this.paymentApi.setDefaultPaymentMethod(account, UUID.fromString(paymentMethodId), pluginProperties, callContext);
        if (payAllUnpaidInvoices.booleanValue()) {
            Collection unpaidInvoices = this.invoiceApi.getUnpaidInvoicesByAccountId(account.getId(), this.clock.getUTCToday(), (TenantContext)callContext);
            for (Invoice invoice : unpaidInvoices) {
                this.createPurchaseForInvoice(account, invoice.getId(), invoice.getBalance(), account.getPaymentMethodId(), false, pluginProperties, callContext);
            }
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @TimedResource
    @GET
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/payments")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve account payments", response=PaymentJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid account id supplied")})
    public Response getPayments(@PathParam(value="accountId") String accountIdStr, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @QueryParam(value="withPluginInfo") @DefaultValue(value="false") Boolean withPluginInfo, @javax.ws.rs.core.Context HttpServletRequest request) throws PaymentApiException {
        UUID accountId = UUID.fromString(accountIdStr);
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        List payments = this.paymentApi.getAccountPayments(accountId, withPluginInfo.booleanValue(), pluginProperties, tenantContext);
        final AccountAuditLogs accountAuditLogs = this.auditUserApi.getAccountAuditLogs(accountId, auditMode.getLevel(), tenantContext);
        ImmutableList result = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)payments, (Function)new Function<Payment, PaymentJson>(){

            public PaymentJson apply(Payment payment) {
                return new PaymentJson(payment, accountAuditLogs);
            }
        }));
        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
    }

    @TimedResource(name="processPayment")
    @POST
    @Path(value="/payments")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Trigger a payment using the account external key (authorization, purchase or credit)")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid account external key supplied"), @ApiResponse(code=404, message="Account not found")})
    public Response processPaymentByExternalKey(@MetricTag(tag="type", property="transactionType") PaymentTransactionJson json, @QueryParam(value="externalKey") String externalKey, @QueryParam(value="paymentMethodId") String paymentMethodIdStr, @QueryParam(value="controlPluginName") List<String> paymentControlPluginNames, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context UriInfo uriInfo, @javax.ws.rs.core.Context HttpServletRequest request) throws PaymentApiException, AccountApiException {
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        Account account = this.accountUserApi.getAccountByKey(externalKey, (TenantContext)callContext);
        return this.processPayment(json, account, paymentMethodIdStr, paymentControlPluginNames, pluginPropertiesString, uriInfo, callContext);
    }

    @TimedResource(name="processPayment")
    @POST
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/payments")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Trigger a payment (authorization, purchase or credit)")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid account id supplied"), @ApiResponse(code=404, message="Account not found")})
    public Response processPayment(@MetricTag(tag="type", property="transactionType") PaymentTransactionJson json, @PathParam(value="accountId") String accountIdStr, @QueryParam(value="paymentMethodId") String paymentMethodIdStr, @QueryParam(value="controlPluginName") List<String> paymentControlPluginNames, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context UriInfo uriInfo, @javax.ws.rs.core.Context HttpServletRequest request) throws PaymentApiException, AccountApiException {
        UUID accountId = UUID.fromString(accountIdStr);
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        Account account = this.accountUserApi.getAccountById(accountId, (TenantContext)callContext);
        return this.processPayment(json, account, paymentMethodIdStr, paymentControlPluginNames, pluginPropertiesString, uriInfo, callContext);
    }

    private Response processPayment(PaymentTransactionJson json, Account account, String paymentMethodIdStr, List<String> paymentControlPluginNames, List<String> pluginPropertiesString, UriInfo uriInfo, CallContext callContext) throws PaymentApiException {
        Payment result;
        this.verifyNonNullOrEmpty(json, "PaymentTransactionJson body should be specified");
        this.verifyNonNullOrEmpty(json.getTransactionType(), "PaymentTransactionJson transactionType needs to be set", json.getAmount(), "PaymentTransactionJson amount needs to be set");
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        UUID paymentMethodId = paymentMethodIdStr == null ? account.getPaymentMethodId() : UUID.fromString(paymentMethodIdStr);
        Currency currency = json.getCurrency() == null ? account.getCurrency() : Currency.valueOf((String)json.getCurrency());
        UUID paymentId = json.getPaymentId() == null ? null : UUID.fromString(json.getPaymentId());
        this.validatePaymentMethodForAccount(account.getId(), paymentMethodId, callContext);
        TransactionType transactionType = TransactionType.valueOf((String)json.getTransactionType());
        PaymentOptions paymentOptions = this.createControlPluginApiPaymentOptions(paymentControlPluginNames);
        switch (transactionType) {
            case AUTHORIZE: {
                result = this.paymentApi.createAuthorizationWithPaymentControl(account, paymentMethodId, paymentId, json.getAmount(), currency, json.getPaymentExternalKey(), json.getTransactionExternalKey(), pluginProperties, paymentOptions, callContext);
                break;
            }
            case PURCHASE: {
                result = this.paymentApi.createPurchaseWithPaymentControl(account, paymentMethodId, paymentId, json.getAmount(), currency, json.getPaymentExternalKey(), json.getTransactionExternalKey(), pluginProperties, paymentOptions, callContext);
                break;
            }
            case CREDIT: {
                result = this.paymentApi.createCreditWithPaymentControl(account, paymentMethodId, paymentId, json.getAmount(), currency, json.getPaymentExternalKey(), json.getTransactionExternalKey(), pluginProperties, paymentOptions, callContext);
                break;
            }
            default: {
                return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)("TransactionType " + transactionType + " is not allowed for an account")).build();
            }
        }
        if (result == null) {
            return Response.noContent().build();
        }
        return this.uriBuilder.buildResponse(PaymentResource.class, "getPayment", result.getId(), uriInfo.getBaseUri().toString());
    }

    @TimedResource
    @GET
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/overdue")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve overdue state for account", response=OverdueStateJson.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid account id supplied"), @ApiResponse(code=404, message="Account not found")})
    public Response getOverdueAccount(@PathParam(value="accountId") String accountId, @javax.ws.rs.core.Context HttpServletRequest request) throws AccountApiException, OverdueException, OverdueApiException {
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        Account account = this.accountUserApi.getAccountById(UUID.fromString(accountId), tenantContext);
        OverdueState overdueState = this.overdueApi.getOverdueStateFor((ImmutableAccountData)account, tenantContext);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)new OverdueStateJson(overdueState, this.paymentConfig)).build();
    }

    @TimedResource
    @GET
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve account custom fields", response=CustomFieldJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid account id supplied")})
    public Response getCustomFields(@PathParam(value="accountId") String id, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @javax.ws.rs.core.Context HttpServletRequest request) {
        return super.getCustomFields(UUID.fromString(id), auditMode, this.context.createContext((ServletRequest)request));
    }

    @TimedResource
    @POST
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Add custom fields to account")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid account id supplied")})
    public Response createCustomFields(@PathParam(value="accountId") String id, List<CustomFieldJson> customFields, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request, @javax.ws.rs.core.Context UriInfo uriInfo) throws CustomFieldApiException {
        return super.createCustomFields(UUID.fromString(id), customFields, this.context.createContext(createdBy, reason, comment, (ServletRequest)request), uriInfo);
    }

    @TimedResource
    @DELETE
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Remove custom fields from account")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid account id supplied")})
    public Response deleteCustomFields(@PathParam(value="accountId") String id, @QueryParam(value="customFieldList") String customFieldList, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request) throws CustomFieldApiException {
        return super.deleteCustomFields(UUID.fromString(id), customFieldList, this.context.createContext(createdBy, reason, comment, (ServletRequest)request));
    }

    @TimedResource
    @GET
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/tags")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve account tags", response=TagJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid account id supplied"), @ApiResponse(code=404, message="Account not found")})
    public Response getTags(@PathParam(value="accountId") String accountIdString, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @QueryParam(value="includedDeleted") @DefaultValue(value="false") Boolean includedDeleted, @javax.ws.rs.core.Context HttpServletRequest request) throws TagDefinitionApiException {
        UUID accountId = UUID.fromString(accountIdString);
        return super.getTags(accountId, accountId, auditMode, includedDeleted, this.context.createContext((ServletRequest)request));
    }

    @TimedResource
    @GET
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/allTags")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve account tags", response=TagJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid account id supplied"), @ApiResponse(code=404, message="Account not found")})
    public Response getAllTags(@PathParam(value="accountId") String accountIdString, @QueryParam(value="objectType") ObjectType objectType, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @QueryParam(value="includedDeleted") @DefaultValue(value="false") Boolean includedDeleted, @javax.ws.rs.core.Context HttpServletRequest request) throws TagDefinitionApiException {
        UUID accountId = UUID.fromString(accountIdString);
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        List tags = objectType != null ? this.tagUserApi.getTagsForAccountType(accountId, objectType, includedDeleted.booleanValue(), tenantContext) : this.tagUserApi.getTagsForAccount(accountId, includedDeleted.booleanValue(), tenantContext);
        return this.createTagResponse(accountId, tags, auditMode, tenantContext);
    }

    @TimedResource
    @POST
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/tags")
    @Produces(value={"application/json"})
    @ApiOperation(value="Add tags to account")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid account id supplied")})
    public Response createTags(@PathParam(value="accountId") String id, @QueryParam(value="tagList") String tagList, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context UriInfo uriInfo, @javax.ws.rs.core.Context HttpServletRequest request) throws TagApiException {
        return super.createTags(UUID.fromString(id), tagList, uriInfo, this.context.createContext(createdBy, reason, comment, (ServletRequest)request));
    }

    @TimedResource
    @DELETE
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/tags")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Remove tags from account")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid account id supplied or account does not have a default payment method (AUTO_PAY_OFF tag only)")})
    public Response deleteTags(@PathParam(value="accountId") String id, @QueryParam(value="tagList") String tagList, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request) throws TagApiException, AccountApiException {
        Account account;
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        Collection<UUID> tagDefinitionUUIDs = this.getTagDefinitionUUIDs(tagList);
        boolean isTagAutoPayOff = false;
        for (UUID cur : tagDefinitionUUIDs) {
            if (!cur.equals(ControlTagType.AUTO_PAY_OFF.getId())) continue;
            isTagAutoPayOff = true;
            break;
        }
        UUID accountId = UUID.fromString(id);
        if (isTagAutoPayOff && (account = this.accountUserApi.getAccountById(accountId, (TenantContext)callContext)).getPaymentMethodId() == null) {
            throw new TagApiException(ErrorCode.TAG_CANNOT_BE_REMOVED, new Object[]{ControlTagType.AUTO_PAY_OFF, " the account does not have a default payment method"});
        }
        return super.deleteTags(UUID.fromString(id), tagList, callContext);
    }

    @TimedResource
    @GET
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/emails")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve an account emails", response=AccountEmailJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid account id supplied")})
    public Response getEmails(@PathParam(value="accountId") String id, @javax.ws.rs.core.Context HttpServletRequest request) {
        UUID accountId = UUID.fromString(id);
        List emails = this.accountUserApi.getEmails(accountId, this.context.createContext((ServletRequest)request));
        ArrayList<AccountEmailJson> emailsJson = new ArrayList<AccountEmailJson>();
        for (AccountEmail email : emails) {
            emailsJson.add(new AccountEmailJson(email.getAccountId().toString(), email.getEmail()));
        }
        return Response.status((Response.Status)Response.Status.OK).entity(emailsJson).build();
    }

    @TimedResource
    @POST
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/emails")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Add account email")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid account id supplied"), @ApiResponse(code=404, message="Account not found")})
    public Response addEmail(final AccountEmailJson json, @PathParam(value="accountId") String id, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request, @javax.ws.rs.core.Context UriInfo uriInfo) throws AccountApiException {
        this.verifyNonNullOrEmpty(json, "AccountEmailJson body should be specified");
        this.verifyNonNullOrEmpty(json.getEmail(), "AccountEmailJson email needs to be set");
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        UUID accountId = UUID.fromString(id);
        this.accountUserApi.getAccountById(accountId, (TenantContext)callContext);
        AccountEmail existingEmail = (AccountEmail)Iterables.tryFind((Iterable)this.accountUserApi.getEmails(accountId, (TenantContext)callContext), (Predicate)new Predicate<AccountEmail>(){

            public boolean apply(AccountEmail input) {
                return input.getEmail().equals(json.getEmail());
            }
        }).orNull();
        if (existingEmail == null) {
            this.accountUserApi.addEmail(accountId, json.toAccountEmail(UUIDs.randomUUID()), callContext);
        }
        return this.uriBuilder.buildResponse(uriInfo, AccountResource.class, "getEmails", (Object)json.getAccountId());
    }

    @TimedResource
    @DELETE
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/emails/{email}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete email from account")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid account id supplied")})
    public Response removeEmail(@PathParam(value="accountId") String id, @PathParam(value="email") String email, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request) {
        UUID accountId = UUID.fromString(id);
        List emails = this.accountUserApi.getEmails(accountId, this.context.createContext((ServletRequest)request));
        for (AccountEmail cur : emails) {
            if (!cur.getEmail().equals(email)) continue;
            AccountEmailJson accountEmailJson = new AccountEmailJson(accountId.toString(), email);
            AccountEmail accountEmail = accountEmailJson.toAccountEmail(cur.getId());
            this.accountUserApi.removeEmail(accountId, accountEmail, this.context.createContext(createdBy, reason, comment, (ServletRequest)request));
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @Override
    protected ObjectType getObjectType() {
        return ObjectType.ACCOUNT;
    }
}

