/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.mappers;

import javax.inject.Singleton;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.jaxrs.mappers.ExceptionMapperBase;
import org.killbill.billing.tenant.api.TenantApiException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
@Provider
public class TenantApiExceptionMapper
extends ExceptionMapperBase
implements ExceptionMapper<TenantApiException> {
    private final UriInfo uriInfo;

    public TenantApiExceptionMapper(@Context UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    public Response toResponse(TenantApiException exception) {
        if (exception.getCode() == ErrorCode.TENANT_ALREADY_EXISTS.getCode()) {
            return this.buildConflictingRequestResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.TENANT_DOES_NOT_EXIST_FOR_ID.getCode()) {
            return this.buildNotFoundResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.TENANT_DOES_NOT_EXIST_FOR_KEY.getCode()) {
            return this.buildNotFoundResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.TENANT_DOES_NOT_EXIST_FOR_API_KEY.getCode()) {
            return this.buildNotFoundResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.TENANT_CREATION_FAILED.getCode()) {
            return this.buildInternalErrorResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.TENANT_UPDATE_FAILED.getCode()) {
            return this.buildInternalErrorResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.TENANT_NO_SUCH_KEY.getCode()) {
            return this.buildNotFoundResponse((Exception)exception, this.uriInfo);
        }
        return this.fallback((Exception)exception, this.uriInfo);
    }
}

