/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.mappers;

import javax.inject.Singleton;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.entitlement.api.SubscriptionApiException;
import org.killbill.billing.jaxrs.mappers.ExceptionMapperBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
@Provider
public class SubscriptionApiExceptionMapper
extends ExceptionMapperBase
implements ExceptionMapper<SubscriptionApiException> {
    private final UriInfo uriInfo;

    public SubscriptionApiExceptionMapper(@Context UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    public Response toResponse(SubscriptionApiException exception) {
        if (exception.getCode() == ErrorCode.SUB_ACCOUNT_IS_OVERDUE_BLOCKED.getCode()) {
            return this.buildBadRequestResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.SUB_BUNDLE_IS_OVERDUE_BLOCKED.getCode()) {
            return this.buildBadRequestResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.SUB_CANCEL_BAD_STATE.getCode()) {
            return this.buildInternalErrorResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.SUB_CHANGE_DRY_RUN_NOT_BP.getCode()) {
            return this.buildBadRequestResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.SUB_CHANGE_FUTURE_CANCELLED.getCode()) {
            return this.buildBadRequestResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.SUB_CHANGE_NON_ACTIVE.getCode()) {
            return this.buildBadRequestResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.SUB_CREATE_AO_ALREADY_INCLUDED.getCode()) {
            return this.buildBadRequestResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.SUB_CREATE_AO_BP_NON_ACTIVE.getCode()) {
            return this.buildBadRequestResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.SUB_CREATE_AO_NOT_AVAILABLE.getCode()) {
            return this.buildBadRequestResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.SUB_CREATE_BAD_PHASE.getCode()) {
            return this.buildBadRequestResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.SUB_CREATE_BP_EXISTS.getCode()) {
            return this.buildBadRequestResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.SUB_CREATE_NO_BP.getCode()) {
            return this.buildBadRequestResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.SUB_CREATE_NO_BUNDLE.getCode()) {
            return this.buildBadRequestResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.SUB_GET_INVALID_BUNDLE_ID.getCode()) {
            return this.buildNotFoundResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.SUB_GET_INVALID_BUNDLE_KEY.getCode()) {
            return this.buildNotFoundResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.SUB_GET_NO_BUNDLE_FOR_SUBSCRIPTION.getCode()) {
            return this.buildNotFoundResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.SUB_GET_NO_SUCH_BASE_SUBSCRIPTION.getCode()) {
            return this.buildNotFoundResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.SUB_INVALID_REQUESTED_DATE.getCode()) {
            return this.buildBadRequestResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.SUB_INVALID_REQUESTED_FUTURE_DATE.getCode()) {
            return this.buildBadRequestResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.SUB_INVALID_SUBSCRIPTION_ID.getCode()) {
            return this.buildNotFoundResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.SUB_RECREATE_BAD_STATE.getCode()) {
            return this.buildInternalErrorResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.SUB_UNCANCEL_BAD_STATE.getCode()) {
            return this.buildInternalErrorResponse((Exception)exception, this.uriInfo);
        }
        return this.fallback((Exception)exception, this.uriInfo);
    }
}

