/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.mappers;

import javax.inject.Singleton;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.jaxrs.mappers.ExceptionMapperBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
@Provider
public class AccountApiExceptionMapper
extends ExceptionMapperBase
implements ExceptionMapper<AccountApiException> {
    private final UriInfo uriInfo;

    public AccountApiExceptionMapper(@Context UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    public Response toResponse(AccountApiException exception) {
        if (exception.getCode() == ErrorCode.ACCOUNT_ALREADY_EXISTS.getCode()) {
            return this.buildConflictingRequestResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.ACCOUNT_CANNOT_CHANGE_EXTERNAL_KEY.getCode()) {
            return this.buildBadRequestResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.ACCOUNT_CANNOT_MAP_NULL_KEY.getCode()) {
            return this.buildBadRequestResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.ACCOUNT_CREATION_FAILED.getCode()) {
            return this.buildInternalErrorResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.ACCOUNT_DOES_NOT_EXIST_FOR_ID.getCode()) {
            return this.buildNotFoundResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.ACCOUNT_DOES_NOT_EXIST_FOR_KEY.getCode()) {
            return this.buildNotFoundResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.ACCOUNT_INVALID_NAME.getCode()) {
            return this.buildBadRequestResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.ACCOUNT_UPDATE_FAILED.getCode()) {
            return this.buildInternalErrorResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.ACCOUNT_DOES_NOT_EXIST_FOR_RECORD_ID.getCode()) {
            return this.buildNotFoundResponse((Exception)exception, this.uriInfo);
        }
        return this.fallback((Exception)exception, this.uriInfo);
    }
}

