/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.wordnik.swagger.annotations.ApiModelProperty;
import org.killbill.billing.jaxrs.json.JsonBase;
import org.killbill.billing.tenant.api.Tenant;
import org.killbill.billing.tenant.api.TenantData;

public class TenantJson
extends JsonBase {
    @ApiModelProperty(dataType="java.util.UUID")
    private final String tenantId;
    private final String externalKey;
    @ApiModelProperty(required=true)
    private final String apiKey;
    @ApiModelProperty(required=true)
    private final String apiSecret;

    @JsonCreator
    public TenantJson(@JsonProperty(value="tenantId") String tenantId, @JsonProperty(value="externalKey") String externalKey, @JsonProperty(value="apiKey") String apiKey, @JsonProperty(value="apiSecret") String apiSecret) {
        this.tenantId = tenantId;
        this.externalKey = externalKey;
        this.apiKey = apiKey;
        this.apiSecret = apiSecret;
    }

    public TenantJson(Tenant tenant) {
        this(tenant.getId().toString(), tenant.getExternalKey(), tenant.getApiKey(), tenant.getApiSecret());
    }

    public TenantData toTenantData() {
        return new TenantData(){

            public String getExternalKey() {
                return TenantJson.this.externalKey;
            }

            public String getApiKey() {
                return TenantJson.this.apiKey;
            }

            public String getApiSecret() {
                return TenantJson.this.apiSecret;
            }
        };
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getExternalKey() {
        return this.externalKey;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getApiSecret() {
        return this.apiSecret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TenantJson");
        sb.append("{tenantId='").append(this.tenantId).append('\'');
        sb.append(", externalKey='").append(this.externalKey).append('\'');
        sb.append(", apiKey='").append(this.apiKey).append('\'');
        sb.append(", apiSecret='").append(this.apiSecret).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TenantJson that = (TenantJson)o;
        if (this.apiKey != null ? !this.apiKey.equals(that.apiKey) : that.apiKey != null) {
            return false;
        }
        if (this.apiSecret != null ? !this.apiSecret.equals(that.apiSecret) : that.apiSecret != null) {
            return false;
        }
        if (this.externalKey != null ? !this.externalKey.equals(that.externalKey) : that.externalKey != null) {
            return false;
        }
        return !(this.tenantId != null ? !this.tenantId.equals(that.tenantId) : that.tenantId != null);
    }

    public int hashCode() {
        int result = this.tenantId != null ? this.tenantId.hashCode() : 0;
        result = 31 * result + (this.externalKey != null ? this.externalKey.hashCode() : 0);
        result = 31 * result + (this.apiKey != null ? this.apiKey.hashCode() : 0);
        result = 31 * result + (this.apiSecret != null ? this.apiSecret.hashCode() : 0);
        return result;
    }
}

