/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.wordnik.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.UUID;
import org.joda.time.LocalDate;
import org.killbill.billing.usage.api.SubscriptionUsageRecord;
import org.killbill.billing.usage.api.UnitUsageRecord;
import org.killbill.billing.usage.api.UsageRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscriptionUsageRecordJson {
    @ApiModelProperty(dataType="java.util.UUID", required=true)
    private final String subscriptionId;
    @ApiModelProperty(required=true)
    private final List<UnitUsageRecordJson> unitUsageRecords;

    @JsonCreator
    public SubscriptionUsageRecordJson(@JsonProperty(value="subscriptionId") String subscriptionId, @JsonProperty(value="unitUsageRecords") List<UnitUsageRecordJson> unitUsageRecords) {
        this.subscriptionId = subscriptionId;
        this.unitUsageRecords = unitUsageRecords;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public List<UnitUsageRecordJson> getUnitUsageRecords() {
        return this.unitUsageRecords;
    }

    public SubscriptionUsageRecord toSubscriptionUsageRecord() {
        ImmutableList tmp = ImmutableList.copyOf((Iterable)Iterables.transform(this.unitUsageRecords, (Function)new Function<UnitUsageRecordJson, UnitUsageRecord>(){

            public UnitUsageRecord apply(UnitUsageRecordJson input) {
                return input.toUnitUsageRecord();
            }
        }));
        SubscriptionUsageRecord result = new SubscriptionUsageRecord(UUID.fromString(this.subscriptionId), (List)tmp);
        return result;
    }

    public static class UsageRecordJson {
        private final LocalDate recordDate;
        private final Long amount;

        @JsonCreator
        public UsageRecordJson(@JsonProperty(value="recordDate") LocalDate recordDate, @JsonProperty(value="amount") Long amount) {
            this.recordDate = recordDate;
            this.amount = amount;
        }

        public LocalDate getRecordDate() {
            return this.recordDate;
        }

        public Long getAmount() {
            return this.amount;
        }

        public UsageRecord toUsageRecord() {
            return new UsageRecord(this.recordDate, this.amount);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UnitUsageRecordJson {
        private final String unitType;
        private final List<UsageRecordJson> usageRecords;

        @JsonCreator
        public UnitUsageRecordJson(@JsonProperty(value="unitType") String unitType, @JsonProperty(value="usageRecords") List<UsageRecordJson> usageRecords) {
            this.unitType = unitType;
            this.usageRecords = usageRecords;
        }

        public String getUnitType() {
            return this.unitType;
        }

        public List<UsageRecordJson> getUsageRecords() {
            return this.usageRecords;
        }

        public UnitUsageRecord toUnitUsageRecord() {
            ImmutableList tmp = ImmutableList.copyOf((Iterable)Iterables.transform(this.usageRecords, (Function)new Function<UsageRecordJson, UsageRecord>(){

                public UsageRecord apply(UsageRecordJson input) {
                    return input.toUsageRecord();
                }
            }));
            return new UnitUsageRecord(this.unitType, (List)tmp);
        }
    }
}

