/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.wordnik.swagger.annotations.ApiModelProperty;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.catalog.api.PriceList;
import org.killbill.billing.catalog.api.Product;
import org.killbill.billing.entitlement.api.Subscription;
import org.killbill.billing.entitlement.api.SubscriptionEvent;
import org.killbill.billing.jaxrs.json.AuditLogJson;
import org.killbill.billing.jaxrs.json.JsonBase;
import org.killbill.billing.jaxrs.json.PhasePriceOverrideJson;
import org.killbill.billing.util.audit.AccountAuditLogs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscriptionJson
extends JsonBase {
    @ApiModelProperty(dataType="java.util.UUID")
    private final String accountId;
    @ApiModelProperty(dataType="java.util.UUID")
    private final String bundleId;
    @ApiModelProperty(dataType="java.util.UUID")
    private final String subscriptionId;
    private final String externalKey;
    private final LocalDate startDate;
    @ApiModelProperty(required=true)
    private final String productName;
    @ApiModelProperty(dataType="org.killbill.billing.catalog.api.ProductCategory", required=true)
    private final String productCategory;
    @ApiModelProperty(dataType="org.killbill.billing.catalog.api.BillingPeriod", required=true)
    private final String billingPeriod;
    @ApiModelProperty(dataType="org.killbill.billing.catalog.api.PhaseType")
    private final String phaseType;
    @ApiModelProperty(required=true)
    private final String priceList;
    @ApiModelProperty(dataType="org.killbill.billing.entitlement.api.Entitlement.EntitlementState")
    private final String state;
    @ApiModelProperty(dataType="org.killbill.billing.entitlement.api.Entitlement.EntitlementSourceType")
    private final String sourceType;
    private final LocalDate cancelledDate;
    private final LocalDate chargedThroughDate;
    private final LocalDate billingStartDate;
    private final LocalDate billingEndDate;
    private final List<EventSubscriptionJson> events;
    private final List<PhasePriceOverrideJson> priceOverrides;

    @JsonCreator
    public SubscriptionJson(@JsonProperty(value="accountId") @Nullable String accountId, @JsonProperty(value="bundleId") @Nullable String bundleId, @JsonProperty(value="subscriptionId") @Nullable String subscriptionId, @JsonProperty(value="externalKey") @Nullable String externalKey, @JsonProperty(value="startDate") @Nullable LocalDate startDate, @JsonProperty(value="productName") @Nullable String productName, @JsonProperty(value="productCategory") @Nullable String productCategory, @JsonProperty(value="billingPeriod") @Nullable String billingPeriod, @JsonProperty(value="phaseType") @Nullable String phaseType, @JsonProperty(value="priceList") @Nullable String priceList, @JsonProperty(value="state") @Nullable String state, @JsonProperty(value="sourceType") @Nullable String sourceType, @JsonProperty(value="cancelledDate") @Nullable LocalDate cancelledDate, @JsonProperty(value="chargedThroughDate") @Nullable LocalDate chargedThroughDate, @JsonProperty(value="billingStartDate") @Nullable LocalDate billingStartDate, @JsonProperty(value="billingEndDate") @Nullable LocalDate billingEndDate, @JsonProperty(value="events") @Nullable List<EventSubscriptionJson> events, @JsonProperty(value="priceOverrides") List<PhasePriceOverrideJson> priceOverrides, @JsonProperty(value="auditLogs") @Nullable List<AuditLogJson> auditLogs) {
        super(auditLogs);
        this.startDate = startDate;
        this.productName = productName;
        this.productCategory = productCategory;
        this.billingPeriod = billingPeriod;
        this.phaseType = phaseType;
        this.priceList = priceList;
        this.state = state;
        this.sourceType = sourceType;
        this.cancelledDate = cancelledDate;
        this.chargedThroughDate = chargedThroughDate;
        this.billingStartDate = billingStartDate;
        this.billingEndDate = billingEndDate;
        this.accountId = accountId;
        this.bundleId = bundleId;
        this.subscriptionId = subscriptionId;
        this.externalKey = externalKey;
        this.events = events;
        this.priceOverrides = priceOverrides;
    }

    public SubscriptionJson(Subscription subscription, @Nullable AccountAuditLogs accountAuditLogs) {
        super((List<AuditLogJson>)SubscriptionJson.toAuditLogJson(accountAuditLogs == null ? null : accountAuditLogs.getAuditLogsForSubscription(subscription.getId())));
        this.startDate = subscription.getEffectiveStartDate();
        this.productName = subscription.getLastActiveProduct() == null ? null : subscription.getLastActiveProduct().getName();
        this.productCategory = subscription.getLastActiveProductCategory() == null ? null : subscription.getLastActiveProductCategory().name();
        this.billingPeriod = subscription.getLastActivePlan() == null ? null : subscription.getLastActivePlan().getRecurringBillingPeriod().toString();
        this.phaseType = subscription.getLastActivePhase() == null ? null : subscription.getLastActivePhase().getPhaseType().toString();
        this.priceList = subscription.getLastActivePriceList() == null ? null : subscription.getLastActivePriceList().getName();
        this.state = subscription.getState().name();
        this.sourceType = subscription.getSourceType().name();
        this.cancelledDate = subscription.getEffectiveEndDate();
        this.chargedThroughDate = subscription.getChargedThroughDate();
        this.billingStartDate = subscription.getBillingStartDate();
        this.billingEndDate = subscription.getBillingEndDate();
        this.accountId = subscription.getAccountId().toString();
        this.bundleId = subscription.getBundleId().toString();
        this.subscriptionId = subscription.getId().toString();
        this.externalKey = subscription.getExternalKey();
        this.events = new LinkedList<EventSubscriptionJson>();
        for (SubscriptionEvent subscriptionEvent : subscription.getSubscriptionEvents()) {
            this.events.add(new EventSubscriptionJson(subscriptionEvent, accountAuditLogs));
        }
        this.priceOverrides = new LinkedList<PhasePriceOverrideJson>();
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getBundleId() {
        return this.bundleId;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public String getExternalKey() {
        return this.externalKey;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getProductCategory() {
        return this.productCategory;
    }

    public String getBillingPeriod() {
        return this.billingPeriod;
    }

    public String getPhaseType() {
        return this.phaseType;
    }

    public String getPriceList() {
        return this.priceList;
    }

    public String getState() {
        return this.state;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public LocalDate getCancelledDate() {
        return this.cancelledDate;
    }

    public LocalDate getChargedThroughDate() {
        return this.chargedThroughDate;
    }

    public LocalDate getBillingStartDate() {
        return this.billingStartDate;
    }

    public LocalDate getBillingEndDate() {
        return this.billingEndDate;
    }

    public List<EventSubscriptionJson> getEvents() {
        return this.events;
    }

    public List<PhasePriceOverrideJson> getPriceOverrides() {
        return this.priceOverrides;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SubscriptionJson{");
        sb.append("accountId='").append(this.accountId).append('\'');
        sb.append(", bundleId='").append(this.bundleId).append('\'');
        sb.append(", subscriptionId='").append(this.subscriptionId).append('\'');
        sb.append(", externalKey='").append(this.externalKey).append('\'');
        sb.append(", startDate=").append(this.startDate);
        sb.append(", productName='").append(this.productName).append('\'');
        sb.append(", productCategory='").append(this.productCategory).append('\'');
        sb.append(", billingPeriod='").append(this.billingPeriod).append('\'');
        sb.append(", phaseType='").append(this.phaseType).append('\'');
        sb.append(", priceList='").append(this.priceList).append('\'');
        sb.append(", state='").append(this.state).append('\'');
        sb.append(", sourceType='").append(this.sourceType).append('\'');
        sb.append(", cancelledDate=").append(this.cancelledDate);
        sb.append(", chargedThroughDate=").append(this.chargedThroughDate);
        sb.append(", billingStartDate=").append(this.billingStartDate);
        sb.append(", billingEndDate=").append(this.billingEndDate);
        sb.append(", events=").append(this.events);
        sb.append(", priceOverrides=").append(this.priceOverrides);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionJson that = (SubscriptionJson)o;
        if (this.accountId != null ? !this.accountId.equals(that.accountId) : that.accountId != null) {
            return false;
        }
        if (this.billingEndDate != null ? this.billingEndDate.compareTo((ReadablePartial)that.billingEndDate) != 0 : that.billingEndDate != null) {
            return false;
        }
        if (this.billingPeriod != null ? !this.billingPeriod.equals(that.billingPeriod) : that.billingPeriod != null) {
            return false;
        }
        if (this.billingStartDate != null ? this.billingStartDate.compareTo((ReadablePartial)that.billingStartDate) != 0 : that.billingStartDate != null) {
            return false;
        }
        if (this.bundleId != null ? !this.bundleId.equals(that.bundleId) : that.bundleId != null) {
            return false;
        }
        if (this.cancelledDate != null ? this.cancelledDate.compareTo((ReadablePartial)that.cancelledDate) != 0 : that.cancelledDate != null) {
            return false;
        }
        if (this.chargedThroughDate != null ? this.chargedThroughDate.compareTo((ReadablePartial)that.chargedThroughDate) != 0 : that.chargedThroughDate != null) {
            return false;
        }
        if (this.events != null ? !this.events.equals(that.events) : that.events != null) {
            return false;
        }
        if (this.externalKey != null ? !this.externalKey.equals(that.externalKey) : that.externalKey != null) {
            return false;
        }
        if (this.phaseType != null ? !this.phaseType.equals(that.phaseType) : that.phaseType != null) {
            return false;
        }
        if (this.priceList != null ? !this.priceList.equals(that.priceList) : that.priceList != null) {
            return false;
        }
        if (this.productCategory != null ? !this.productCategory.equals(that.productCategory) : that.productCategory != null) {
            return false;
        }
        if (this.productName != null ? !this.productName.equals(that.productName) : that.productName != null) {
            return false;
        }
        if (this.sourceType != null ? !this.sourceType.equals(that.sourceType) : that.sourceType != null) {
            return false;
        }
        if (this.startDate != null ? this.startDate.compareTo((ReadablePartial)that.startDate) != 0 : that.startDate != null) {
            return false;
        }
        if (this.state != null ? !this.state.equals(that.state) : that.state != null) {
            return false;
        }
        if (this.subscriptionId != null ? !this.subscriptionId.equals(that.subscriptionId) : that.subscriptionId != null) {
            return false;
        }
        return !(this.priceOverrides != null ? !this.priceOverrides.equals(that.priceOverrides) : that.priceOverrides != null);
    }

    public int hashCode() {
        int result = this.accountId != null ? this.accountId.hashCode() : 0;
        result = 31 * result + (this.bundleId != null ? this.bundleId.hashCode() : 0);
        result = 31 * result + (this.subscriptionId != null ? this.subscriptionId.hashCode() : 0);
        result = 31 * result + (this.externalKey != null ? this.externalKey.hashCode() : 0);
        result = 31 * result + (this.startDate != null ? this.startDate.hashCode() : 0);
        result = 31 * result + (this.productName != null ? this.productName.hashCode() : 0);
        result = 31 * result + (this.productCategory != null ? this.productCategory.hashCode() : 0);
        result = 31 * result + (this.billingPeriod != null ? this.billingPeriod.hashCode() : 0);
        result = 31 * result + (this.phaseType != null ? this.phaseType.hashCode() : 0);
        result = 31 * result + (this.priceList != null ? this.priceList.hashCode() : 0);
        result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
        result = 31 * result + (this.sourceType != null ? this.sourceType.hashCode() : 0);
        result = 31 * result + (this.cancelledDate != null ? this.cancelledDate.hashCode() : 0);
        result = 31 * result + (this.chargedThroughDate != null ? this.chargedThroughDate.hashCode() : 0);
        result = 31 * result + (this.billingStartDate != null ? this.billingStartDate.hashCode() : 0);
        result = 31 * result + (this.billingEndDate != null ? this.billingEndDate.hashCode() : 0);
        result = 31 * result + (this.events != null ? this.events.hashCode() : 0);
        result = 31 * result + (this.priceOverrides != null ? this.priceOverrides.hashCode() : 0);
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EventSubscriptionJson
    extends JsonBase {
        private final String eventId;
        private final String billingPeriod;
        private final LocalDate requestedDate;
        private final LocalDate effectiveDate;
        private final String product;
        private final String priceList;
        @ApiModelProperty(dataType="org.killbill.billing.entitlement.api.SubscriptionEventType")
        private final String eventType;
        private final Boolean isBlockedBilling;
        private final Boolean isBlockedEntitlement;
        private final String serviceName;
        private final String serviceStateName;
        private final String phase;

        @JsonCreator
        public EventSubscriptionJson(@JsonProperty(value="eventId") String eventId, @JsonProperty(value="billingPeriod") String billingPeriod, @JsonProperty(value="requestedDt") LocalDate requestedDate, @JsonProperty(value="effectiveDt") LocalDate effectiveDate, @JsonProperty(value="product") String product, @JsonProperty(value="priceList") String priceList, @JsonProperty(value="eventType") String eventType, @JsonProperty(value="isBlockedBilling") Boolean isBlockedBilling, @JsonProperty(value="isBlockedEntitlement") Boolean isBlockedEntitlement, @JsonProperty(value="serviceName") String serviceName, @JsonProperty(value="serviceStateName") String serviceStateName, @JsonProperty(value="phase") String phase, @JsonProperty(value="auditLogs") @Nullable List<AuditLogJson> auditLogs) {
            super(auditLogs);
            this.eventId = eventId;
            this.billingPeriod = billingPeriod;
            this.requestedDate = requestedDate;
            this.effectiveDate = effectiveDate;
            this.product = product;
            this.priceList = priceList;
            this.eventType = eventType;
            this.isBlockedBilling = isBlockedBilling;
            this.isBlockedEntitlement = isBlockedEntitlement;
            this.serviceName = serviceName;
            this.serviceStateName = serviceStateName;
            this.phase = phase;
        }

        public EventSubscriptionJson(SubscriptionEvent subscriptionEvent, @Nullable AccountAuditLogs accountAuditLogs) {
            super((List<AuditLogJson>)EventSubscriptionJson.toAuditLogJson(accountAuditLogs == null ? null : accountAuditLogs.getAuditLogsForSubscriptionEvent(subscriptionEvent.getId())));
            BillingPeriod billingPeriod = subscriptionEvent.getNextBillingPeriod() != null ? subscriptionEvent.getNextBillingPeriod() : subscriptionEvent.getPrevBillingPeriod();
            Product product = subscriptionEvent.getNextProduct() != null ? subscriptionEvent.getNextProduct() : subscriptionEvent.getPrevProduct();
            PriceList priceList = subscriptionEvent.getNextPriceList() != null ? subscriptionEvent.getNextPriceList() : subscriptionEvent.getPrevPriceList();
            PlanPhase phase = subscriptionEvent.getNextPhase() != null ? subscriptionEvent.getNextPhase() : subscriptionEvent.getPrevPhase();
            this.eventId = subscriptionEvent.getId().toString();
            this.billingPeriod = billingPeriod != null ? billingPeriod.toString() : null;
            this.requestedDate = subscriptionEvent.getRequestedDate();
            this.effectiveDate = subscriptionEvent.getEffectiveDate();
            this.product = product != null ? product.getName() : null;
            this.priceList = priceList != null ? priceList.getName() : null;
            this.eventType = subscriptionEvent.getSubscriptionEventType().toString();
            this.isBlockedBilling = subscriptionEvent.isBlockedBilling();
            this.isBlockedEntitlement = subscriptionEvent.isBlockedEntitlement();
            this.serviceName = subscriptionEvent.getServiceName();
            this.serviceStateName = subscriptionEvent.getServiceStateName();
            this.phase = phase != null ? phase.getName() : null;
        }

        public String getEventId() {
            return this.eventId;
        }

        public String getBillingPeriod() {
            return this.billingPeriod;
        }

        public LocalDate getRequestedDate() {
            return this.requestedDate;
        }

        public LocalDate getEffectiveDate() {
            return this.effectiveDate;
        }

        public String getProduct() {
            return this.product;
        }

        public String getPriceList() {
            return this.priceList;
        }

        public String getEventType() {
            return this.eventType;
        }

        public Boolean getIsBlockedBilling() {
            return this.isBlockedBilling;
        }

        public Boolean getIsBlockedEntitlement() {
            return this.isBlockedEntitlement;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public String getServiceStateName() {
            return this.serviceStateName;
        }

        public String getPhase() {
            return this.phase;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("EventSubscriptionJson{");
            sb.append("eventId='").append(this.eventId).append('\'');
            sb.append(", billingPeriod='").append(this.billingPeriod).append('\'');
            sb.append(", requestedDate=").append(this.requestedDate);
            sb.append(", effectiveDate=").append(this.effectiveDate);
            sb.append(", product='").append(this.product).append('\'');
            sb.append(", priceList='").append(this.priceList).append('\'');
            sb.append(", eventType='").append(this.eventType).append('\'');
            sb.append(", isBlockedBilling=").append(this.isBlockedBilling);
            sb.append(", isBlockedEntitlement=").append(this.isBlockedEntitlement);
            sb.append(", serviceName='").append(this.serviceName).append('\'');
            sb.append(", serviceStateName='").append(this.serviceStateName).append('\'');
            sb.append(", phase='").append(this.phase).append('\'');
            sb.append('}');
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EventSubscriptionJson that = (EventSubscriptionJson)o;
            if (this.billingPeriod != null ? !this.billingPeriod.equals(that.billingPeriod) : that.billingPeriod != null) {
                return false;
            }
            if (this.effectiveDate != null ? this.effectiveDate.compareTo((ReadablePartial)that.effectiveDate) != 0 : that.effectiveDate != null) {
                return false;
            }
            if (this.eventId != null ? !this.eventId.equals(that.eventId) : that.eventId != null) {
                return false;
            }
            if (this.eventType != null ? !this.eventType.equals(that.eventType) : that.eventType != null) {
                return false;
            }
            if (this.isBlockedBilling != null ? !this.isBlockedBilling.equals(that.isBlockedBilling) : that.isBlockedBilling != null) {
                return false;
            }
            if (this.isBlockedEntitlement != null ? !this.isBlockedEntitlement.equals(that.isBlockedEntitlement) : that.isBlockedEntitlement != null) {
                return false;
            }
            if (this.phase != null ? !this.phase.equals(that.phase) : that.phase != null) {
                return false;
            }
            if (this.priceList != null ? !this.priceList.equals(that.priceList) : that.priceList != null) {
                return false;
            }
            if (this.product != null ? !this.product.equals(that.product) : that.product != null) {
                return false;
            }
            if (this.requestedDate != null ? this.requestedDate.compareTo((ReadablePartial)that.requestedDate) != 0 : that.requestedDate != null) {
                return false;
            }
            if (this.serviceName != null ? !this.serviceName.equals(that.serviceName) : that.serviceName != null) {
                return false;
            }
            return !(this.serviceStateName != null ? !this.serviceStateName.equals(that.serviceStateName) : that.serviceStateName != null);
        }

        public int hashCode() {
            int result = this.eventId != null ? this.eventId.hashCode() : 0;
            result = 31 * result + (this.billingPeriod != null ? this.billingPeriod.hashCode() : 0);
            result = 31 * result + (this.requestedDate != null ? this.requestedDate.hashCode() : 0);
            result = 31 * result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            result = 31 * result + (this.product != null ? this.product.hashCode() : 0);
            result = 31 * result + (this.priceList != null ? this.priceList.hashCode() : 0);
            result = 31 * result + (this.eventType != null ? this.eventType.hashCode() : 0);
            result = 31 * result + (this.isBlockedBilling != null ? this.isBlockedBilling.hashCode() : 0);
            result = 31 * result + (this.isBlockedEntitlement != null ? this.isBlockedEntitlement.hashCode() : 0);
            result = 31 * result + (this.serviceName != null ? this.serviceName.hashCode() : 0);
            result = 31 * result + (this.serviceStateName != null ? this.serviceStateName.hashCode() : 0);
            result = 31 * result + (this.phase != null ? this.phase.hashCode() : 0);
            return result;
        }
    }
}

