/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.wordnik.swagger.annotations.ApiModelProperty;
import org.apache.shiro.session.Session;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class SessionJson {
    private final String id;
    @ApiModelProperty(dataType="org.joda.time.DateTime")
    private final DateTime startDate;
    @ApiModelProperty(dataType="org.joda.time.DateTime")
    private final DateTime lastAccessDate;
    private final Long timeout;
    private final String host;

    @JsonCreator
    public SessionJson(@JsonProperty(value="id") String id, @JsonProperty(value="startDate") DateTime startDate, @JsonProperty(value="lastAccessDate") DateTime lastAccessDate, @JsonProperty(value="timeout") Long timeout, @JsonProperty(value="host") String host) {
        this.id = id;
        this.startDate = startDate;
        this.lastAccessDate = lastAccessDate;
        this.timeout = timeout;
        this.host = host;
    }

    public SessionJson(Session session) {
        this.id = session.getId() == null ? null : session.getId().toString();
        this.startDate = session.getStartTimestamp() == null ? null : new DateTime((Object)session.getStartTimestamp(), DateTimeZone.UTC);
        this.lastAccessDate = session.getLastAccessTime() == null ? null : new DateTime((Object)session.getLastAccessTime(), DateTimeZone.UTC);
        this.timeout = session.getTimeout();
        this.host = session.getHost();
    }

    public String getId() {
        return this.id;
    }

    public DateTime getStartDate() {
        return this.startDate;
    }

    public DateTime getLastAccessDate() {
        return this.lastAccessDate;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public String getHost() {
        return this.host;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SessionJson{");
        sb.append("id='").append(this.id).append('\'');
        sb.append(", startDate=").append(this.startDate);
        sb.append(", lastAccessDate=").append(this.lastAccessDate);
        sb.append(", timeout=").append(this.timeout);
        sb.append(", host='").append(this.host).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionJson that = (SessionJson)o;
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.lastAccessDate != null ? !this.lastAccessDate.equals((Object)that.lastAccessDate) : that.lastAccessDate != null) {
            return false;
        }
        if (this.startDate != null ? !this.startDate.equals((Object)that.startDate) : that.startDate != null) {
            return false;
        }
        return !(this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.startDate != null ? this.startDate.hashCode() : 0);
        result = 31 * result + (this.lastAccessDate != null ? this.lastAccessDate.hashCode() : 0);
        result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
        result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
        return result;
    }
}

