/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.wordnik.swagger.annotations.ApiModelProperty;
import java.util.List;
import org.joda.time.LocalDate;
import org.killbill.billing.usage.api.RolledUpUnit;
import org.killbill.billing.usage.api.RolledUpUsage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolledUpUsageJson {
    @ApiModelProperty(dataType="java.util.UUID")
    private final String subscriptionId;
    private final LocalDate startDate;
    private final LocalDate endDate;
    private final List<RolledUpUnitJson> rolledUpUnits;

    @JsonCreator
    public RolledUpUsageJson(@JsonProperty(value="subscriptionId") String subscriptionId, @JsonProperty(value="startDate") LocalDate startDate, @JsonProperty(value="endDate") LocalDate endDate, @JsonProperty(value="rolledUpUnits") List<RolledUpUnitJson> rolledUpUnits) {
        this.subscriptionId = subscriptionId;
        this.startDate = startDate;
        this.endDate = endDate;
        this.rolledUpUnits = rolledUpUnits;
    }

    public RolledUpUsageJson(RolledUpUsage input) {
        this(input.getSubscriptionId().toString(), input.getStart(), input.getEnd(), (List<RolledUpUnitJson>)ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)input.getRolledUpUnits(), (Function)new Function<RolledUpUnit, RolledUpUnitJson>(){

            public RolledUpUnitJson apply(RolledUpUnit input) {
                return new RolledUpUnitJson(input);
            }
        })));
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public List<RolledUpUnitJson> getRolledUpUnits() {
        return this.rolledUpUnits;
    }

    public static class RolledUpUnitJson {
        private final String unitType;
        private final Long amount;

        @JsonCreator
        public RolledUpUnitJson(@JsonProperty(value="unitType") String unitType, @JsonProperty(value="amount") Long amount) {
            this.unitType = unitType;
            this.amount = amount;
        }

        public RolledUpUnitJson(RolledUpUnit input) {
            this(input.getUnitType(), input.getAmount());
        }

        public String getUnitType() {
            return this.unitType;
        }

        public Long getAmount() {
            return this.amount;
        }
    }
}

