/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.killbill.commons.profiling.ProfilingData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfilingDataJson {
    private final List<ProfilingDataJsonItem> rawData;

    @JsonCreator
    public ProfilingDataJson(@JsonProperty(value="rawData") List<ProfilingDataJsonItem> rawData) {
        this.rawData = rawData;
    }

    public ProfilingDataJson(ProfilingData input) {
        List items = input.getRawData();
        if (items.isEmpty()) {
            this.rawData = Collections.emptyList();
            return;
        }
        ArrayList<ProfilingDataJsonItem> root = new ArrayList<ProfilingDataJsonItem>();
        Stack<ProfilingDataJsonItem> stack = new Stack<ProfilingDataJsonItem>();
        while (items.size() > 0) {
            ProfilingDataJsonItem jsonItem;
            ProfilingData.ProfilingDataItem cur = (ProfilingData.ProfilingDataItem)items.remove(0);
            if (cur.getLineType() == ProfilingData.LogLineType.START) {
                jsonItem = new ProfilingDataJsonItem(cur.getKey(), ProfilingDataJson.nanoToMicro(cur.getTimestampNsec()), Long.MIN_VALUE, new ArrayList<ProfilingDataJsonItem>());
                if (stack.isEmpty()) {
                    root.add(jsonItem);
                } else {
                    ProfilingDataJsonItem parent = (ProfilingDataJsonItem)stack.peek();
                    parent.addChild(jsonItem);
                }
                stack.push(jsonItem);
                continue;
            }
            jsonItem = (ProfilingDataJsonItem)stack.pop();
            jsonItem.setDurationUsec(ProfilingDataJson.nanoToMicro(cur.getTimestampNsec()) - jsonItem.getStartUsec());
        }
        Preconditions.checkState((boolean)stack.isEmpty());
        this.rawData = root;
    }

    public List<ProfilingDataJsonItem> getRawData() {
        return this.rawData;
    }

    private static Long nanoToMicro(Long nanoSec) {
        return nanoSec / 1000L;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ProfilingDataJsonItem {
        private final String name;
        private final Long startUsec;
        private final List<ProfilingDataJsonItem> calls;
        private Long durationUsec;

        @JsonCreator
        public ProfilingDataJsonItem(@JsonProperty(value="startUsec") String name, @JsonProperty(value="durationUsec") Long startUsec, @JsonProperty(value="calls") Long durationUsec, List<ProfilingDataJsonItem> calls) {
            this.name = name;
            this.startUsec = startUsec;
            this.durationUsec = durationUsec;
            this.calls = calls;
        }

        public String getName() {
            return this.name;
        }

        @JsonIgnore
        public Long getStartUsec() {
            return this.startUsec;
        }

        public Long getDurationUsec() {
            return this.durationUsec;
        }

        public void addChild(ProfilingDataJsonItem child) {
            this.calls.add(child);
        }

        public List<ProfilingDataJsonItem> getCalls() {
            return this.calls;
        }

        public void setDurationUsec(Long durationUsec) {
            this.durationUsec = durationUsec;
        }
    }
}

