/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Set;
import org.killbill.billing.osgi.api.PluginInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginInfoJson {
    private final String bundleSymbolicName;
    private final String pluginName;
    private final String version;
    private final boolean running;
    private final Set<PluginServiceInfoJson> services;

    @JsonCreator
    public PluginInfoJson(@JsonProperty(value="bundleSymbolicName") String bundleSymbolicName, @JsonProperty(value="pluginName") String pluginName, @JsonProperty(value="version") String version, @JsonProperty(value="running") boolean running, @JsonProperty(value="services") Set<PluginServiceInfoJson> services) {
        this.bundleSymbolicName = bundleSymbolicName;
        this.pluginName = pluginName;
        this.version = version;
        this.running = running;
        this.services = services;
    }

    public PluginInfoJson(PluginInfo input) {
        this(input.getBundleSymbolicName(), input.getPluginName(), input.getVersion(), input.isRunning(), (Set<PluginServiceInfoJson>)ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)input.getServices(), (Function)new Function<PluginInfo.PluginServiceInfo, PluginServiceInfoJson>(){

            public PluginServiceInfoJson apply(PluginInfo.PluginServiceInfo input) {
                return new PluginServiceInfoJson(input.getServiceTypeName(), input.getRegistrationName());
            }
        })));
    }

    public String getBundleSymbolicName() {
        return this.bundleSymbolicName;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isRunning() {
        return this.running;
    }

    public Set<PluginServiceInfoJson> getServices() {
        return this.services;
    }

    public static class PluginServiceInfoJson {
        private final String serviceTypeName;
        private final String registrationName;

        @JsonCreator
        public PluginServiceInfoJson(@JsonProperty(value="serviceTypeName") String serviceTypeName, @JsonProperty(value="registrationName") String registrationName) {
            this.serviceTypeName = serviceTypeName;
            this.registrationName = registrationName;
        }

        public String getServiceTypeName() {
            return this.serviceTypeName;
        }

        public String getRegistrationName() {
            return this.registrationName;
        }
    }
}

