/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.List;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.CurrencyValueNull;
import org.killbill.billing.catalog.api.Listing;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.Price;
import org.killbill.billing.jaxrs.json.CatalogJsonSimple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanDetailJson {
    final String product;
    final String plan;
    final BillingPeriod finalPhaseBillingPeriod;
    final String priceList;
    final List<CatalogJsonSimple.PriceJson> finalPhaseRecurringPrice;

    @JsonCreator
    public PlanDetailJson(@JsonProperty(value="product") String product, @JsonProperty(value="plan") String plan, @JsonProperty(value="final_phase_billing_period") BillingPeriod finalPhaseBillingPeriod, @JsonProperty(value="priceList") String priceList, @JsonProperty(value="final_phase_recurring_price") List<CatalogJsonSimple.PriceJson> finalPhaseRecurringPrice) {
        this.product = product;
        this.plan = plan;
        this.finalPhaseBillingPeriod = finalPhaseBillingPeriod;
        this.priceList = priceList;
        this.finalPhaseRecurringPrice = finalPhaseRecurringPrice;
    }

    public PlanDetailJson(Listing listing) {
        Plan plan = listing.getPlan();
        if (plan == null) {
            this.product = null;
            this.plan = null;
            this.finalPhaseBillingPeriod = null;
            this.finalPhaseRecurringPrice = ImmutableList.of();
        } else {
            this.product = plan.getProduct() == null ? null : plan.getProduct().getName();
            this.plan = plan.getName();
            this.finalPhaseBillingPeriod = plan.getRecurringBillingPeriod();
            this.finalPhaseRecurringPrice = plan.getFinalPhase() == null || plan.getFinalPhase().getRecurring() == null || plan.getFinalPhase().getRecurring().getRecurringPrice() == null || plan.getFinalPhase().getRecurring().getRecurringPrice().getPrices() == null ? ImmutableList.of() : Lists.transform((List)ImmutableList.copyOf((Object[])plan.getFinalPhase().getRecurring().getRecurringPrice().getPrices()), (Function)new Function<Price, CatalogJsonSimple.PriceJson>(){

                public CatalogJsonSimple.PriceJson apply(Price price) {
                    try {
                        return new CatalogJsonSimple.PriceJson(price);
                    }
                    catch (CurrencyValueNull e) {
                        return new CatalogJsonSimple.PriceJson(price.getCurrency().toString(), BigDecimal.ZERO);
                    }
                }
            });
        }
        this.priceList = listing.getPriceList() == null ? null : listing.getPriceList().getName();
    }

    public String getProduct() {
        return this.product;
    }

    public String getPlan() {
        return this.plan;
    }

    public BillingPeriod getFinalPhaseBillingPeriod() {
        return this.finalPhaseBillingPeriod;
    }

    public String getPriceList() {
        return this.priceList;
    }

    public List<CatalogJsonSimple.PriceJson> getFinalPhaseRecurringPrice() {
        return this.finalPhaseRecurringPrice;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PlanDetailJson{");
        sb.append("product='").append(this.product).append('\'');
        sb.append(", plan='").append(this.plan).append('\'');
        sb.append(", finalPhaseBillingPeriod=").append(this.finalPhaseBillingPeriod);
        sb.append(", priceList='").append(this.priceList).append('\'');
        sb.append(", finalPhaseRecurringPrice=").append(this.finalPhaseRecurringPrice);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlanDetailJson that = (PlanDetailJson)o;
        if (this.finalPhaseBillingPeriod != that.finalPhaseBillingPeriod) {
            return false;
        }
        if (this.finalPhaseRecurringPrice != null ? !this.finalPhaseRecurringPrice.equals(that.finalPhaseRecurringPrice) : that.finalPhaseRecurringPrice != null) {
            return false;
        }
        if (this.plan != null ? !this.plan.equals(that.plan) : that.plan != null) {
            return false;
        }
        if (this.priceList != null ? !this.priceList.equals(that.priceList) : that.priceList != null) {
            return false;
        }
        return !(this.product != null ? !this.product.equals(that.product) : that.product != null);
    }

    public int hashCode() {
        int result = this.product != null ? this.product.hashCode() : 0;
        result = 31 * result + (this.plan != null ? this.plan.hashCode() : 0);
        result = 31 * result + (this.finalPhaseBillingPeriod != null ? this.finalPhaseBillingPeriod.hashCode() : 0);
        result = 31 * result + (this.priceList != null ? this.priceList.hashCode() : 0);
        result = 31 * result + (this.finalPhaseRecurringPrice != null ? this.finalPhaseRecurringPrice.hashCode() : 0);
        return result;
    }
}

