/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Nullable;
import org.killbill.billing.catalog.DefaultPlanPhasePriceOverride;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.PhaseType;
import org.killbill.billing.catalog.api.PlanPhasePriceOverride;
import org.killbill.billing.catalog.api.PlanPhaseSpecifier;
import org.killbill.billing.catalog.api.PlanSpecifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhasePriceOverrideJson {
    private final String phaseName;
    private final String phaseType;
    private final BigDecimal fixedPrice;
    private final BigDecimal recurringPrice;

    @JsonCreator
    public PhasePriceOverrideJson(@JsonProperty(value="phaseName") String phaseName, @JsonProperty(value="phaseType") String phaseType, @Nullable @JsonProperty(value="fixedPrice") BigDecimal fixedPrice, @Nullable @JsonProperty(value="recurringPrice") BigDecimal recurringPrice) {
        this.phaseName = phaseName;
        this.phaseType = phaseType;
        this.fixedPrice = fixedPrice;
        this.recurringPrice = recurringPrice;
    }

    public BigDecimal getFixedPrice() {
        return this.fixedPrice;
    }

    public BigDecimal getRecurringPrice() {
        return this.recurringPrice;
    }

    public String getPhaseName() {
        return this.phaseName;
    }

    public String getPhaseType() {
        return this.phaseType;
    }

    public String toString() {
        return "PhasePriceOverrideJson{phaseName='" + this.phaseName + '\'' + "phaseType='" + this.phaseType + '\'' + ", fixedPrice=" + this.fixedPrice + ", recurringPrice=" + this.recurringPrice + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PhasePriceOverrideJson)) {
            return false;
        }
        PhasePriceOverrideJson that = (PhasePriceOverrideJson)o;
        if (this.fixedPrice != null ? !this.fixedPrice.equals(that.fixedPrice) : that.fixedPrice != null) {
            return false;
        }
        if (this.phaseName != null ? !this.phaseName.equals(that.phaseName) : that.phaseName != null) {
            return false;
        }
        if (this.phaseType != null ? !this.phaseType.equals(that.phaseType) : that.phaseType != null) {
            return false;
        }
        return !(this.recurringPrice != null ? !this.recurringPrice.equals(that.recurringPrice) : that.recurringPrice != null);
    }

    public int hashCode() {
        int result = this.phaseName != null ? this.phaseName.hashCode() : 0;
        result = 31 * result + (this.recurringPrice != null ? this.recurringPrice.hashCode() : 0);
        result = 31 * result + (this.phaseType != null ? this.phaseType.hashCode() : 0);
        result = 31 * result + (this.recurringPrice != null ? this.recurringPrice.hashCode() : 0);
        return result;
    }

    public static List<PlanPhasePriceOverride> toPlanPhasePriceOverrides(List<PhasePriceOverrideJson> input, final PlanSpecifier spec, final Currency currency) {
        if (input == null || input.isEmpty()) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Iterable)Iterables.transform(input, (Function)new Function<PhasePriceOverrideJson, PlanPhasePriceOverride>(){

            @Nullable
            public PlanPhasePriceOverride apply(@Nullable PhasePriceOverrideJson input) {
                if (input.getPhaseName() != null) {
                    return new DefaultPlanPhasePriceOverride(input.getPhaseName(), currency, input.getFixedPrice(), input.getRecurringPrice());
                }
                PhaseType phaseType = input.getPhaseType() != null ? PhaseType.valueOf((String)input.getPhaseType()) : null;
                PlanPhaseSpecifier planPhaseSpecifier = new PlanPhaseSpecifier(spec.getProductName(), spec.getProductCategory(), spec.getBillingPeriod(), spec.getPriceListName(), phaseType);
                return new DefaultPlanPhasePriceOverride(planPhaseSpecifier, currency, input.getFixedPrice(), input.getRecurringPrice());
            }
        }));
    }
}

